/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.panels;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVCalculatedMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.panels.ChildObjectEditorPanel2;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.diff.DBObjectComparator;

public class AVCalcMeasureObjectEditorPanel<T extends AVCalculatedMeasure, P extends AnalyticView>
extends ChildObjectEditorPanel2<T, P> {
    private DBObjectProvider prov;
    private JTextField expressionTextField;
    private JTextField formatTextField;
    private TreeSet<AVCalculatedMeasure> invalidMeasures = new TreeSet(new DBObjectComparator());

    public AVCalcMeasureObjectEditorPanel() {
        super("AVCalcMeasureTableEditorPanel", "CALCULATED_MEASURE2");
        this.layoutComponents();
    }

    private void loadMeasureData(AVCalculatedMeasure aVCalculatedMeasure) {
        String string = aVCalculatedMeasure.getMeasureExpression();
        if (string != null) {
            this.expressionTextField.setText(string);
        } else {
            this.expressionTextField.setText("");
        }
        String string2 = aVCalculatedMeasure.getMeasureFormat();
        if (string2 != null) {
            this.formatTextField.setText(string2);
        } else {
            this.formatTextField.setText("");
        }
        this.validate();
        this.repaint();
    }

    private void initImpl(DBObjectProvider dBObjectProvider) {
        this.prov = dBObjectProvider;
    }

    @Override
    protected void initialisePanel() {
        AVCalculatedMeasure aVCalculatedMeasure = (AVCalculatedMeasure)this.getChildObject();
        this.initImpl(this.getProvider());
        super.initialisePanel();
        if (aVCalculatedMeasure != null) {
            this.loadMeasureData(aVCalculatedMeasure);
        }
    }

    public void commit(AVCalculatedMeasure aVCalculatedMeasure) throws TraversalException {
        String string = aVCalculatedMeasure.getName();
        try {
            this.prov.validateName("CALCULATED_MEASURE2", string);
        }
        catch (InvalidNameException invalidNameException) {
            this.invalidMeasures.add(aVCalculatedMeasure);
            throw new TraversalException(invalidNameException.getMessage());
        }
        if (this.invalidMeasures.contains(aVCalculatedMeasure)) {
            this.invalidMeasures.remove(aVCalculatedMeasure);
        }
        String string2 = this.prov.getInternalName(string);
        aVCalculatedMeasure.setName(string2);
        String string3 = this.expressionTextField.getText();
        if (string3 != null && !string3.trim().isEmpty()) {
            aVCalculatedMeasure.setMeasureExpression(string3);
        } else {
            aVCalculatedMeasure.setMeasureExpression(null);
        }
        String string4 = this.formatTextField.getText();
        if (string4 != null && !string4.trim().isEmpty()) {
            aVCalculatedMeasure.setMeasureFormat(string4);
        } else {
            aVCalculatedMeasure.setMeasureFormat(null);
        }
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        AVCalculatedMeasure aVCalculatedMeasure = (AVCalculatedMeasure)this.getChildObject();
        String string = aVCalculatedMeasure.getName();
        this.commit(aVCalculatedMeasure);
        AnalyticView analyticView = aVCalculatedMeasure.getAV();
        if (analyticView.findMeasure(aVCalculatedMeasure.getName()) == null) {
            analyticView.addCalculatedMeasure(aVCalculatedMeasure);
        } else if (!aVCalculatedMeasure.getName().equals(string)) {
            // empty if block
        }
    }

    private void layoutComponents() {
        this.setName(this.getClass().getName());
        ComponentFactory componentFactory = this.getComponentFactory();
        componentFactory.setBasePath(new String[]{"calculatedMeasures"});
        this.formatTextField = new JTextField();
        this.formatTextField.setName("formatTextField");
        JLabel jLabel = new JLabel(HCSArb.getString("AV_MEASURE_FORMAT_LABEL"));
        jLabel.setName("formatLabel");
        jLabel.setLabelFor(this.formatTextField);
        this.expressionTextField = new JTextField();
        this.expressionTextField.setName("expressionTextField");
        JLabel jLabel2 = new JLabel(HCSArb.getString("AV_MEASURE_EXPRESSION_LABEL"));
        jLabel2.setName("expressionLabel");
        jLabel2.setLabelFor(this.expressionTextField);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(HCSArb.getString("AV_MEASURE_PROPERTIES")));
        int n = 0;
        this.add(jLabel2, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.expressionTextField, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add(jLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.formatTextField, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(1, n, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 5), 0, 0));
    }

    protected void validateObject() throws TraversalException {
    }
}

