/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.calcs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.hcs.HCSArb;
import oracle.hcs.av.calcs.CalculatedMeasureNameValidator;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.panels.MeasureFormatsRenderer;
import oracle.hcs.db.DatabaseUtils;
import oracle.hcs.util.RestrictedTextField;
import oracle.hcs.util.UIStringUtils;
import oracle.ide.Ide;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;

public class NewCalcMeasurePanel
extends JPanel
implements FocusListener {
    private JTextField caption;
    private JTextField description;
    private JComboBox measureFormats;
    private RestrictedTextField nameField;
    private boolean descAltered;
    private boolean captionAltered;
    private AnalyticView analyticView;
    private CalculatedMeasureNameValidator validator;
    private String originalCalcName;
    private KeyListener descriptionsKeyListener;
    private final String DEFAULT_CALCULATED_MEASURE_NAME_ROOT = "CALCULATED_MEASURE";
    private DBObjectProvider provider;

    public NewCalcMeasurePanel(AnalyticView analyticView, DBObjectProvider dBObjectProvider) {
        super(new GridBagLayout());
        this.analyticView = analyticView;
        this.provider = dBObjectProvider;
        this.validator = new CalculatedMeasureNameValidator(dBObjectProvider);
        this.layoutComponents();
        this.setDefaultName();
    }

    private void layoutComponents() {
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(4, 4, 6, 4);
        gridBagConstraints.anchor = 512;
        gridBagConstraints.fill = 2;
        this.add((Component)new JLabel(HCSArb.getString("CALC_MEASURE_CREATE_AV_NAME")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)new JLabel(this.analyticView.getName()), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)new JLabel(HCSArb.getString("DESCRIPTION_PANEL_NAME_LABEL")), gridBagConstraints);
        this.nameField = new RestrictedTextField(30);
        this.nameField.setMinimumSize(new Dimension(300, (int)this.nameField.getMinimumSize().getHeight()));
        this.nameField.setName("nameField");
        this.nameField.addFocusListener(this);
        this.nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.updateDescs();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.updateDescs();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.updateDescs();
            }

            private void updateDescs() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String string = UIStringUtils.stripDoubleQuotes(NewCalcMeasurePanel.this.originalCalcName);
                        String string2 = NewCalcMeasurePanel.this.caption.getText();
                        if (!NewCalcMeasurePanel.this.captionAltered && !string2.equalsIgnoreCase(string)) {
                            NewCalcMeasurePanel.this.caption.setText(string);
                        }
                    }
                });
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.nameField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)new JLabel(HCSArb.getString("DESCRIPTION_PANEL_SHORT_LABEL")), gridBagConstraints);
        this.caption = new JTextField(30);
        this.caption.setMinimumSize(this.nameField.getMinimumSize());
        this.caption.setName("caption");
        this.createDescriptionsKeyListener();
        this.caption.addKeyListener(this.descriptionsKeyListener);
        this.caption.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.updateDescriptionField();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.updateDescriptionField();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.updateDescriptionField();
            }

            private void updateDescriptionField() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String string = UIStringUtils.stripDoubleQuotes(NewCalcMeasurePanel.this.caption.getText());
                        String string2 = NewCalcMeasurePanel.this.description.getText();
                        if (!NewCalcMeasurePanel.this.descAltered && !string2.equalsIgnoreCase(string)) {
                            NewCalcMeasurePanel.this.description.setText(string);
                        }
                    }
                });
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.caption, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(4, 4, 10, 4);
        this.add((Component)new JLabel(HCSArb.getString("DESCRIPTION_PANEL_DESCRIPTION")), gridBagConstraints);
        this.description = new JTextField(30);
        this.description.setMinimumSize(this.nameField.getMinimumSize());
        this.description.setName("description");
        this.description.addKeyListener(this.descriptionsKeyListener);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.description, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)new JLabel(HCSArb.get("DESCRIPTION_PANEL_MEASURE_FORMAT")), gridBagConstraints);
        this.measureFormats = new JComboBox(){

            @Override
            public Object getSelectedItem() {
                Object object = super.getSelectedItem();
                if (object instanceof Object[]) {
                    Object[] objectArray = (Object[])object;
                    return objectArray[0];
                }
                return object;
            }
        };
        this.measureFormats.setModel(new DefaultComboBoxModel((E[])DatabaseUtils.getMeasureNumericFormats()));
        this.measureFormats.setSelectedIndex(0);
        this.measureFormats.setRenderer(new MeasureFormatsRenderer());
        this.measureFormats.setEditable(true);
        this.measureFormats.setMinimumSize(this.nameField.getMinimumSize());
        this.measureFormats.setName("measureFormat");
        this.measureFormats.addFocusListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.measureFormats, gridBagConstraints);
    }

    private void createDescriptionsKeyListener() {
        this.descriptionsKeyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getSource() == NewCalcMeasurePanel.this.caption) {
                    NewCalcMeasurePanel.this.captionAltered = true;
                }
                if (keyEvent.getSource() == NewCalcMeasurePanel.this.description) {
                    NewCalcMeasurePanel.this.descAltered = true;
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
    }

    public String getMeasureName() {
        return this.nameField.getText();
    }

    public String getDescription() {
        return this.description.getText();
    }

    public String getCaption() {
        return this.caption.getText();
    }

    public String getMeasureFormat() {
        String string = (String)this.measureFormats.getSelectedItem();
        if (!(string = string.trim()).equalsIgnoreCase(HCSArb.get("NONE"))) {
            return string;
        }
        return "";
    }

    private void updateChange(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.nameField) {
            this.originalCalcName = this.nameField.getText();
            String string = this.nameField.getText();
            if (!UIStringUtils.isQuotedName(string)) {
                string = string.toUpperCase();
            } else {
                String string2;
                String string3 = this.provider.getInternalName(string);
                string = string2 = this.provider.getExternalName(string3);
                this.originalCalcName = string2;
            }
            this.nameField.setText(string);
        }
    }

    public boolean validateMeasureName() {
        boolean bl = true;
        try {
            this.validator.validateName("CALCULATED_MEASURE2", this.nameField.getText());
            AVBaseMeasure aVBaseMeasure = this.analyticView.findBaseMeasure(this.nameField.getText());
            if (aVBaseMeasure != null) {
                String string = "BASE_MEASURE_ALREADY_EXISTS_ERROR";
                if (aVBaseMeasure.isDerived()) {
                    string = "CALC_MEASURE_ALREADY_EXISTS_ERROR";
                }
                bl = false;
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), HCSArb.format(string, this.nameField.getText()), HCSArb.getString("CREATE_DERIVED_MEASURE_DIALOG.TITLE"), 0);
            }
        }
        catch (InvalidNameException invalidNameException) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), invalidNameException.getMessage(), HCSArb.getString("CREATE_DERIVED_MEASURE_DIALOG.TITLE"), 0);
            this.nameField.requestFocusInWindow();
            bl = false;
        }
        return bl;
    }

    private void setDefaultName() {
        String string;
        int n = 1;
        while (this.analyticView.findCalculatedMeasure(String.format("%s%d", "CALCULATED_MEASURE", n)) != null) {
            ++n;
        }
        this.originalCalcName = string = String.format("%s%d", "CALCULATED_MEASURE", n);
        this.nameField.setText(string);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.updateChange(focusEvent);
    }
}

