/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.AbstractDropHCSObjectAction;
import oracle.hcs.actions.ActionConfirmPanel;
import oracle.hcs.actions.AlterHCSObjectHelper;
import oracle.hcs.actions.DropConfirmPanel;
import oracle.hcs.actions.DropHelper;
import oracle.hcs.db.MetadataChange;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.javatools.db.Database;

public class DropHCSObjectAction
extends AbstractDropHCSObjectAction {
    private static final Logger LOG = Logger.getLogger(DropHCSObjectAction.class.getName());
    private static final String HELP_ID = "av_drop_object";
    private DropConfirmPanel dropConfirmPanel;

    @Override
    protected AlterHCSObjectHelper getHelper() throws Exception {
        DBObject dBObject = this.getDBObject();
        DropHelper dropHelper = new DropHelper(dBObject);
        return dropHelper;
    }

    @Override
    protected String getParentObjectName() {
        return this.getObjectName();
    }

    @Override
    protected String getParentObjectType() {
        return this.getType();
    }

    @Override
    protected String getObjectName() {
        String string = this.getDBObject().getObjectName();
        return string;
    }

    @Override
    public String getType() {
        String string = this.getDBObject().getObjectType();
        return string;
    }

    @Override
    protected String getTitle(String string) {
        String string2 = HCSArb.getString("DROP_ACTION_RAPTOR_TASK_TITLE");
        return string2;
    }

    @Override
    protected String getProgressMessage() {
        String string = HCSArb.getString("DROP_ACTION_RAPTOR_TASK_RUNNING_MSG");
        return string;
    }

    @Override
    protected ActionConfirmPanel getConfirmationPanel() {
        String string = this.getDBObject().getSchemaName();
        Database database = this.getDBObject().getDatabase();
        String string2 = this.getObjectName();
        String string3 = this.getType();
        if (this.dropConfirmPanel == null) {
            this.dropConfirmPanel = new DropConfirmPanel(string, string3, string2);
        }
        return this.dropConfirmPanel;
    }

    @Override
    protected String getHelpID() {
        return HELP_ID;
    }

    @Override
    protected void actionPostProcess() {
        DBObject dBObject = this.getDBObject();
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        arrayList.add(dBObject);
        String string = dBObject.getSchemaName();
        String string2 = dBObject.getObjectName();
        Database database = dBObject.getDatabase();
        String string3 = database.getExternalName(string2);
        String string4 = this.getType();
        String string5 = null;
        if (string4.equals("ATTRIBUTE DIMENSION")) {
            string5 = HCSArb.format("DROP_ATTRIBUTE_DIMENSION_SUCCESS_MSG", string, string3);
        } else if (string4.equals("HIERARCHY")) {
            string5 = HCSArb.format("DROP_HIERARCHY_SUCCESS_MSG", string, string3);
        } else if (string4.equals("ANALYTIC VIEW")) {
            string5 = HCSArb.format("DROP_AV_SUCCESS_MSG", string, string3);
        }
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string5, HCSArb.format("DROP_DIALOG_TITLE", string + "." + string3), 1);
        this.refreshObjectsInNavigator(string4, dBObject);
        this.recordMetadataChanges();
    }

    @Override
    protected List<Editor> findEditorsToClose(String string, List<Editor> list) {
        ArrayList<Editor> arrayList = new ArrayList<Editor>();
        for (Editor editor : list) {
            String string2 = editor.getTabLabel();
            if (!string2.equalsIgnoreCase(string)) continue;
            arrayList.add(editor);
        }
        return arrayList;
    }

    @Override
    protected LinkedList<MetadataChange> getChanges(String string, HCSSyntaxType hCSSyntaxType) {
        LinkedList<MetadataChange> linkedList = new LinkedList<MetadataChange>();
        linkedList.add(new MetadataChange(null, string, hCSSyntaxType, "DELETION"));
        return linkedList;
    }
}

