/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.markers.adapters;

import java.net.URL;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.ExtensionRegistry;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.markers.Marker;
import oracle.ide.markers.MarkerTypeDescriptor;
import oracle.ide.nulls.NullIcon;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

public class HashStructureToMarkerTypeDescriptorAdapterFactory
implements AdapterFactory<HashStructure, MarkerTypeDescriptor> {
    private static void logExtensionMessage(Level level, String message, HashStructure hash) {
        StringBuilder sb = new StringBuilder();
        sb.append(" HashStructure=[");
        for (String key : hash.keySet()) {
            sb.append(key).append("=").append(hash.getObject(key)).append(", ");
        }
        sb.replace(sb.length() - 2, sb.length(), "]");
        String extensionId = HashStructureHook.getExtensionId((HashStructure)hash);
        Extension ext = extensionId == null ? null : ExtensionRegistry.getExtensionRegistry().findExtension(extensionId);
        ExtensionLogRecord record = new ExtensionLogRecord(level, message + sb.toString(), ext, -1);
        Logger logger = ExtensionRegistry.getExtensionRegistry().getLogger();
        logger.log((LogRecord)record);
    }

    public MarkerTypeDescriptor adapt(HashStructure hash) {
        if (null == hash) {
            return null;
        }
        try {
            return new DeclaredMarkerTypeDescriptor(hash);
        }
        catch (Exception e) {
            HashStructureToMarkerTypeDescriptorAdapterFactory.logExtensionMessage(Level.SEVERE, e.getMessage(), hash);
            return null;
        }
    }

    private static class DeclaredMarkerTypeDescriptor
    extends HashStructureAdapter
    implements MarkerTypeDescriptor {
        private static final String NAME_ATTR = "name";
        private static final String DESCRIPTION_ATTR = "description";
        private static final String PERSISTENT_ATTR = "persistent";
        private static final String ICON_ATTR = "icon";
        private static final String CLASS_ATTR = "class";
        private static final String MISSING_KEY_FMT = "HashStructure missing required key: {0}";
        private final LazyClassAdapter lazyLoader;
        private Icon icon;

        private DeclaredMarkerTypeDescriptor(HashStructure hash) {
            super(hash);
            if (!hash.containsKey(NAME_ATTR)) {
                throw new IllegalArgumentException(MessageFormat.format(MISSING_KEY_FMT, NAME_ATTR));
            }
            if (!hash.containsKey(CLASS_ATTR)) {
                throw new IllegalArgumentException(MessageFormat.format(MISSING_KEY_FMT, CLASS_ATTR));
            }
            this.lazyLoader = LazyClassAdapter.getInstance((HashStructure)hash);
        }

        @Override
        public String name() {
            return this._hash.getString(NAME_ATTR);
        }

        @Override
        public String description() {
            return this._hash.getString(DESCRIPTION_ATTR);
        }

        @Override
        public boolean isPersistent() {
            return this._hash.getBoolean(PERSISTENT_ATTR);
        }

        @Override
        public synchronized Icon icon() {
            if (null == this.icon) {
                URL iconUrl = this._hash.getURL(ICON_ATTR);
                this.icon = null != iconUrl ? new ImageIcon(iconUrl) : new NullIcon();
            }
            return this.icon;
        }

        @Override
        public MetaClass<? extends Marker> markerClass() {
            return this.lazyLoader.getMetaClass(CLASS_ATTR);
        }
    }
}

