/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.markers;

import oracle.ide.markers.Marker;
import oracle.ide.markers.annotations.MarkerAttribute;

public interface ActionMarker
extends Marker {
    @MarkerAttribute(id="state", name="State", description="Indicates the state of the action", required=true, readOnly=true)
    public int state();

    @MarkerAttribute(id="state")
    public void state(int var1);

    @MarkerAttribute(id="severities", name="Possible Severities", description="Specifies which severity values may result from the action signaled by this marker.  The severity values are combined into a bitmap.", readOnly=true)
    public int severities();

    @MarkerAttribute(id="severities")
    public void severities(int var1);

    @MarkerAttribute(id="errorCount", name="Error Count", description="The number of errors encountered during the action", defaultValue="0", readOnly=true)
    public int errorCount();

    @MarkerAttribute(id="errorCount")
    public void errorCount(int var1);

    @MarkerAttribute(id="warningCount", name="Warning Count", description="The number of warnings encountered during the action", defaultValue="0", readOnly=true)
    public int warningCount();

    @MarkerAttribute(id="warningCount")
    public void warningCount(int var1);

    @MarkerAttribute(id="infoCount", name="Info Count", description="The number of infos encountered during the action", defaultValue="0", readOnly=true)
    public int infoCount();

    @MarkerAttribute(id="infoCount")
    public void infoCount(int var1);

    @MarkerAttribute(id="incompleteCount", name="Incomplete Count", description="The number of incompletes encountered during the action", defaultValue="0", readOnly=true)
    public int incompleteCount();

    @MarkerAttribute(id="incompleteCount")
    public void incompleteCount(int var1);

    public static enum State {
        BEGINNING(0),
        COMPLETED(1),
        CANCELED(-1);

        public final int value;

        public static State valueOf(int state) {
            for (State s : State.values()) {
                if (s.value != state) continue;
                return s;
            }
            throw new IllegalArgumentException("No state constant for value " + state);
        }

        private State(int value) {
            this.value = value;
        }
    }
}

