/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util.classfile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ClassFile {
    private File file;
    private ZipFile zipFile;
    private ZipEntry zipEntry;

    public ClassFile(File file) {
        this.file = file;
    }

    public ClassFile(ZipFile zf, ZipEntry ze) {
        this.zipFile = zf;
        this.zipEntry = ze;
    }

    public boolean isZipped() {
        return this.zipFile != null;
    }

    public InputStream getInputStream() throws IOException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        try {
            return this.zipFile.getInputStream(this.zipEntry);
        }
        catch (ZipException e) {
            throw new IOException(e.getMessage());
        }
    }

    public boolean exists() {
        return this.file != null ? this.file.exists() : true;
    }

    public boolean isDirectory() {
        return this.file != null ? this.file.isDirectory() : this.zipEntry.getName().endsWith("/");
    }

    public long lastModified() {
        return this.file != null ? this.file.lastModified() : this.zipEntry.getTime();
    }

    public String getPath() {
        if (this.file != null) {
            return this.file.getPath();
        }
        return this.zipFile.getName() + "(" + this.zipEntry.getName() + ")";
    }

    public String getName() {
        return this.file != null ? this.file.getName() : this.zipEntry.getName();
    }

    public String getAbsoluteName() {
        String absoluteName;
        if (this.file != null) {
            try {
                absoluteName = this.file.getCanonicalPath();
            }
            catch (IOException e) {
                absoluteName = this.file.getAbsolutePath();
            }
        } else {
            absoluteName = this.zipFile.getName() + "(" + this.zipEntry.getName() + ")";
        }
        return absoluteName;
    }

    public long length() {
        return this.file != null ? this.file.length() : this.zipEntry.getSize();
    }

    public String toString() {
        return this.file != null ? this.file.toString() : this.zipEntry.toString();
    }
}

