/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Locale;

public class MonospacedFormater {
    NumberFormat intFormat;
    NumberFormat doubleFormat;
    int intWidth;
    int deciWidth;
    FieldPosition fpos;

    public MonospacedFormater(int intWidth, int deciWidth) {
        this.intFormat = NumberFormat.getNumberInstance();
        this.doubleFormat = NumberFormat.getNumberInstance();
        this.intWidth = intWidth;
        this.deciWidth = deciWidth;
        this.init();
    }

    public MonospacedFormater(int intWidth, int deciWidth, Locale locale) {
        this.intFormat = NumberFormat.getNumberInstance(locale);
        this.doubleFormat = NumberFormat.getNumberInstance(locale);
        this.intWidth = intWidth;
        this.deciWidth = deciWidth;
        this.init();
    }

    protected void init() {
        this.intFormat.setMaximumIntegerDigits(this.intWidth);
        this.doubleFormat.setMaximumIntegerDigits(this.intWidth);
        this.doubleFormat.setMaximumFractionDigits(this.deciWidth);
        this.doubleFormat.setMinimumFractionDigits(this.deciWidth);
        this.fpos = new FieldPosition(0);
    }

    public String format(long lval) {
        StringBuffer sbuf = new StringBuffer();
        this.intFormat.format(lval, sbuf, this.fpos);
        for (int i = 0; i < this.intWidth - this.fpos.getEndIndex(); ++i) {
            sbuf.insert(i, ' ');
        }
        return sbuf.toString();
    }

    public String format(double dval) {
        StringBuffer sbuf = new StringBuffer();
        this.doubleFormat.format(dval, sbuf, this.fpos);
        for (int i = 0; i < this.intWidth - this.fpos.getEndIndex(); ++i) {
            sbuf.insert(i, ' ');
        }
        return sbuf.toString();
    }

    public static void main(String[] args) {
        MonospacedFormater f = new MonospacedFormater(Integer.parseInt(args[0]), Integer.parseInt(args[1]));
        System.out.println("  formatted  int: " + f.format(Integer.parseInt(args[2])));
        System.out.println("formatted double: " + f.format(Double.parseDouble(args[3])));
    }
}

