/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.shell;

import java.util.StringTokenizer;
import java.util.Vector;
import oracle.aurora.server.tools.shell.MessageTool;
import oracle.aurora.server.tools.shell.Tool;
import oracle.aurora.util.tools.ToolException;

public abstract class ToolImpl
extends MessageTool
implements Tool {
    public abstract void invoke() throws ToolException;

    public void invoke(String[] argv) throws ToolException {
        this.parseArgs(this.parseStdArgs(argv));
        this.invoke();
    }

    protected boolean last(Object[] array, int index) {
        return array.length == index;
    }

    protected abstract void parseArgs(String[] var1) throws ToolException;

    protected String[] parseCommaDelimited(String string) {
        StringTokenizer tokes = new StringTokenizer(string, ",");
        int numTokes = tokes.countTokens();
        String[] parsed = new String[tokes.countTokens()];
        for (int i = 0; i < numTokes; ++i) {
            parsed[i] = tokes.nextToken();
        }
        return parsed;
    }

    protected String[] parseStdArgs(String[] argv) throws ToolException {
        Vector<String> argsLeft = new Vector<String>();
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-help") || argv[i].equals("-h")) {
                this.error(this.help());
                continue;
            }
            if (argv[i].equals("-describe") || argv[i].equals("-d")) {
                this.error(this.description());
                continue;
            }
            if (argv[i].equals("-version") || argv[i].equals("-v")) {
                this.error(this.version());
                continue;
            }
            argsLeft.addElement(argv[i]);
        }
        Object[] result = new String[argsLeft.size()];
        argsLeft.copyInto(result);
        return result;
    }

    protected String[] parseStdArgs(String[] argv, boolean client) throws ToolException {
        Vector<String> argsLeft = new Vector<String>();
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-help") || argv[i].equals("-h")) {
                this.error(this.help());
                continue;
            }
            if ((argv[i].equals("-describe") || argv[i].equals("-d")) && !client) {
                this.error(this.description());
                continue;
            }
            if (argv[i].equals("-version") || argv[i].equals("-v")) {
                this.error(this.version());
                continue;
            }
            argsLeft.addElement(argv[i]);
        }
        Object[] result = new String[argsLeft.size()];
        argsLeft.copyInto(result);
        return result;
    }
}

