/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Vector;
import oracle.aurora.server.tools.loadjava.JdbcOperations;
import oracle.aurora.server.tools.loadjava.LoadJavaLog;
import oracle.aurora.server.tools.loadjava.MkMsg;
import oracle.aurora.server.tools.loadjava.Options;
import oracle.aurora.util.msg.Msg;

public class LoadJavaOptions
extends Options {
    private static Msg mkMsg = MkMsg.mkMsg;
    private String[] grantNamesAsStrings;
    private static final String[] oneList = new String[]{"-help", "-resolve", "-definer", "-debug", "-andresolve", "-force", "-synonym", "-order", "-nousage", "-noverify", "-nowarn", "-recursivejars", "-dresolver", "-oracleresolver", "-noserverside", "-unresolvedok", "-jarasresource", "-resolveonly", "-compat817", "-genmissing", "-noaction", "-stoponerror", "-cleargrants", "-casesensitivepub", "-install", "-jarsasdbobjects", "-prependjarnames", "-nativecompile", null};
    private static final String[] twoList = new String[]{"-btl", "-localpathprefix", "-resolver", "-grant", "-encoding", "-edition", "-schema", "-tableschema", "-genmissingjar", "-optionfile", "-optiontable", "-publish", "-pubmain", "-dirprefix", "-proxy", null};
    private static final String[] substList = new String[]{"-h", "-help", "-r", "-resolve", "-a", "-andresolve", "-f", "-force", "-s", "-synonym", "-g", "-grant", "-e", "-encoding", "-R", "-resolver", "-d", "-definer", null};
    private static final Object[] expandList = new Object[]{"-nodefiner", "-definer", Boolean.FALSE, "-noschema", "-schema", null, "-nogrant", "-grant", null, "-nocleargrants", "-cleargrants", Boolean.FALSE, "-nosynonym", "-synonym", Boolean.FALSE, "-action", "-noaction", Boolean.FALSE, "-nocasesensitivepub", "-casesensitivepub", Boolean.FALSE, null};

    public LoadJavaOptions(Options defaultOpt) {
        super(oneList, twoList, substList, expandList, defaultOpt);
    }

    public LoadJavaOptions() {
        this(null);
    }

    String getTableSchema() {
        return this.getString("-tableschema");
    }

    String tableSchemaAsPrefix(String name) {
        return JdbcOperations.schemaAsPrefix(this.getString("-tableschema")) + JdbcOperations.doubleQuote(name);
    }

    String loadSchemaAsPrefix(String name) {
        return this.schemaAsPrefix(this.getLoadSchema()) + JdbcOperations.doubleQuote(name);
    }

    String schemaAsPrefix(String schema) {
        return JdbcOperations.schemaAsPrefix(schema);
    }

    String md5Table(String schema) {
        return JdbcOperations.md5Table(schema);
    }

    String lobTable(String schema) {
        return JdbcOperations.lobTable(schema);
    }

    String andresolveClause() {
        String clause = " ";
        if (this.getBoolean("-andresolve")) {
            clause = " and resolve ";
        }
        return clause;
    }

    String schemaClause() {
        String s = this.getLoadSchema();
        String result = "";
        if (s != null) {
            result = " schema " + s;
        }
        return result;
    }

    String definerClause() {
        String clause = " ";
        if (this.getBoolean("-definer")) {
            clause = " authid definer ";
        }
        return clause;
    }

    String resolverClause() {
        String clause = " ";
        String option = this.getString("-resolver");
        if (option != null) {
            clause = " resolver " + option;
        }
        return clause;
    }

    String getEncoding() {
        String encoding = this.getString("-encoding");
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        return encoding;
    }

    boolean getDefiners() {
        return this.getBoolean("-definer");
    }

    String getResolver() {
        return this.getString("-resolver");
    }

    boolean getGenMissing() {
        return this.getBoolean("-genmissing") || this.getString("-genmissingjar") != null;
    }

    String sqlLex(String lexeme) {
        if (lexeme != null && lexeme.startsWith("\"")) {
            if ((lexeme = lexeme.substring(1)).endsWith("\"")) {
                lexeme = lexeme.substring(0, lexeme.length() - 1);
            }
        } else if (lexeme != null) {
            lexeme = lexeme.toUpperCase();
        }
        return lexeme;
    }

    String getLoadSchema() {
        return this.sqlLex(this.getString("-schema"));
    }

    String getGrantees() {
        return this.getString("-grant");
    }

    boolean getForce() {
        return this.getBoolean("-force");
    }

    boolean getResolveOnly() {
        return this.getBoolean("-resolveonly");
    }

    boolean getAndResolve() {
        return this.getBoolean("-andresolve");
    }

    boolean getCreateSynonym() {
        return this.getBoolean("-synonym");
    }

    String[] getGrantNamesAsStrings(LoadJavaLog log) {
        if (this.grantNamesAsStrings == null) {
            this.grantNamesAsStrings = this.granteesToArray(this.getGrantees(), log);
        }
        return this.grantNamesAsStrings;
    }

    String[] granteesToArray(String grantees, LoadJavaLog log) {
        Object[] result = null;
        if (grantees != null) {
            try {
                StringReader r = new StringReader(grantees);
                Vector<String> vNames = new Vector<String>();
                StreamTokenizer tokenizer = new StreamTokenizer(r);
                tokenizer.resetSyntax();
                tokenizer.wordChars(0, Integer.MAX_VALUE);
                tokenizer.whitespaceChars(32, 32);
                tokenizer.whitespaceChars(9, 9);
                tokenizer.whitespaceChars(44, 44);
                tokenizer.quoteChar(34);
                tokenizer.eolIsSignificant(false);
                int type = tokenizer.nextToken();
                while (type != -1) {
                    String u = tokenizer.sval;
                    if (type == -3) {
                        u = u.toUpperCase();
                    }
                    if (u != null) {
                        vNames.add(u);
                    }
                    type = tokenizer.nextToken();
                }
                result = new String[vNames.size()];
                vNames.copyInto(result);
            }
            catch (IOException ex) {
                log.err(ex, mkMsg.m("parsing grant argument: {0}", this.getGrantees()));
                result = new String[]{};
            }
        } else {
            result = new String[]{};
        }
        return result;
    }

    static String usageMessage() {
        return "Usage: loadjava [-definer] [-encoding encoding] [-force] [-genmissing] [-genmissingjar jar] [-grant grants] [-help] [-nousage] [-noverify] [-oci8] [-order] [-resolve] [-nativecompile] [-resolver resolver] [-schema schema] [-synonym] [-thin] [-tableschema schema] [-user user/password@database] [-verbose] [-edition edition] classes..jars..resources..properties...  ";
    }

    static String helpMessage() {
        return mkMsg.k("loadjava.help", "load classes, jars, resources or properties files into Oracle.\nUsage: loadjava [options] classes..jars..resources..properties...\nOptions:\n  -d, -definer             gives the methods of the class definer's rights\n  -encoding <encoding>     the encoding to be used to read .java files \n  -f, -force               force loading of all classes.  Normally classes\n                           identical to classes already loaded are not\n                           reloaded.\n  -g, -grant <grants>      grant execute permission on all loaded classes\n                           and resources to the users and roles\n                           listed in the comma separated list <grants>.\n  -genmissing              if the classes and jars refer to classes that\n                           are not present, generate dummy versions of \n                           the missing classes.\n  -genmissingjar <jar>     In addition to the actions of -genmissing \n                           create a jar containing the generated classes.\n  -h, -help                print out this message.\n  -nousage                 do print a usage message if there are no file\n                           arguments\n  -noverify                do not verify bytecodes. \n  -o, -oci8                use JDBC OCI8.  The database must be an entry\n                           from TNSNAMES.ORA file or a Net8 Name-Value list.\n  -order                   resolve classes in \"bottom up\" order \n  -r, -resolve             resolve all the classes after loading them.  \n  -nativecompile           natively compile methods in classes after loading \n                           and resolving them.  This option forces loaded \n                           classes to be resolved. \n  -resolver <resolver>     use <resolver> as the resolver for the loaded\n                           classes.  As resolvers contain special characters\n                           they should be quoted on the command line.\n  -schema <schema>         loads into <schema> rather than schema of user\n                           schema being loaded into.\n  -s, -synonym             create public synonyms for the loaded classes.\n                           You must have CREATE PUBLIC SYNONYM privilege.\n  -tableschema <schema>    Use <schema> to hold all tables used by loadjava\n                           instead of putting the tables in the schema \n                           where classes are being loaded.\n  -t, -thin                use JDBC THIN.  The database must be of the form\n                           <host>:<port>:<sid> or a Net8 Name-Value list.\n  -user user/password@database   account and database where to load the\n                            classes and resources.\n  -v, -verbose             print some information as it loads the files.\n                           recommended to find missing classes early.\n  -proxy host:port         Host is the proxy host name or internet address.\n                           Port is the proxy port number.\n  -edition <edition name>  The application edition into which to load objects\n");
    }
}

