/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.util.StringTokenizer;
import java.util.Vector;
import oracle.aurora.server.tools.loadjava.DropJava;
import oracle.aurora.server.tools.loadjava.ToolsError;
import oracle.aurora.server.tools.loadjava.ToolsException;
import oracle.aurora.server.tools.loadjava.ToolsMessage;

public class DropJavaMain {
    private boolean successFlag = true;
    private Exception exitException = null;

    public static void main(String[] args) {
        String passwd;
        int len = args.length;
        String user = System.getenv("DJUSER");
        if (user != null) {
            len += 2;
        }
        if ((passwd = System.getenv("DJPASS")) != null) {
            len += 2;
        }
        String[] allargs = new String[len];
        int pos = 0;
        if (user != null) {
            System.arraycopy(user.split(" "), 0, allargs, pos, 2);
            pos += 2;
        }
        if (passwd != null) {
            String[] r = passwd.split(" ");
            if (r[1].equals("\"\"")) {
                r[1] = "";
            }
            System.arraycopy(r, 0, allargs, pos, 2);
            pos += 2;
        }
        System.arraycopy(args, 0, allargs, pos, args.length);
        DropJavaMain djm = new DropJavaMain();
        djm.run(allargs);
        if (!djm.successFlag) {
            System.exit(1);
        }
    }

    public static void serverMain(String argString) {
        DropJavaMain djm = new DropJavaMain();
        if (argString == null) {
            throw new IllegalArgumentException("Null argument string");
        }
        Vector<String> argv = new Vector<String>();
        argv.addElement("-kprb");
        StringTokenizer tokens = new StringTokenizer(argString);
        while (tokens.hasMoreTokens()) {
            argv.addElement(tokens.nextToken());
        }
        Object[] args = new String[argv.size()];
        argv.copyInto(args);
        djm.run((String[])args);
        if (!djm.successFlag) {
            String msg;
            boolean messageOnly = false;
            if (djm.exitException == null) {
                msg = "Error during dropjava";
            } else {
                String emsg = djm.exitException.getMessage();
                if (emsg.equals("help")) {
                    msg = " dropjava help message";
                    messageOnly = true;
                } else if (emsg.equals("usage")) {
                    msg = "dropjava usage message";
                    messageOnly = true;
                } else {
                    msg = emsg.equals("usage error") ? " dropjava usage error" : "\nError during dropjava: " + emsg;
                }
            }
            msg = msg + ".\nCheck trace file for details";
            throw messageOnly ? new ToolsMessage(msg) : new ToolsError(msg);
        }
    }

    void run(String[] argv) {
        DropJava dj = new DropJava();
        try {
            dj.command(argv);
        }
        catch (ToolsException ex) {
            System.err.println("exiting  : " + ex.getMessage());
            if (dj.getGenericOpts().getBoolean("-debug") && ex.getChain() != null) {
                ex.getChain().printStackTrace(System.err);
            }
            this.exitException = ex;
            this.successFlag = false;
        }
        catch (ToolsError ex) {
            System.err.println("exiting  : " + ex.getMessage());
            this.successFlag = false;
            this.exitException = ex;
        }
    }
}

