/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.server.tools.loadjava;

import java.io.File;
import oracle.aurora.server.tools.loadjava.LoadJavaConstants;
import oracle.aurora.server.tools.loadjava.Options;

class ClassifyFiles
implements LoadJavaConstants {
    private Options opts;

    ClassifyFiles(Options opts) {
        this.opts = opts;
    }

    Options getOpts() {
        return this.opts;
    }

    boolean isClassFile(String name) {
        return name.endsWith(".class");
    }

    boolean isSourceFile(String name) {
        return name.endsWith(".java") || name.endsWith(".sqlj");
    }

    boolean isDeployFile(String name) {
        return !this.isClassFile(name) && !this.isSourceFile(name) && this.isDeployName(name);
    }

    boolean isDeployName(String name) {
        return name != null && name.startsWith("oracle/aurora/deploy/");
    }

    boolean isJarFile(String name) {
        return !this.getOpts().getBoolean("-jarasresource") && (name.endsWith(".zip") || name.endsWith(".jar"));
    }

    boolean isSqljProfile(String name) {
        return name.endsWith(".ser");
    }

    boolean isURL(String name) {
        return name.indexOf(58) >= 3;
    }

    String transformName(String name) {
        if (this.isClassFile(name)) {
            name = name.substring(0, name.lastIndexOf(".class"));
        } else if (this.isSourceFile(name)) {
            if (name.lastIndexOf(".java") > 0) {
                name = name.substring(0, name.lastIndexOf(".java"));
            } else if (name.lastIndexOf(".sqlj") > 0) {
                name = name.substring(0, name.lastIndexOf(".sqlj"));
            }
        } else if (this.isDeployFile(name)) {
            name = name.substring("oracle/aurora/deploy/".length());
        }
        String prefix = this.getOpts().getString("-dirprefix");
        if (prefix != null && name.startsWith(prefix) && ((name = name.substring(prefix.length())).startsWith(File.separator) || name.startsWith("/"))) {
            name = name.substring(1);
        }
        if (name.charAt(0) == '/') {
            name = "ROOT" + name;
        }
        return name.replace('\\', '/');
    }

    int typeFromName(String name) {
        int type = this.isJarFile(name) ? 1002 : (this.isClassFile(name) ? 29 : (this.isSourceFile(name) ? 28 : (this.isDeployFile(name) ? 1001 : (this.isSqljProfile(name) ? 1003 : 30))));
        return type;
    }

    File mkFile(String name) {
        File file = new File(name);
        String prefix = this.getOpts().getString("-localpathprefix");
        if (prefix != null && !file.isAbsolute()) {
            file = new File(prefix + name);
        }
        return file;
    }
}

