/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms.security;

import java.lang.reflect.Constructor;
import java.security.Permission;

class RowData {
    static final int GRANT = 0;
    static final int RESTRICT = 1;
    static final int ACTIVE = 2;
    static final int INACTIVE = 3;
    int kind;
    long schema;
    long type_schema;
    String type_name;
    String name;
    String action;
    int status;
    long key;

    RowData(int kind, long schema, long type_schema, String type_name, String name, String action, int status, long key) {
        this.kind = kind;
        this.schema = schema;
        this.type_schema = type_schema;
        this.type_name = type_name;
        this.name = name;
        this.action = action;
        this.status = status;
        this.key = key;
    }

    protected RowData() {
    }

    RowData(RowData rhs) {
        if (rhs != null) {
            this.kind = rhs.kind;
            this.schema = rhs.schema;
            this.type_schema = rhs.type_schema;
            this.type_name = rhs.type_name;
            this.name = rhs.name;
            this.action = rhs.action;
            this.status = rhs.status;
            this.key = rhs.key;
        }
    }

    private String enumConstant(int x) {
        String result;
        switch (x) {
            case 0: {
                result = "GRANT";
                break;
            }
            case 1: {
                result = "RESTRICT";
                break;
            }
            case 2: {
                result = "ACTIVE";
                break;
            }
            case 3: {
                result = "INACTIVE";
                break;
            }
            default: {
                result = Integer.toString(x);
            }
        }
        return result;
    }

    public String toString() {
        return "<" + this.enumConstant(this.kind) + ", " + this.schema + ", " + this.type_schema + ", " + this.type_name + ", " + this.name + ", " + this.action + ", " + this.enumConstant(this.status) + ", " + this.key + ">";
    }

    int getInt(int column) {
        int result = 0;
        switch (column) {
            case 1: {
                result = this.kind;
                break;
            }
            case 7: {
                result = this.status;
            }
        }
        return result;
    }

    long getLong(int column) {
        long result = 0L;
        switch (column) {
            case 1: {
                result = this.kind;
                break;
            }
            case 2: {
                result = this.schema;
                break;
            }
            case 3: {
                result = this.type_schema;
                break;
            }
            case 7: {
                result = this.status;
                break;
            }
            case 8: {
                result = this.key;
            }
        }
        return result;
    }

    String getString(int column) {
        String result = null;
        switch (column) {
            case 4: {
                result = this.type_name;
                break;
            }
            case 5: {
                result = this.name;
                break;
            }
            case 6: {
                result = this.action;
            }
        }
        return result;
    }

    protected Permission instantiate(Class permissionClass) throws InstantiationException {
        Constructor ctor;
        Object[] args;
        Object permission = null;
        Class<?> stringClass = "".getClass();
        if (this.action == null) {
            try {
                Class[] oneArgParams = new Class[]{stringClass};
                args = new Object[]{this.name};
                ctor = permissionClass.getConstructor(oneArgParams);
                permission = ctor.newInstance(args);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (permission == null) {
            try {
                Class[] twoArgParams = new Class[]{stringClass, stringClass};
                args = new Object[]{this.name, this.action};
                ctor = permissionClass.getConstructor(twoArgParams);
                permission = ctor.newInstance(args);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (permission == null) {
            throw new InstantiationException("could not create specified Permission: " + permissionClass + ", name " + this.name + ", action " + this.action);
        }
        return permission;
    }
}

