/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.syntax.ColumnExpression;
import oracle.olapi.syntax.Expression;
import oracle.olapi.syntax.FunctionArgument;
import oracle.olapi.syntax.FunctionDescriptor;
import oracle.olapi.syntax.FunctionDescriptorCatalog;
import oracle.olapi.syntax.Query;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.ValidationContext;

public final class OLAPFunctionQuery
extends Query {
    private String m_FunctionName;
    private FunctionDescriptor m_FunctionDescriptor;
    private FunctionArgument[] m_Arguments;
    private String m_Name;

    private FunctionArgument[] getArgumentsInternal() {
        return this.m_Arguments;
    }

    private OLAPFunctionQuery(String string, String string2, FunctionArgument[] functionArgumentArray, boolean bl) {
        OLAPFunctionQuery.validateValue(string2);
        this.m_FunctionName = string2;
        this.m_Arguments = bl ? OLAPFunctionQuery.getFunctionArgumentArrayClone(functionArgumentArray) : functionArgumentArray;
        this.initialize();
    }

    ColumnExpression[] createColumnExpressions() {
        return null;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append(this.getFunctionName());
        Expression.printExpressions(this.getArgumentsInternal(), syntaxPrintingContext);
        syntaxPrintingContext.append(" AS ");
        syntaxPrintingContext.append(this.getName());
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        FunctionArgument[] functionArgumentArray = new FunctionArgument[this.getArgumentsInternal().length];
        this.m_FunctionDescriptor = FunctionDescriptorCatalog.getValidFunctionDescriptor(this.getFunctionName(), this.getArgumentsInternal(), functionArgumentArray, null, null, 256, "UnknownQueryFunction", validationContext);
        this.m_Arguments = functionArgumentArray;
        validationContext.pop();
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return this.areComponentsComplete(this.getArgumentsInternal());
    }

    public OLAPFunctionQuery(String string, String string2, FunctionArgument[] functionArgumentArray) {
        this(string, string2, functionArgumentArray, true);
    }

    public OLAPFunctionQuery(String string, String string2, List<FunctionArgument> list) {
        this(string, string2, OLAPFunctionQuery.getFunctionArgumentArrayClone(list), false);
    }

    public OLAPFunctionQuery(String string, String string2, FunctionArgument functionArgument) {
        this(string, string2, new FunctionArgument[]{functionArgument}, false);
    }

    public OLAPFunctionQuery(String string, String string2, FunctionArgument functionArgument, FunctionArgument functionArgument2) {
        this(string, string2, new FunctionArgument[]{functionArgument, functionArgument2}, false);
    }

    public OLAPFunctionQuery(String string, String string2, FunctionArgument functionArgument, FunctionArgument functionArgument2, FunctionArgument functionArgument3) {
        this(string, string2, new FunctionArgument[]{functionArgument, functionArgument2, functionArgument3}, false);
    }

    public OLAPFunctionQuery(String string, String string2, FunctionArgument functionArgument, FunctionArgument functionArgument2, FunctionArgument functionArgument3, FunctionArgument functionArgument4) {
        this(string, string2, new FunctionArgument[]{functionArgument, functionArgument2, functionArgument3, functionArgument4}, false);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitOLAPFunctionQuery(this, object);
    }

    public FunctionArgument[] getArguments() {
        return (FunctionArgument[])this.getArgumentsInternal().clone();
    }

    public FunctionDescriptor getFunctionDescriptor() {
        return this.m_FunctionDescriptor;
    }

    public String getFunctionName() {
        return this.m_FunctionName;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public boolean isCompositeObject() {
        return true;
    }

    @Override
    public List<ColumnExpression> getColumnExpressions() {
        return null;
    }

    @Override
    public ColumnExpression getColumnExpression(String string) {
        return null;
    }
}

