/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.metadata.mdm.MdmBaseMeasure;
import oracle.olapi.syntax.BaseMetadataObjectReference;
import oracle.olapi.syntax.Expression;
import oracle.olapi.syntax.FunctionArgument;
import oracle.olapi.syntax.FunctionDescriptor;
import oracle.olapi.syntax.FunctionDescriptorCatalog;
import oracle.olapi.syntax.MetadataObjectReference;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValidationContext;
import oracle.olapi.syntax.parser.ExpParser;

public final class AggregationCase
extends SyntaxObject {
    private String m_FunctionName;
    private FunctionDescriptor m_FunctionDescriptor;
    private FunctionArgument[] m_Arguments;
    private BaseMetadataObjectReference m_Measure;
    private TypedExpression m_AggregationSwitchValue;

    private FunctionArgument[] getArgumentsInternal() {
        return this.m_Arguments;
    }

    private BaseMetadataObjectReference getMeasureReference() {
        return this.m_Measure;
    }

    AggregationCase(String string, FunctionArgument[] functionArgumentArray, MdmBaseMeasure mdmBaseMeasure, boolean bl) {
        AggregationCase.validateValue(string);
        AggregationCase.validateValue(mdmBaseMeasure);
        this.m_FunctionName = string;
        this.m_Measure = new MetadataObjectReference(mdmBaseMeasure, MdmBaseMeasure.class);
        this.m_AggregationSwitchValue = null;
        this.m_Arguments = null != functionArgumentArray && bl ? AggregationCase.getFunctionArgumentArrayClone(functionArgumentArray) : (null != functionArgumentArray ? functionArgumentArray : new FunctionArgument[0]);
        this.initialize();
    }

    AggregationCase(ExpParser expParser, String string, FunctionArgument[] functionArgumentArray, BaseMetadataObjectReference baseMetadataObjectReference, boolean bl) {
        AggregationCase.validateValue(string);
        AggregationCase.validateValue(baseMetadataObjectReference);
        this.m_FunctionName = string;
        this.m_Measure = baseMetadataObjectReference;
        this.m_AggregationSwitchValue = null;
        this.m_Arguments = null != functionArgumentArray && bl ? AggregationCase.getFunctionArgumentArrayClone(functionArgumentArray) : (null != functionArgumentArray ? functionArgumentArray : new FunctionArgument[0]);
        this.initialize();
    }

    AggregationCase(String string, FunctionArgument[] functionArgumentArray, TypedExpression typedExpression, boolean bl) {
        AggregationCase.validateValue(string);
        AggregationCase.validateValue(typedExpression);
        this.m_FunctionName = string;
        this.m_AggregationSwitchValue = typedExpression;
        this.m_Measure = null;
        this.m_Arguments = null != functionArgumentArray && bl ? AggregationCase.getFunctionArgumentArrayClone(functionArgumentArray) : (null != functionArgumentArray ? functionArgumentArray : new FunctionArgument[0]);
        this.initialize();
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        if (null != this.m_Measure || null != this.m_AggregationSwitchValue && syntaxPrintingContext.isMetadataXMLVersionSameOrLaterThan("2.0")) {
            syntaxPrintingContext.append(" WHEN ");
            if (null != this.getMeasureReference()) {
                this.getMeasureReference().toSyntax(syntaxPrintingContext);
            } else {
                syntaxPrintingContext.print(this.getAggregationSwitchValue());
            }
            syntaxPrintingContext.append(" THEN ");
            if (this.getFunctionName().equalsIgnoreCase("NO AGGREGATE") && !syntaxPrintingContext.isMetadataXMLVersionSameOrLaterThan("2.0")) {
                if (null != this.getMeasure() && this.getMeasure().getSQLDataType().getDataType().matchesCategory(2)) {
                    syntaxPrintingContext.append("SUM");
                } else {
                    syntaxPrintingContext.append("MAX");
                }
            } else {
                syntaxPrintingContext.append(this.getFunctionName());
            }
            if (null != this.getArgumentsInternal() && this.getArgumentsInternal().length > 0) {
                Expression.printExpressions(this.getArgumentsInternal(), syntaxPrintingContext);
            }
        }
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        FunctionArgument[] functionArgumentArray = null;
        if (null != this.getArgumentsInternal()) {
            functionArgumentArray = new FunctionArgument[this.getArgumentsInternal().length];
        }
        this.m_FunctionDescriptor = FunctionDescriptorCatalog.getValidFunctionDescriptor(this.getFunctionName(), this.getArgumentsInternal(), functionArgumentArray, null, null, 16, "UnknownSolveFunction", validationContext);
        this.m_Arguments = functionArgumentArray;
        if (null != this.getAggregationSwitchValue()) {
            this.m_AggregationSwitchValue = validationContext.validateExp(this.getAggregationSwitchValue());
        }
        if (null != this.m_Measure) {
            this.m_Measure = (BaseMetadataObjectReference)validationContext.validate(this.m_Measure);
        }
        validationContext.pop();
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        if (null != this.getMeasureReference() && !this.getMeasureReference().isDefinitionComplete()) {
            return false;
        }
        if (null != this.getArgumentsInternal()) {
            return this.areComponentsComplete(this.getArgumentsInternal());
        }
        return super.checkIfDefinitionIsComplete();
    }

    public AggregationCase(String string, List<FunctionArgument> list, MdmBaseMeasure mdmBaseMeasure) {
        this(string, AggregationCase.getFunctionArgumentArrayClone(list), mdmBaseMeasure, false);
    }

    public AggregationCase(ExpParser expParser, String string, List<FunctionArgument> list, BaseMetadataObjectReference baseMetadataObjectReference) {
        this(expParser, string, AggregationCase.getFunctionArgumentArrayClone(list), baseMetadataObjectReference, false);
    }

    public AggregationCase(String string, FunctionArgument[] functionArgumentArray, MdmBaseMeasure mdmBaseMeasure) {
        this(string, functionArgumentArray, mdmBaseMeasure, true);
    }

    public AggregationCase(String string, List<FunctionArgument> list, TypedExpression typedExpression) {
        this(string, AggregationCase.getFunctionArgumentArrayClone(list), typedExpression, false);
    }

    public AggregationCase(String string, FunctionArgument[] functionArgumentArray, TypedExpression typedExpression) {
        this(string, functionArgumentArray, typedExpression, true);
    }

    public FunctionArgument[] getArguments() {
        return (FunctionArgument[])this.getArgumentsInternal().clone();
    }

    public FunctionDescriptor getFunctionDescriptor() {
        return this.m_FunctionDescriptor;
    }

    public String getFunctionName() {
        return this.m_FunctionName;
    }

    public MdmBaseMeasure getMeasure() {
        if (null != this.m_Measure) {
            return (MdmBaseMeasure)this.m_Measure.getBaseMetadataObject();
        }
        return null;
    }

    public String getMeasureID() {
        if (null != this.m_Measure) {
            return this.m_Measure.getIdentifier().toString();
        }
        return null;
    }

    public TypedExpression getAggregationSwitchValue() {
        return this.m_AggregationSwitchValue;
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitAggregationCase(this, object);
    }
}

