/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.util;

import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import oracle.jdbc.OracleConnection;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.metadata.XMLParserCallback;
import oracle.olapi.metadata.mdm.MdmDatabaseSchema;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.util.TolerantXMLParserCallback;
import oracle.olapi.metadata.util.UtilityBase;
import oracle.olapi.transaction.CommitWarningsException;

public final class CreateAW
extends UtilityBase {
    public static final String SCHEMA_FILE_PROPERTY = "SchemaFile";
    public static final String DUMP_XML = "DumpXML";
    public static final String TOLERANT = "Tolerant";
    public static final String DEBUG = "Debug";

    private static FileReader openXMLFile(Properties properties) {
        String string = (String)properties.get(SCHEMA_FILE_PROPERTY);
        if (null == string) {
            throw new IllegalArgumentException("Must specifiy -SchemaFile");
        }
        try {
            return new FileReader(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to open file: " + string);
        }
    }

    private static void exportXML(MdmMetadataProvider mdmMetadataProvider, MdmDatabaseSchema mdmDatabaseSchema) {
        ArrayList<MdmDatabaseSchema> arrayList = new ArrayList<MdmDatabaseSchema>();
        arrayList.add(mdmDatabaseSchema);
        String string = null;
        try {
            string = mdmMetadataProvider.exportFullXML(arrayList, null, false);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        Properties properties = CreateAW.parseCommandLineProperties(stringArray);
        Properties properties2 = (Properties)properties.clone();
        boolean bl = null != properties2.get(DEBUG);
        try {
            Object object;
            OracleConnection oracleConnection = CreateAW.connect(properties2);
            FileReader fileReader = CreateAW.openXMLFile(properties2);
            DataProvider dataProvider = CreateAW.createDataProvider(oracleConnection, properties2);
            MdmMetadataProvider mdmMetadataProvider = dataProvider.getMdmMetadataProvider();
            MdmDatabaseSchema mdmDatabaseSchema = CreateAW.getDatabaseSchema(mdmMetadataProvider, properties2);
            System.out.println("Importing XML...");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                if (((String)object).equals(SCHEMA_FILE_PROPERTY) || ((String)object).equals(DUMP_XML) || ((String)object).equals(TOLERANT) || ((String)object).equals("trace") || ((String)object).equals("password") || ((String)object).equals("user") || ((String)object).equals("url") || ((String)object).equals(DEBUG)) continue;
                String string = (String)properties2.get(object);
                hashMap.put((String)object, string);
                if (!bl) continue;
                System.out.println("Bind variable: " + (String)object + " = " + string);
            }
            object = null;
            if ("YES".equalsIgnoreCase((String)properties2.get(TOLERANT))) {
                System.out.println("[Tolerant Mode]");
                object = new TolerantXMLParserCallback();
            }
            mdmMetadataProvider.importXML(fileReader, mdmDatabaseSchema, true, hashMap, (XMLParserCallback)object);
            System.out.println("Import Successful");
            if ("YES".equalsIgnoreCase((String)properties2.get(DUMP_XML))) {
                CreateAW.exportXML(mdmMetadataProvider, mdmDatabaseSchema);
            } else {
                System.out.println("Committing...");
                try {
                    dataProvider.getTransactionProvider().commitCurrentTransaction();
                    System.out.println("Commit Successful");
                }
                catch (CommitWarningsException commitWarningsException) {
                    System.out.println("Commit Successful With Warnings");
                    System.out.println(commitWarningsException.getErrorText());
                }
                CreateAW.dumpSQL(oracleConnection, "SELECT AW_NAME\nFROM USER_AWS\nORDER BY AW_NAME", "\n** AWS **\n");
                CreateAW.dumpSQL(oracleConnection, "SELECT DIMENSION_NAME\nFROM USER_CUBE_DIMENSIONS\nORDER BY DIMENSION_NAME\n", "\n** DIMENSIONS **\n");
                CreateAW.dumpSQL(oracleConnection, "SELECT CUBE_NAME\nFROM USER_CUBES\nORDER BY CUBE_NAME\n", "\n** CUBES **\n");
                CreateAW.dumpSQL(oracleConnection, "SELECT MVIEW_NAME\nFROM USER_MVIEWS\nORDER BY MVIEW_NAME\n", "\n** MATERIALIZED VIEWS **\n");
            }
            dataProvider.close();
            oracleConnection.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.toString());
        }
    }
}

