/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

public abstract class MetadataXMLWriter {
    private StringBuffer m_StringBuffer = null;
    private int m_IndentLevel = 0;

    protected void append(String string) {
        this.getStringBuffer().append(string);
    }

    protected void append(char c) {
        this.getStringBuffer().append(c);
    }

    protected void appendAttribute(String string, String string2) {
        if (null == string2) {
            return;
        }
        this.newLine();
        this.append(string);
        this.append("=");
        this.quote(string2);
    }

    protected void beginElement(String string) {
        this.newLine();
        this.openTag();
        this.append(string);
        this.incrementIndentLevel();
    }

    protected void closeTag() {
        this.append(">");
    }

    private void decrementIndentLevel() {
        --this.m_IndentLevel;
    }

    protected void endElement() {
        this.slash();
        this.closeTag();
        this.decrementIndentLevel();
    }

    protected void endElement(String string) {
        this.decrementIndentLevel();
        this.newLine();
        this.openTag();
        this.slash();
        this.append(string);
        this.closeTag();
    }

    private int getIndentLevel() {
        return this.m_IndentLevel;
    }

    protected StringBuffer getStringBuffer() {
        return this.m_StringBuffer;
    }

    private void incrementIndentLevel() {
        ++this.m_IndentLevel;
    }

    protected void newLine() {
        this.append("\n");
    }

    protected void openTag() {
        this.append('<');
    }

    protected void quote(String string) {
        this.append('\"');
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    this.append("%lt;");
                    continue block6;
                }
                case '>': {
                    this.append("%gt;");
                    continue block6;
                }
                case '&': {
                    this.append("%amp;");
                    continue block6;
                }
                case '\"': {
                    this.append("%quot;");
                    continue block6;
                }
                default: {
                    this.append(c);
                    continue block6;
                }
            }
        }
        this.append('\"');
    }

    protected void setStringBuffer(StringBuffer stringBuffer) {
        this.m_StringBuffer = stringBuffer;
    }

    protected void slash() {
        this.append('/');
    }
}

