/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.MetadataObjectHolder;

final class MetadataObjectFetchState {
    private MetadataObjectHolder m_Holder = null;
    private int m_OrigFetchStatus;
    private boolean m_IsPersistent = false;
    private boolean m_IsTopFetchState = false;
    private MetadataObjectFetchState m_TopFetchState = null;
    private MetadataObjectFetchState m_DuplicateState = null;

    MetadataObjectFetchState(MetadataObjectHolder metadataObjectHolder) {
        this(metadataObjectHolder, false);
    }

    private MetadataObjectFetchState(MetadataObjectHolder metadataObjectHolder, boolean bl) {
        this.m_Holder = metadataObjectHolder;
        this.m_OrigFetchStatus = metadataObjectHolder.getFetchStatus();
        this.m_IsTopFetchState = bl;
        if (2 == this.m_OrigFetchStatus) {
            MetadataObjectHolder metadataObjectHolder2;
            BaseMetadataObject baseMetadataObject = (BaseMetadataObject)metadataObjectHolder.getMetadataObject();
            this.m_IsPersistent = false;
            if (null != baseMetadataObject.getPersistentState()) {
                this.m_IsPersistent = true;
            }
            if (!bl && null != (metadataObjectHolder2 = this.getTopLevelHolderForRefetch()) && metadataObjectHolder2 != metadataObjectHolder) {
                this.m_TopFetchState = new MetadataObjectFetchState(metadataObjectHolder2, true);
            }
        }
    }

    boolean isMatchingFetchRequest(MetadataObjectFetchState metadataObjectFetchState) {
        return metadataObjectFetchState.getHolder() == this.getHolder() || metadataObjectFetchState.getTopHolder() == this.getHolder() || metadataObjectFetchState.getHolder() == this.getTopHolder() || null != this.getTopHolder() && metadataObjectFetchState.getTopHolder() == this.getTopHolder();
    }

    void updateAsDuplicateFetch(MetadataObjectFetchState metadataObjectFetchState) {
        this.m_DuplicateState = metadataObjectFetchState;
    }

    boolean needsFetch() {
        if (this.isDuplicateFetch()) {
            return false;
        }
        if (0 == this.getOriginalFetchStatus()) {
            return true;
        }
        if (1 == this.getOriginalFetchStatus() || 3 == this.getOriginalFetchStatus()) {
            return false;
        }
        BaseMetadataObject baseMetadataObject = (BaseMetadataObject)this.getHolder().getMetadataObject();
        return null != this.getTopFetchState() || baseMetadataObject.isTopLevelObject();
    }

    String getIDToFetch() {
        if (!this.needsFetch()) {
            return null;
        }
        if (null == this.getTopFetchState()) {
            return this.getHolder().getObjectID();
        }
        return this.getTopHolder().getObjectID();
    }

    void applyPreFetch() {
        BaseMetadataObject baseMetadataObject;
        this.getHolder().setFetchStatus(3);
        if (null != this.getTopFetchState()) {
            this.getTopFetchState().applyPreFetch();
        }
        if (null != (baseMetadataObject = (BaseMetadataObject)this.getHolder().getMetadataObject()) && baseMetadataObject.isTopLevelObject() && 2 == this.getOriginalFetchStatus()) {
            baseMetadataObject.revertPersistentState();
        }
    }

    void applyPostFetch() {
        BaseMetadataObject baseMetadataObject;
        if (3 != this.getOriginalFetchStatus()) {
            this.getHolder().setFetchStatus(1);
        }
        if (this.isPersistentBeforeFetch() && 2 == this.getOriginalFetchStatus() && (null == (baseMetadataObject = (BaseMetadataObject)this.getHolder().getMetadataObject()).getPersistentState() || baseMetadataObject.getPersistentState().isEmpty())) {
            baseMetadataObject.updatePersistentState((short)-1);
        }
        if (null != this.getTopFetchState()) {
            this.getTopFetchState().applyPostFetch();
        }
    }

    MetadataObjectHolder getHolder() {
        return this.m_Holder;
    }

    private MetadataObjectHolder getTopHolder() {
        if (null == this.getTopFetchState()) {
            return null;
        }
        return this.getTopFetchState().getHolder();
    }

    private MetadataObjectFetchState getTopFetchState() {
        return this.m_TopFetchState;
    }

    private int getOriginalFetchStatus() {
        return this.m_OrigFetchStatus;
    }

    private boolean isDuplicateFetch() {
        return null != this.m_DuplicateState;
    }

    private boolean isPersistentBeforeFetch() {
        return this.m_IsPersistent;
    }

    private MetadataObjectHolder getTopLevelHolderForRefetch() {
        BaseMetadataObject baseMetadataObject = (BaseMetadataObject)this.m_Holder.getMetadataObject();
        BaseMetadataObject baseMetadataObject2 = null;
        while (!baseMetadataObject.isTopLevelObject()) {
            baseMetadataObject2 = baseMetadataObject;
            int n = baseMetadataObject2.getHolder().getFetchStatus();
            baseMetadataObject2.getHolder().setFetchStatus(1);
            baseMetadataObject = baseMetadataObject2.getContainedByObject();
            baseMetadataObject2.getHolder().setFetchStatus(n);
            if (null == baseMetadataObject) break;
            int n2 = baseMetadataObject.getHolder().getFetchStatus();
            if (2 == n2) continue;
            return null;
        }
        if (null == baseMetadataObject) {
            return null;
        }
        return baseMetadataObject.getHolder();
    }
}

