/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.data.source;

import java.util.Date;
import java.util.List;
import java.util.Set;
import oracle.olapi.data.cursor.SourceIdentifier;
import oracle.olapi.data.source.AliasDefinition;
import oracle.olapi.data.source.BooleanSource;
import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.DistinctDefinition;
import oracle.olapi.data.source.ExtractDefinition;
import oracle.olapi.data.source.FundamentalDefinition;
import oracle.olapi.data.source.FundamentalMetadataProvider;
import oracle.olapi.data.source.JoinDefinition;
import oracle.olapi.data.source.Model;
import oracle.olapi.data.source.NullSourceDefinition;
import oracle.olapi.data.source.NumberSource;
import oracle.olapi.data.source.PositionDefinition;
import oracle.olapi.data.source.RecursiveJoinDefinition;
import oracle.olapi.data.source.SourceDefinition;
import oracle.olapi.data.source.SourceExpressionFactory;
import oracle.olapi.data.source.StringSource;
import oracle.olapi.data.source.ValueDefinition;
import oracle.olapi.metadata.MetadataProvider;
import oracle.olapi.transaction.Transaction;
import oracle.olapi.transaction.TransactionalObject;

public class Source
implements SourceIdentifier,
TransactionalObject {
    private static final int _COMPARISON_RULE_FIRST = 0;
    public static final int COMPARISON_RULE_ASCENDING = 1;
    public static final int COMPARISON_RULE_ASCENDING_NULLS_FIRST = 4;
    public static final int COMPARISON_RULE_ASCENDING_NULLS_LAST = 1;
    public static final int COMPARISON_RULE_DESCENDING = 2;
    public static final int COMPARISON_RULE_DESCENDING_NULLS_FIRST = 2;
    public static final int COMPARISON_RULE_DESCENDING_NULLS_LAST = 5;
    public static final int COMPARISON_RULE_REMOVE = 3;
    public static final int COMPARISON_RULE_SELECT = 0;
    private static final int _COMPARISON_RULE_LAST = 5;
    private SourceDefinition m_Definition;

    Source(SourceDefinition sourceDefinition) {
        this.setDefinition(sourceDefinition);
        sourceDefinition.setLocalSource(this);
    }

    public final Source alias() {
        Transaction transaction = this.getDefinition().getIncrementalTransaction();
        AliasDefinition aliasDefinition = new AliasDefinition(this.getDefinition(), transaction);
        return aliasDefinition.createSource(transaction);
    }

    public final Source appendValue(Source source) {
        return this.appendValues(source);
    }

    public final Source appendValues(Source[] sourceArray) {
        return this.appendValues(this.getDataProvider().createListSource(sourceArray));
    }

    public final Source appendValues(Source source) {
        Source source2 = this.getDataProvider().createListSource(new Source[]{this, source});
        return source2.extract().joinHidden(source2);
    }

    public final Source at(int n) {
        return this.join((Source)this.position(), n);
    }

    public final Source at(NumberSource numberSource) {
        return this.join((Source)this.position(), numberSource);
    }

    private static void checkComparisonRule(int n) throws IllegalArgumentException {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException();
        }
    }

    public final NumberSource count() {
        return this.count(true);
    }

    public final NumberSource count(boolean bl) {
        return this.getSourceExpressionFactory().count(this, bl);
    }

    Source createInstance(SourceDefinition sourceDefinition) {
        return new Source(sourceDefinition);
    }

    public final Source cumulativeInterval() {
        return this.interval(this.getDataProvider().createListSource(new int[]{1}), this.position());
    }

    public final Source cumulativeInterval(int n) {
        return this.cumulativeInterval(this.getDataProvider().createListSource(new int[]{n}));
    }

    public final Source cumulativeInterval(NumberSource numberSource) {
        return this.interval(this.getDataProvider().createListSource(new int[]{1}), this.position().plus(numberSource));
    }

    public final Source distinct() {
        Transaction transaction = this.getDefinition().getIncrementalTransaction();
        DistinctDefinition distinctDefinition = new DistinctDefinition(this.getDefinition(), transaction);
        return distinctDefinition.createSource(transaction);
    }

    public final BooleanSource eq(Source source) {
        return this.getSourceExpressionFactory().eq(this, source);
    }

    public final Source extract() {
        Transaction transaction = this.getDefinition().getIncrementalTransaction();
        if (this.getDataProvider().isServerVersionLaterThan(new int[]{10, 1, 0, 3})) {
            Model model = this.getDefinition().findOrCreateExtractModel(this, transaction);
            return model.createSolvedSource();
        }
        ExtractDefinition extractDefinition = new ExtractDefinition(this.getDefinition(), transaction);
        return extractDefinition.createSource(transaction);
    }

    public final Source findMatchFor(Source source) {
        return this.getDefinition().findMatchSourceFor(source.getDefinition());
    }

    public final Source first() {
        return this.at(1);
    }

    public final BooleanSource ge(Source source) {
        return this.getSourceExpressionFactory().ge(this, source);
    }

    public final DataProvider getDataProvider() {
        return this.getDefinition().getDataProvider();
    }

    public Source getDataType() {
        return this.getDataProvider().getFundamentalMetadataProvider().getValueDataType().getSource();
    }

    public final SourceDefinition getDefinition() {
        return this.m_Definition;
    }

    public final Set getExtractionInputs() {
        return this.getDefinition().getExtractionInputs();
    }

    @Override
    public final String getID() {
        return this.getDefinition().getID();
    }

    public final Set getInputs() {
        return this.getDefinition().getInputs();
    }

    public final MetadataProvider getMetadataProvider() {
        return this.getDefinition().getMetadataProvider();
    }

    @Override
    public final String getMetadataProviderID() {
        return this.getMetadataProvider().getID();
    }

    public Model getModel() {
        return this.getDefinition().getModel();
    }

    public final List getOutputs() {
        return this.getDefinition().getOutputs();
    }

    @Override
    public final String getPersistentID() {
        return this.getDefinition().getPersistentID();
    }

    public final Set getRegularInputs() {
        return this.getDefinition().getRegularInputs();
    }

    public final Source getType() {
        return this.getDefinition().getTypeSource();
    }

    public final BooleanSource gt(Source source) {
        return this.getSourceExpressionFactory().gt(this, source);
    }

    public final BooleanSource hasValue() {
        return this.getSourceExpressionFactory().hasValue(this);
    }

    public final BooleanSource in(Source source) {
        return this.eq(source).forAny();
    }

    public final Source interval(int n, int n2) {
        return this.interval(this.getDataProvider().createListSource(new int[]{n}), this.getDataProvider().createListSource(new int[]{n2}));
    }

    public final Source interval(NumberSource numberSource, NumberSource numberSource2) {
        NumberSource numberSource3 = this.getDataProvider().createRangeSource(numberSource, numberSource2);
        return this.join((Source)this.position(), numberSource3);
    }

    public final boolean isSubtypeOf(Source source) {
        return this.getDefinition().isSubtypeOf(source.getDefinition());
    }

    public final Source join(Source source) {
        return this.join(source, this.getDataProvider().getEmptySource(), 3, true);
    }

    public final Source join(Source source, double[] dArray) {
        return this.join(source, this.getDataProvider().createListSource(dArray));
    }

    public final Source join(Source source, float[] fArray) {
        return this.join(source, this.getDataProvider().createListSource(fArray));
    }

    public final Source join(Source source, int[] nArray) {
        return this.join(source, this.getDataProvider().createListSource(nArray));
    }

    public final Source join(Source source, String[] stringArray) {
        return this.join(source, this.getDataProvider().createListSource(stringArray));
    }

    public final Source join(Source source, Date[] dateArray) {
        return this.join(source, this.getDataProvider().createListSource(dateArray));
    }

    public final Source join(Source source, short[] sArray) {
        return this.join(source, this.getDataProvider().createListSource(sArray));
    }

    public final Source join(Source source, boolean[] blArray) {
        return this.join(source, this.getDataProvider().createListSource(blArray));
    }

    public final Source join(Source source, double d) {
        return this.join(source, new double[]{d});
    }

    public final Source join(Source source, float f) {
        return this.join(source, new float[]{f});
    }

    public final Source join(Source source, int n) {
        return this.join(source, new int[]{n});
    }

    public final Source join(Source source, String string) {
        return this.join(source, new String[]{string});
    }

    public final Source join(Source source, Date date) {
        return this.join(source, new Date[]{date});
    }

    public final Source join(Source source, Source source2) {
        return this.join(source, source2, 0, false);
    }

    public final Source join(Source source, Source source2, int n) {
        return this.join(source, source2, n, false);
    }

    public final Source join(Source source, Source source2, int n, boolean bl) {
        Source.checkComparisonRule(n);
        Transaction transaction = this.getDefinition().getIncrementalTransaction();
        source.getDefinition().checkValidity(transaction);
        source2.getDefinition().checkValidity(transaction);
        JoinDefinition joinDefinition = new JoinDefinition(this.getDefinition(), source.getDefinition(), source2.getDefinition(), n, bl, transaction);
        return joinDefinition.createSource(transaction);
    }

    public final Source join(Source source, Source source2, boolean bl) {
        return this.join(source, source2, 0, bl);
    }

    public final Source join(Source source, short s) {
        return this.join(source, new short[]{s});
    }

    public final Source join(Source source, boolean bl) {
        return this.join(source, new boolean[]{bl});
    }

    public final Source joinHidden(Source source) {
        return this.join(source, this.getDataProvider().getEmptySource(), 3, false);
    }

    public final Source last() {
        return this.at(this.count());
    }

    public final BooleanSource le(Source source) {
        return this.getSourceExpressionFactory().le(this, source);
    }

    public final BooleanSource lt(Source source) {
        return this.getSourceExpressionFactory().lt(this, source);
    }

    public final Source movingInterval(int n, int n2) {
        return this.movingInterval(this.getDataProvider().createListSource(new int[]{n}), this.getDataProvider().createListSource(new int[]{n2}));
    }

    public final Source movingInterval(NumberSource numberSource, NumberSource numberSource2) {
        return this.interval(this.position().plus(numberSource), this.position().plus(numberSource2));
    }

    public final BooleanSource ne(Source source) {
        return this.getSourceExpressionFactory().ne(this, source);
    }

    public final Source nullSource() {
        Transaction transaction = this.getDefinition().getIncrementalTransaction();
        NullSourceDefinition nullSourceDefinition = new NullSourceDefinition(this.getDefinition(), transaction);
        return nullSourceDefinition.createSource(transaction);
    }

    public final Source offset(int n) {
        return this.join((Source)this.position(), this.position().plus(n));
    }

    public final Source offset(NumberSource numberSource) {
        return this.join((Source)this.position(), this.position().plus(numberSource));
    }

    public final NumberSource position() {
        return this.position(false);
    }

    public final NumberSource position(boolean bl) {
        Transaction transaction = this.getDefinition().getIncrementalTransaction();
        PositionDefinition positionDefinition = new PositionDefinition(this.getDefinition(), bl, transaction);
        return (NumberSource)positionDefinition.createSource(transaction);
    }

    public final NumberSource positionOfValue(Source source) {
        return this.positionOfValues(new Source[]{source});
    }

    public final NumberSource positionOfValues(Source[] sourceArray) {
        return this.positionOfValues(this.getDataProvider().createListSource(sourceArray));
    }

    public final NumberSource positionOfValues(Source source) {
        return (NumberSource)this.position().join(this, source);
    }

    public final Source recursiveJoin(Source source, Source source2, Source source3, int n, boolean bl, boolean bl2, int n2, boolean bl3) {
        if (bl) {
            if (5 == n) {
                n = 2;
            }
            if (1 == n) {
                n = 4;
            }
        } else {
            if (2 == n) {
                n = 5;
            }
            if (4 == n) {
                n = 1;
            }
        }
        Source.checkComparisonRule(n);
        Transaction transaction = this.getDefinition().getIncrementalTransaction();
        source.getDefinition().checkValidity(transaction);
        source2.getDefinition().checkValidity(transaction);
        RecursiveJoinDefinition recursiveJoinDefinition = new RecursiveJoinDefinition(this.getDefinition(), source.getDefinition(), source2.getDefinition(), source3.getDefinition(), n, bl, bl2, n2, bl3, transaction);
        return recursiveJoinDefinition.createSource(transaction);
    }

    public final Source recursiveJoin(Source source, Source source2, Source source3, int n, boolean bl, boolean bl2) {
        return this.recursiveJoin(source, source2, source3, n, bl, bl2, 10, false);
    }

    public final Source recursiveJoin(Source source, String string, Source source2, int n, boolean bl, boolean bl2) {
        return this.recursiveJoin(source, new String[]{string}, source2, n, bl, bl2);
    }

    public final Source recursiveJoin(Source source, String[] stringArray, Source source2, int n, boolean bl, boolean bl2) {
        return this.recursiveJoin(source, this.getDataProvider().createListSource(stringArray), source2, n, bl, bl2);
    }

    public final Source recursiveJoin(Source source, Source source2, Source source3, int n) {
        return this.recursiveJoin(source, source2, source3, n, true, true);
    }

    public final Source recursiveJoin(Source source, String string, Source source2, int n) {
        return this.recursiveJoin(source, new String[]{string}, source2, n);
    }

    public final Source recursiveJoin(Source source, String[] stringArray, Source source2, int n) {
        return this.recursiveJoin(source, this.getDataProvider().createListSource(stringArray), source2, n);
    }

    public final Source remove(BooleanSource booleanSource) {
        return this.join((Source)booleanSource, this.getDataProvider().createListSource(new boolean[]{false}));
    }

    public final Source removeValue(Source source) {
        return this.removeValues(this.getDataProvider().createListSource(new Source[]{source}));
    }

    public final Source removeValues(Source[] sourceArray) {
        return this.removeValues(this.getDataProvider().createListSource(sourceArray));
    }

    public final Source removeValues(Source source) {
        return this.join(this.value(), source, 3, false);
    }

    public final Source select(BooleanSource booleanSource) {
        return this.join((Source)booleanSource, this.getDataProvider().createListSource(new boolean[]{true}));
    }

    public final Source selectDescendants(Source source, Source source2) {
        Transaction transaction = this.getDefinition().getIncrementalTransaction();
        SourceDefinition sourceDefinition = this.getDefinition().getHiddenType(transaction);
        if (!(sourceDefinition instanceof FundamentalDefinition)) {
            while (!(((SourceDefinition)sourceDefinition).getType(transaction) instanceof FundamentalDefinition)) {
                sourceDefinition = ((SourceDefinition)sourceDefinition).getType(transaction);
            }
        }
        Source source3 = sourceDefinition.getSource();
        return this.recursiveJoin(source3.value(), source, source2, 0);
    }

    public final Source selectValue(Source source) {
        return this.selectValues(new Source[]{source});
    }

    public final Source selectValues(Source[] sourceArray) {
        return this.selectValues(this.getDataProvider().createListSource(sourceArray));
    }

    public final Source selectValues(Source source) {
        return this.join(this.value(), source, 0, false);
    }

    private void setDefinition(SourceDefinition sourceDefinition) {
        this.m_Definition = sourceDefinition;
    }

    public final Source sortAscending() {
        return this.sortAscending(this.value(), false);
    }

    public final Source sortAscending(Source source) {
        return this.sortAscending(source, false);
    }

    public final Source sortAscending(Source source, boolean bl) {
        int n = 4;
        if (!bl) {
            n = 1;
        }
        return this.join(source, source.getDataType(), n, false);
    }

    public final Source sortAscendingHierarchically(Source source, Source source2, boolean bl, boolean bl2) {
        return this.recursiveJoin(source, source.getDataType(), source2, 1, bl, bl2);
    }

    public final Source sortAscendingHierarchically(Source source, Source source2) {
        return this.sortAscendingHierarchically(source, source2, true, true);
    }

    public final Source sortAscendingHierarchically(Source source, boolean bl) {
        Transaction transaction = this.getDefinition().getIncrementalTransaction();
        SourceDefinition sourceDefinition = this.getDefinition().getHiddenType(transaction);
        if (!(sourceDefinition instanceof FundamentalDefinition)) {
            while (!(((SourceDefinition)sourceDefinition).getType(transaction) instanceof FundamentalDefinition)) {
                sourceDefinition = ((SourceDefinition)sourceDefinition).getType(transaction);
            }
        }
        Source source2 = sourceDefinition.getSource();
        return this.recursiveJoin(source2.value(), this.getDataType(), source, 1, bl, true);
    }

    public final Source sortAscendingHierarchically(Source source) {
        return this.sortAscendingHierarchically(source, true);
    }

    public final Source sortDescending() {
        return this.sortDescending(this.value(), true);
    }

    public final Source sortDescending(Source source) {
        return this.sortDescending(source, true);
    }

    public final Source sortDescending(Source source, boolean bl) {
        int n = 2;
        if (!bl) {
            n = 5;
        }
        return this.join(source, source.getDataType(), n, false);
    }

    public final Source sortDescendingHierarchically(Source source, Source source2, boolean bl, boolean bl2) {
        return this.recursiveJoin(source, source.getDataType(), source2, 2, bl, bl2);
    }

    public final Source sortDescendingHierarchically(Source source, Source source2) {
        return this.sortDescendingHierarchically(source, source2, true, true);
    }

    public final Source sortDescendingHierarchically(Source source, boolean bl) {
        Transaction transaction = this.getDefinition().getIncrementalTransaction();
        SourceDefinition sourceDefinition = this.getDefinition().getHiddenType(transaction);
        if (!(sourceDefinition instanceof FundamentalDefinition)) {
            while (!(((SourceDefinition)sourceDefinition).getType(transaction) instanceof FundamentalDefinition)) {
                sourceDefinition = ((SourceDefinition)sourceDefinition).getType(transaction);
            }
        }
        Source source2 = sourceDefinition.getSource();
        return this.recursiveJoin(source2.value(), this.getDataType(), source, 2, bl, true);
    }

    public final Source sortDescendingHierarchically(Source source) {
        return this.sortDescendingHierarchically(source, true);
    }

    public final NumberSource toDoubleSource() {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getDataProvider().getFundamentalMetadataProvider();
        return (NumberSource)fundamentalMetadataProvider.getToDoubleFunction().getSource().join(fundamentalMetadataProvider.getToDoubleArgParameter().getSource(), this);
    }

    public final NumberSource toFloatSource() {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getDataProvider().getFundamentalMetadataProvider();
        return (NumberSource)fundamentalMetadataProvider.getToFloatFunction().getSource().join(fundamentalMetadataProvider.getToFloatArgParameter().getSource(), this);
    }

    public final NumberSource toIntegerSource() {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getDataProvider().getFundamentalMetadataProvider();
        return (NumberSource)fundamentalMetadataProvider.getToIntegerFunction().getSource().join(fundamentalMetadataProvider.getToIntegerArgParameter().getSource(), this);
    }

    public final NumberSource toShortSource() {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getDataProvider().getFundamentalMetadataProvider();
        return (NumberSource)fundamentalMetadataProvider.getToShortFunction().getSource().join(fundamentalMetadataProvider.getToShortArgParameter().getSource(), this);
    }

    public StringSource toStringSource() {
        FundamentalMetadataProvider fundamentalMetadataProvider = this.getDataProvider().getFundamentalMetadataProvider();
        return (StringSource)fundamentalMetadataProvider.getToStringFunction().getSource().join(fundamentalMetadataProvider.getToStringArgParameter().getSource(), this);
    }

    public final Source value() {
        return this.value(this);
    }

    public final Source value(Source source) {
        Transaction transaction = this.getDefinition().getIncrementalTransaction();
        ValueDefinition valueDefinition = new ValueDefinition(this.getDefinition(), source.getDefinition(), transaction);
        return valueDefinition.createSource(transaction);
    }

    protected final SourceExpressionFactory getSourceExpressionFactory() {
        return this.getDataProvider().getSourceExpressionFactory();
    }

    @Override
    public Object getTransactionalState(Transaction transaction) {
        return this.getDefinition();
    }

    @Override
    public Transaction getActiveTransaction() {
        return this.getDefinition().getActiveTransaction();
    }
}

