/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.olapi.data;

import java.util.Set;
import oracle.express.olapi.data.CursorBlock;
import oracle.express.olapi.data.CursorBlockManager;
import oracle.express.olapi.data.CursorTreeManager;

abstract class CursorBlockProvider {
    private CursorBlockManager _cursorBlockManager;
    private int _readCount;
    private boolean _writing;

    public CursorBlockProvider(CursorBlockManager cursorBlockManager) {
        this._cursorBlockManager = cursorBlockManager;
        this._readCount = 0;
        this._writing = false;
    }

    public CursorBlockManager getCursorBlockManager() {
        return this._cursorBlockManager;
    }

    public abstract CursorBlock getCursorBlock(CursorTreeManager var1, Set var2);

    public abstract CursorBlock getAnyCursorBlock(CursorTreeManager var1);

    public abstract void die();

    protected synchronized void _startRead() {
        while (this._writing) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ++this._readCount;
    }

    protected synchronized void _endRead() {
        --this._readCount;
        if (this._readCount == 0) {
            this.notifyAll();
        }
    }

    protected synchronized void _startWrite() {
        while (this._readCount > 0 && this._writing) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this._writing = true;
    }

    protected synchronized void _endWrite() {
        this._writing = false;
        this.notifyAll();
    }
}

