/*
 * Decompiled with CFR 0.152.
 */
package oracle.express.idl.util;

import java.io.IOException;
import java.io.StringWriter;
import oracle.express.idl.util.OlapiTracer;

class SegmentedStringWriter {
    private boolean _xmlhint;
    private StringWriter _writer;
    private StringBuffer[] _buffers;

    private void newSegment() {
        this._writer = this._xmlhint ? new StringWriter(10922) : new StringWriter();
    }

    SegmentedStringWriter(boolean bl) {
        OlapiTracer.enter("SegmentedStringWriter.constructor");
        OlapiTracer.log("xmlhint = " + bl);
        this._xmlhint = bl;
        this.newSegment();
        this._buffers = new StringBuffer[1];
        this._buffers[0] = this._writer.getBuffer();
        OlapiTracer.leave("SegmentedStringWriter.constructor");
    }

    public void write(int n) {
        OlapiTracer.enter("SegmentedStringWriter.write");
        if (OlapiTracer.isTracingEnabled()) {
            OlapiTracer.log("writing at: <" + (this._buffers.length - 1) + ", " + this._writer.getBuffer().length() + ">");
        }
        this._writer.write(n);
        if (10922 <= this._writer.getBuffer().length()) {
            OlapiTracer.log("add new segment");
            StringBuffer[] stringBufferArray = new StringBuffer[this._buffers.length + 1];
            System.arraycopy(this._buffers, 0, stringBufferArray, 0, this._buffers.length);
            this.newSegment();
            stringBufferArray[this._buffers.length] = this._writer.getBuffer();
            this._buffers = stringBufferArray;
        }
        OlapiTracer.leave("SegmentedStringWriter.write");
    }

    public void write(char[] cArray, int n, int n2) {
        OlapiTracer.enter("SegmentedStringWriter.write");
        int n3 = Math.min(n2, 10922 - this._writer.getBuffer().length());
        if (OlapiTracer.isTracingEnabled()) {
            OlapiTracer.log("writing from <" + (this._buffers.length - 1) + ", " + this._writer.getBuffer().length() + "> to <" + (this._buffers.length - 1) + ", " + (this._writer.getBuffer().length() + n3 - 1) + ">");
        }
        this._writer.write(cArray, n, n3);
        int n4 = n + n3;
        n3 = n2 - n3;
        if (10922 <= this._writer.getBuffer().length() || 0 != n3) {
            int n5 = n3 / 10922 + 1;
            OlapiTracer.log("add " + n5 + " new segments");
            StringBuffer[] stringBufferArray = new StringBuffer[this._buffers.length + n5];
            System.arraycopy(this._buffers, 0, stringBufferArray, 0, this._buffers.length);
            for (int i = 0; i < n5; ++i) {
                int n6 = Math.min(10922, n3);
                if (10922 <= n6) {
                    StringBuffer stringBuffer = new StringBuffer(n6);
                    stringBuffer.append(cArray, n4, n6);
                    stringBufferArray[this._buffers.length + i] = stringBuffer;
                } else {
                    this.newSegment();
                    this._writer.write(cArray, n4, n6);
                    stringBufferArray[this._buffers.length + i] = this._writer.getBuffer();
                }
                if (OlapiTracer.isTracingEnabled()) {
                    OlapiTracer.log("writing from <" + (this._buffers.length + i) + ", 0> to <" + (this._buffers.length + i) + ", " + (n6 - 1) + ">");
                }
                n4 += n6;
                n3 -= n6;
            }
            this._buffers = stringBufferArray;
        }
        OlapiTracer.leave("SegmentedStringWriter.write");
    }

    public void write(String string) {
        OlapiTracer.enter("SegmentedStringWriter.write");
        for (int i = 0; i < string.length(); ++i) {
            this.write(string.charAt(i));
        }
        OlapiTracer.leave("SegmentedStringWriter.write");
    }

    public void write(String string, int n, int n2) {
        OlapiTracer.enter("SegmentedStringWriter.write");
        for (int i = n; i < n + n2; ++i) {
            this.write(string.charAt(i));
        }
        OlapiTracer.leave("SegmentedStringWriter.write");
    }

    public void append(StringBuffer[] stringBufferArray) {
        OlapiTracer.enter("SegmentedStringWriter.append");
        StringBuffer[] stringBufferArray2 = new StringBuffer[this._buffers.length + stringBufferArray.length + (0 != this._writer.getBuffer().length() ? 1 : 0)];
        int n = this._buffers.length - (0 != this._writer.getBuffer().length() ? 0 : 1);
        System.arraycopy(this._buffers, 0, stringBufferArray2, 0, n);
        System.arraycopy(stringBufferArray, 0, stringBufferArray2, n, stringBufferArray.length);
        this.newSegment();
        stringBufferArray2[this._buffers.length + stringBufferArray.length - (0 != this._writer.getBuffer().length() ? 0 : 1)] = this._writer.getBuffer();
        this._buffers = stringBufferArray2;
        OlapiTracer.log("append " + stringBufferArray.length + " segments");
        OlapiTracer.leave("SegmentedStringWriter.append");
    }

    public void flush() {
    }

    public void close() throws IOException {
    }

    public StringBuffer[] getBuffers() {
        return this._buffers;
    }
}

