/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.temptablespacegroups;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.LabelActionControl;
import oracle.dbtools.raptor.ui.controls.StringShuttleControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class CreateTempTablespaceAction
extends ActionDialog {
    String def_sql = "select property_value from database_properties where property_name = 'DEFAULT_TEMP_TABLESPACE'";
    String all_sql = "select distinct(tablespace_name) from dba_temp_files order by 1";
    String src_sql = "select distinct(tablespace_name) ts_name from dba_temp_files where tablespace_name not in (select tablespace_name from DBA_TABLESPACE_GROUPS where group_name = :OBJECT_NAME)";
    String sel_sql = "select distinct(tablespace_name) ts_name from dba_temp_files where tablespace_name in (select tablespace_name from DBA_TABLESPACE_GROUPS where group_name = :OBJECT_NAME) ";

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDefault() {
        boolean bl = false;
        Connection connection = this.getDBObject().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string = dBUtil.executeReturnOneCol(this.def_sql);
                bl = string.equals(this.getObjectName());
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> getList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Connection connection = this.getDBObject().getConnection();
        ResultSet resultSet = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (Connections.getInstance().lock(connection)) {
            block6: {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    hashMap.put("OBJECT_NAME", this.getDBObject().getObjectName());
                    resultSet = dBUtil.executeOracleQuery(string, hashMap);
                    if (resultSet == null) break block6;
                    while (resultSet.next()) {
                        arrayList.add(resultSet.getString(1));
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                    Connections.getInstance().unlock(connection);
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> getAllSource() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Connection connection = this.getDBObject().getConnection();
        ResultSet resultSet = null;
        HashMap hashMap = new HashMap();
        if (Connections.getInstance().lock(connection)) {
            block6: {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    resultSet = dBUtil.executeOracleQuery(this.all_sql, hashMap);
                    if (resultSet == null) break block6;
                    while (resultSet.next()) {
                        arrayList.add(resultSet.getString(1));
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    }
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                    Connections.getInstance().unlock(connection);
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
        return arrayList;
    }

    protected List<ActionControl> createControls(Connection connection) {
        ArrayList<Object> arrayList = new ArrayList();
        ArrayList<Object> arrayList2 = new ArrayList();
        String string = this.getObjectName();
        Operation operation = this.getOperation();
        if (operation == Operation.CREATE) {
            arrayList = this.getAllSource();
        } else if (operation == Operation.EDIT) {
            arrayList = this.getList(this.src_sql);
            arrayList2 = this.getList(this.sel_sql);
        }
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl("name", DbaNavigatorResources.getString("NAME_LABEL"), string);
        BooleanCheckBoxActionControl booleanCheckBoxActionControl = new BooleanCheckBoxActionControl("default", DbaNavigatorResources.getString("DEF_LABEL"), this.isDefault());
        LabelActionControl labelActionControl = new LabelActionControl("table_label", DbaNavigatorResources.getString("SHUTTLE_LABEL"));
        StringShuttleControl stringShuttleControl = new StringShuttleControl("shuttle", null, arrayList, arrayList2);
        if (operation == Operation.EDIT) {
            textBoxActionControl.setEditable(false);
            booleanCheckBoxActionControl.setEditable(!this.isDefault());
        }
        ArrayList<ActionControl> arrayList3 = new ArrayList<ActionControl>();
        arrayList3.add((ActionControl)textBoxActionControl);
        arrayList3.add((ActionControl)booleanCheckBoxActionControl);
        arrayList3.add((ActionControl)labelActionControl);
        arrayList3.add((ActionControl)stringShuttleControl);
        return arrayList3;
    }

    protected String getScript(ActionDialog.Values values) {
        boolean bl = this.isDefault();
        StringBuilder stringBuilder = new StringBuilder();
        String string = values.get("name");
        String string2 = values.get("default");
        List list = values.getList("shuttle", "added");
        List list2 = values.getList("shuttle", "removed");
        for (String string3 : list) {
            stringBuilder.append("ALTER TABLESPACE " + string3 + " TABLESPACE GROUP " + string + ";\n");
        }
        for (String string3 : list2) {
            stringBuilder.append("ALTER TABLESPACE " + string3 + " TABLESPACE GROUP ''; \n");
        }
        if (!bl && string2.equals("true")) {
            stringBuilder.append("ALTER DATABASE DEFAULT TEMPORARY TABLESPACE " + string + ";\n");
        }
        return stringBuilder.toString();
    }

    protected String getTitle() {
        String string = new String();
        Operation operation = this.getOperation();
        if (operation == Operation.CREATE) {
            string = DbaNavigatorResources.getString("CREATE_TEMP_TITLE");
        } else if (operation == Operation.EDIT) {
            string = DbaNavigatorResources.getString("EDIT_TEMP_TITLE");
        }
        return string;
    }

    private static enum Operation {
        CREATE,
        EDIT;

    }
}

