/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.services;

import java.beans.PropertyChangeEvent;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.SpinnerActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class CreateEditAction
extends ActionDialog {
    private static final String SERVICE_NAME = "ServiceName";
    private static final String NETWORK_NAME = "NetworkName";
    private static final String GOAL = "Goal";
    private static final String DTP = "Dtp";
    private static final String NOTIFICATIONS = "Notification";
    private static final String FAILOVER_SPECIFIED = "FailoverSpecified";
    private static final String FAILOVER_METHOD = "FailoverMethod";
    private static final String FAILOVER_TYPE = "FailoverType";
    private static final String FAILOVER_RETRIES = "FailoverRetries";
    private static final String FAILOVER_DELAY = "FailoverDeplay";
    private static final HashMap<String, String> keywordCodeMap = new HashMap();

    protected String getTitle() {
        Operation operation = this.getOperation();
        String string = operation == Operation.EDIT ? DbaNavigatorResources.getString("EDIT_SERVICE_TITLE") : DbaNavigatorResources.getString("CREATE_SERVICE_TITLE");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionControl> createControls(Connection connection) {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        DBUtil dBUtil;
        TextBoxActionControl textBoxActionControl;
        Object object;
        Operation operation = this.getOperation();
        String string6 = operation == Operation.EDIT ? this.getObjectName() : DbaNavigatorResources.getString("ENTER_VALUE_PROMPT");
        String string7 = DbaNavigatorResources.getString("ENTER_VALUE_PROMPT");
        Keyword keyword = null;
        Keyword keyword2 = null;
        Keyword keyword3 = null;
        Keyword keyword4 = null;
        Keyword keyword5 = null;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        if (operation != Operation.CREATE_NEW && Connections.getInstance().lock(connection)) {
            object = null;
            try {
                textBoxActionControl = new HashMap();
                textBoxActionControl.put("NAME", this.getObjectName());
                dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                object = dBUtil.executeOracleQuery(this.getQuery(connection, "getService"), (Map)textBoxActionControl);
                if (object != null) {
                    while (object.next()) {
                        string7 = object.getString("NETWORK_NAME");
                        string5 = object.getString("GOAL");
                        string4 = object.getString("DTP");
                        string3 = object.getString("NOTIFICATIONS");
                        string2 = object.getString("FAILOVER_METHOD");
                        string = object.getString("FAILOVER_TYPE");
                        bigDecimal2 = object.getBigDecimal("FAILOVER_RETRIES");
                        bigDecimal = object.getBigDecimal("FAILOVER_DELAY");
                        if (string5 != null) {
                            keyword = Keyword.valueOf("GOAL_" + string5);
                        }
                        if (string4 != null) {
                            Keyword keyword6 = keyword2 = string4.equals("Y") ? Keyword.DTP_TRUE : Keyword.DTP_FALSE;
                        }
                        if (string3 != null) {
                            Keyword keyword7 = keyword3 = string3.equals("YES") ? Keyword.NOTIFICATIONS_TRUE : Keyword.NOTIFICATIONS_FALSE;
                        }
                        if (string2 != null) {
                            keyword4 = Keyword.valueOf("FAILOVER_METHOD_" + string2);
                        }
                        if (string != null) {
                            keyword5 = Keyword.valueOf("FAILOVER_TYPE_" + string);
                        }
                        if (!(bl = keyword4 != null || keyword5 != null || bigDecimal2 != null || bigDecimal != null)) continue;
                        if (bigDecimal2 != null) {
                            n = bigDecimal2.intValue();
                        }
                        if (bigDecimal == null) continue;
                        n2 = bigDecimal.intValue();
                    }
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                DBUtil.closeResultSet((ResultSet)object);
                Connections.getInstance().unlock(connection);
            }
        }
        object = new TextBoxActionControl(SERVICE_NAME, DbaNavigatorResources.getString("SERVICE_NAME_LABEL"), string6);
        textBoxActionControl = new TextBoxActionControl(NETWORK_NAME, DbaNavigatorResources.getString("NETWORK_NAME_LABEL"), string7);
        dBUtil = new ComboBoxActionControl(GOAL, DbaNavigatorResources.getString("GOAL_LABEL"), new String[]{"", Keyword.GOAL_SERVICE_TIME.getLabel(), Keyword.GOAL_THROUGHPUT.getLabel(), Keyword.GOAL_NONE.getLabel()}, keyword != null ? keyword.getLabel() : "");
        string5 = new ComboBoxActionControl(DTP, DbaNavigatorResources.getString("DTP_LABEL"), new String[]{"", Keyword.DTP_TRUE.getLabel(), Keyword.DTP_FALSE.getLabel()}, keyword2 != null ? keyword2.getLabel() : "");
        string4 = new ComboBoxActionControl(NOTIFICATIONS, DbaNavigatorResources.getString("NOTIFICATIONS_LABEL"), new String[]{"", Keyword.NOTIFICATIONS_TRUE.getLabel(), Keyword.NOTIFICATIONS_FALSE.getLabel()}, keyword3 != null ? keyword3.getLabel() : "");
        string3 = new BooleanCheckBoxActionControl(FAILOVER_SPECIFIED, DbaNavigatorResources.getString("FAILOVER_SPECIFIED_LABEL"), bl);
        string2 = new ComboBoxActionControl(FAILOVER_METHOD, DbaNavigatorResources.getString("FAILOVER_METHOD_LABEL"), new String[]{"", Keyword.FAILOVER_METHOD_NONE.getLabel(), Keyword.FAILOVER_METHOD_BASIC.getLabel()}, keyword4 != null ? keyword4.getLabel() : "");
        string = new ComboBoxActionControl(FAILOVER_TYPE, DbaNavigatorResources.getString("FAILOVER_TYPE_LABEL"), new String[]{"", Keyword.FAILOVER_TYPE_NONE.getLabel(), Keyword.FAILOVER_TYPE_SESSION.getLabel(), Keyword.FAILOVER_TYPE_SELECT.getLabel(), Keyword.FAILOVER_TYPE_TRANSACTION.getLabel()}, keyword5 != null ? keyword5.getLabel() : "");
        bigDecimal2 = new SpinnerActionControl(FAILOVER_RETRIES, DbaNavigatorResources.getString("FAILOVER_RETRIES_LABEL"), Integer.valueOf(n), Integer.valueOf(0), Integer.valueOf(100), Integer.valueOf(1));
        bigDecimal = new SpinnerActionControl(FAILOVER_DELAY, DbaNavigatorResources.getString("FAILOVER_DELAY_LABEL"), Integer.valueOf(n2), Integer.valueOf(0), Integer.valueOf(100), Integer.valueOf(1));
        if (operation == Operation.EDIT) {
            object.setEditable(false);
            textBoxActionControl.setEditable(false);
        }
        this.setFailoverEnablement((ActionControl)string3, new ActionControl[]{string2, string, bigDecimal2, bigDecimal});
        string3.addPropertyChangeListener(arg_0 -> this.lambda$createControls$0((ActionControl)string3, (ActionControl)string2, (ActionControl)string, (ActionControl)bigDecimal2, (ActionControl)bigDecimal, arg_0));
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)object);
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)dBUtil);
        arrayList.add((ActionControl)string5);
        arrayList.add((ActionControl)string4);
        arrayList.add((ActionControl)string3);
        arrayList.add((ActionControl)string2);
        arrayList.add((ActionControl)string);
        arrayList.add((ActionControl)bigDecimal2);
        arrayList.add((ActionControl)bigDecimal);
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        String string = values.get(SERVICE_NAME);
        String string2 = values.get(NETWORK_NAME);
        String string3 = values.get(GOAL);
        String string4 = values.get(DTP);
        String string5 = values.get(NOTIFICATIONS);
        String string6 = values.get(FAILOVER_METHOD);
        String string7 = values.get(FAILOVER_TYPE);
        String string8 = values.get(FAILOVER_RETRIES);
        String string9 = values.get(FAILOVER_DELAY);
        boolean bl = Boolean.parseBoolean(values.get(FAILOVER_SPECIFIED));
        boolean bl2 = !string3.isEmpty() || !string4.isEmpty() || !string5.isEmpty() || bl && (!string6.isEmpty() || !string7.isEmpty() || !string8.isEmpty() || !string9.isEmpty());
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2) {
            stringBuilder.append("DECLARE\n");
            stringBuilder.append("    params dbms_service.svc_parameter_array;\n");
        }
        stringBuilder.append("BEGIN\n");
        if (bl2) {
            if (!string3.isEmpty()) {
                stringBuilder.append("    params('goal') := ").append(Keyword.getCode(string3)).append(";\n");
            }
            if (!string4.isEmpty()) {
                stringBuilder.append("    params('dtp') := ").append(Keyword.getCode(string4)).append(";\n");
            }
            if (!string5.isEmpty()) {
                stringBuilder.append("    params('aq_ha_notifications') := ").append(Keyword.getCode(string5)).append(";\n");
            }
            if (bl) {
                if (!string6.isEmpty()) {
                    stringBuilder.append("    params('failover_method') := ").append(Keyword.getCode(string6)).append(";\n");
                }
                if (!string7.isEmpty()) {
                    stringBuilder.append("    params('failover_type') := ").append(Keyword.getCode(string7)).append(";\n");
                }
                if (!string8.isEmpty()) {
                    stringBuilder.append("    params('failover_retries') := ").append(string8).append(";\n");
                }
                if (!string9.isEmpty()) {
                    stringBuilder.append("    params('failover_delay') := ").append(string9).append(";\n");
                }
            }
            if (this.getOperation() != Operation.EDIT) {
                stringBuilder.append("    DBMS_SERVICE.CREATE_SERVICE('").append(string).append("', '").append(string2).append("', params);\n");
            } else {
                stringBuilder.append("    DBMS_SERVICE.MODIFY_SERVICE('").append(string).append("', params);\n");
            }
        } else if (this.getOperation() != Operation.EDIT) {
            stringBuilder.append("    DBMS_SERVICE.CREATE_SERVICE('").append(string).append("', '").append(string2).append("');\n");
        } else {
            stringBuilder.append("    DBMS_SERVICE.MODIFY_SERVICE('").append(string).append("');\n");
        }
        stringBuilder.append("END;\n");
        return stringBuilder.toString();
    }

    private Operation getOperation() {
        return Operation.valueOf(this.getArgs());
    }

    private void setFailoverEnablement(ActionControl actionControl, ActionControl ... actionControlArray) {
        boolean bl = Boolean.parseBoolean(actionControl.getValue().get());
        for (ActionControl actionControl2 : actionControlArray) {
            actionControl2.enableUI(bl);
        }
    }

    private /* synthetic */ void lambda$createControls$0(ActionControl actionControl, ActionControl actionControl2, ActionControl actionControl3, ActionControl actionControl4, ActionControl actionControl5, PropertyChangeEvent propertyChangeEvent) {
        this.setFailoverEnablement(actionControl, actionControl2, actionControl3, actionControl4, actionControl5);
    }

    private static enum Operation {
        CREATE_NEW,
        CREATE_LIKE,
        EDIT;

    }

    private static enum Keyword {
        DTP_TRUE(DbaNavigatorResources.getString("BOOLEAN_TRUE"), "'true'"),
        DTP_FALSE(DbaNavigatorResources.getString("BOOLEAN_FALSE"), "'false'"),
        NOTIFICATIONS_TRUE(DbaNavigatorResources.getString("BOOLEAN_TRUE"), "'true'"),
        NOTIFICATIONS_FALSE(DbaNavigatorResources.getString("BOOLEAN_FALSE"), "'false'"),
        GOAL_NONE(DbaNavigatorResources.getString("GOAL_NONE"), "DBMS_SERVICE.GOAL_NONE"),
        GOAL_SERVICE_TIME(DbaNavigatorResources.getString("GOAL_SERVICE_TIME"), "DBMS_SERVICE.GOAL_SERVICE_TIME"),
        GOAL_THROUGHPUT(DbaNavigatorResources.getString("GOAL_THROUGHPUT"), "DBMS_SERVICE.GOAL_THROUGHPUT"),
        FAILOVER_METHOD_NONE(DbaNavigatorResources.getString("FAILOVER_METHOD_NONE"), "DBMS_SERVICE.FAILOVER_METHOD_NONE"),
        FAILOVER_METHOD_BASIC(DbaNavigatorResources.getString("FAILOVER_METHOD_BASIC"), "DBMS_SERVICE.FAILOVER_METHOD_BASIC"),
        FAILOVER_TYPE_NONE(DbaNavigatorResources.getString("FAILOVER_TYPE_NONE"), "DBMS_SERVICE.FAILOVER_TYPE_NONE"),
        FAILOVER_TYPE_SESSION(DbaNavigatorResources.getString("FAILOVER_TYPE_SESSION"), "DBMS_SERVICE.FAILOVER_TYPE_SESSION"),
        FAILOVER_TYPE_SELECT(DbaNavigatorResources.getString("FAILOVER_TYPE_SELECT"), "DBMS_SERVICE.FAILOVER_TYPE_SELECT"),
        FAILOVER_TYPE_TRANSACTION(DbaNavigatorResources.getString("FAILOVER_TYPE_TRANSACTION"), "DBMS_SERVICE.FAILOVER_TYPE_TRANSACTION");

        private final String label;

        private Keyword(String string2, String string3) {
            this.label = string2;
            keywordCodeMap.put(string2, string3);
        }

        String getLabel() {
            return this.label;
        }

        static String getCode(String string) {
            return keywordCodeMap.get(string);
        }
    }
}

