/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.restorepoints;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.datatypes.objects.OraDATE;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.util.DbaUtil;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TemporalActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class CreateAction
extends ActionDialog {
    private static final String RESTORE_POINT_NAME = "RestorePointName";
    private static final String RESTORE_POINT_TYPE = "RestorePointType";
    private static final String WHEN = "When";
    private static final String SPECIFIED_TIME = "Time";
    private static final String SCN = "SCN";
    private static final String PRESERVE = "Preserve";
    private boolean is11gOrLater = false;

    protected String getTitle() {
        return DbaNavigatorResources.getString("CREATE_RESTORE_POINT_TITLE");
    }

    protected List<ActionControl> createControls(Connection connection) {
        if (DbaUtil.isPDB(connection)) {
            try {
                if (connection.getMetaData().getDatabaseMinorVersion() == 1) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbaNavigatorResources.getString("NOT_SUPPORTED_FOR_PDB"), (String)DbaNavigatorResources.getString("ERROR_TITLE"), null);
                    throw new RuntimeException("not supported for 12.1 pluggable database");
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
        try {
            this.is11gOrLater = connection.getMetaData().getDatabaseMajorVersion() >= 11;
        }
        catch (SQLException sQLException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(RESTORE_POINT_NAME, DbaNavigatorResources.getString("RESTORE_POINT_NAME_LABEL"), DbaNavigatorResources.getString("ENTER_VALUE_PROMPT"));
        ComboBoxActionControl comboBoxActionControl = new ComboBoxActionControl(RESTORE_POINT_TYPE, DbaNavigatorResources.getString("RESTORE_POINT_TYPE_LABEL"), new String[]{DbaNavigatorResources.getString("RP_NORMAL"), DbaNavigatorResources.getString("RP_GUARANTEED")}, DbaNavigatorResources.getString("RP_NORMAL"));
        BooleanCheckBoxActionControl booleanCheckBoxActionControl = this.is11gOrLater ? new BooleanCheckBoxActionControl(PRESERVE, DbaNavigatorResources.getString("PRESERVE_LABEL"), false) : null;
        ComboBoxActionControl comboBoxActionControl2 = this.is11gOrLater ? new ComboBoxActionControl(WHEN, DbaNavigatorResources.getString("WHEN_LABEL"), new String[]{DbaNavigatorResources.getString("RP_WHEN_CURRENT_TIME"), DbaNavigatorResources.getString("RP_WHEN_SPECIFIED_TIME"), DbaNavigatorResources.getString("RP_WHEN_SCN")}, DbaNavigatorResources.getString("RP_WHEN_CURRENT_TIME")) : null;
        OraDATE oraDATE = OraDATE.getLocalInstance();
        oraDATE.setTime(oraDATE.toZonedDateTime().minusDays(7L).toInstant());
        oraDATE.setPrecision(OraTemporalDatum.Precision.MINUTE);
        TemporalActionControl temporalActionControl = this.is11gOrLater ? new TemporalActionControl(SPECIFIED_TIME, DbaNavigatorResources.getString("SPECIFIED_TIME_LABEL"), (OraTemporalDatum)oraDATE, (Format)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")) : null;
        TextBoxActionControl textBoxActionControl2 = this.is11gOrLater ? new TextBoxActionControl(SCN, DbaNavigatorResources.getString("SCN_LABEL"), "", TextBoxActionControl.getIntegerFormat()) : null;
        this.updateUIState((ActionControl)comboBoxActionControl, (ActionControl)comboBoxActionControl2, (ActionControl)temporalActionControl, (ActionControl)textBoxActionControl2, (ActionControl)booleanCheckBoxActionControl);
        comboBoxActionControl.addPropertyChangeListener(new PropertyChangeListener(){
            final /* synthetic */ ActionControl val$restorePointTypeCtl;
            final /* synthetic */ ActionControl val$whenCtl;
            final /* synthetic */ ActionControl val$specifiedTimeCtl;
            final /* synthetic */ ActionControl val$scnCtl;
            final /* synthetic */ ActionControl val$preserveCtl;
            {
                this.val$restorePointTypeCtl = actionControl;
                this.val$whenCtl = actionControl2;
                this.val$specifiedTimeCtl = actionControl3;
                this.val$scnCtl = actionControl4;
                this.val$preserveCtl = actionControl5;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                CreateAction.this.updateUIState(this.val$restorePointTypeCtl, this.val$whenCtl, this.val$specifiedTimeCtl, this.val$scnCtl, this.val$preserveCtl);
            }
        });
        if (comboBoxActionControl2 != null) {
            comboBoxActionControl2.addPropertyChangeListener(new PropertyChangeListener(){
                final /* synthetic */ ActionControl val$restorePointTypeCtl;
                final /* synthetic */ ActionControl val$whenCtl;
                final /* synthetic */ ActionControl val$specifiedTimeCtl;
                final /* synthetic */ ActionControl val$scnCtl;
                final /* synthetic */ ActionControl val$preserveCtl;
                {
                    this.val$restorePointTypeCtl = actionControl;
                    this.val$whenCtl = actionControl2;
                    this.val$specifiedTimeCtl = actionControl3;
                    this.val$scnCtl = actionControl4;
                    this.val$preserveCtl = actionControl5;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    CreateAction.this.updateUIState(this.val$restorePointTypeCtl, this.val$whenCtl, this.val$specifiedTimeCtl, this.val$scnCtl, this.val$preserveCtl);
                }
            });
        }
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl);
        arrayList.add((ActionControl)comboBoxActionControl);
        if (booleanCheckBoxActionControl != null) {
            arrayList.add((ActionControl)booleanCheckBoxActionControl);
        }
        if (comboBoxActionControl2 != null) {
            arrayList.add((ActionControl)comboBoxActionControl2);
            arrayList.add((ActionControl)temporalActionControl);
            arrayList.add((ActionControl)textBoxActionControl2);
        }
        return arrayList;
    }

    private void updateUIState(ActionControl actionControl, ActionControl actionControl2, ActionControl actionControl3, ActionControl actionControl4, ActionControl actionControl5) {
        String string = actionControl.getValue().get();
        if (actionControl2 != null) {
            String string2 = actionControl2.getValue().get();
            actionControl2.setEditable(true);
            if (string2.equals(DbaNavigatorResources.getString("RP_WHEN_CURRENT_TIME"))) {
                actionControl3.enableUI(false);
                actionControl4.enableUI(false);
            } else if (string2.equals(DbaNavigatorResources.getString("RP_WHEN_SPECIFIED_TIME"))) {
                actionControl3.enableUI(true);
                actionControl4.enableUI(false);
            } else if (string2.equals(DbaNavigatorResources.getString("RP_WHEN_SCN"))) {
                actionControl3.enableUI(false);
                actionControl4.enableUI(true);
            }
        }
        if (actionControl5 != null) {
            if (string.equals(DbaNavigatorResources.getString("RP_NORMAL"))) {
                actionControl5.enableUI(true);
            } else {
                actionControl5.enableUI(false);
            }
        }
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE RESTORE POINT \"");
        stringBuffer.append(values.get(RESTORE_POINT_NAME));
        stringBuffer.append("\" ");
        if (this.is11gOrLater) {
            if (values.get(WHEN).equals(DbaNavigatorResources.getString("RP_WHEN_SPECIFIED_TIME"))) {
                stringBuffer.append("AS OF TIMESTAMP TO_TIMESTAMP('");
                stringBuffer.append(values.get(SPECIFIED_TIME));
                stringBuffer.append("', 'YYYY-MM-DD HH24:MI:SS')");
            } else if (values.get(WHEN).equals(DbaNavigatorResources.getString("RP_WHEN_SCN"))) {
                stringBuffer.append("AS OF SCN ");
                stringBuffer.append(values.get(SCN));
                stringBuffer.append(" ");
            }
        }
        if (values.get(RESTORE_POINT_TYPE).equals(DbaNavigatorResources.getString("RP_GUARANTEED"))) {
            stringBuffer.append("GUARANTEE FLASHBACK DATABASE");
        } else if (this.is11gOrLater && Boolean.parseBoolean(values.get(PRESERVE))) {
            stringBuffer.append("PRESERVE");
        }
        return stringBuffer.toString();
    }
}

