/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.performance;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.Utils;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.SpinnerActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;
import oracle.dbtools.raptor.utils.Connections;

public class EditBaselineAction
extends ActionDialog {
    private static final String BASELINE_NAME = "BaselineName";
    private static final String WINDOW_SIZE = "WindowSize";
    private boolean movingWindow;
    private int movingWindowSize;

    protected String getTitle() {
        return DbaNavigatorResources.getString("EDIT_BASELINE_TITLE");
    }

    protected String getObjectName() {
        return super.getObjectName().split("/")[0];
    }

    protected String getDbId() {
        return super.getObjectName().split("/")[1];
    }

    protected List<ActionControl> createControls(Connection connection) {
        this.loadMovingWindowInfo(connection);
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(BASELINE_NAME, DbaNavigatorResources.getString("BASELINE_NAME_LABEL"), this.getObjectName());
        SpinnerActionControl spinnerActionControl = null;
        if (this.movingWindow) {
            textBoxActionControl.setEditable(false);
            spinnerActionControl = new SpinnerActionControl(WINDOW_SIZE, DbaNavigatorResources.getString("WINDOW_SIZE_LABEL"), Integer.valueOf(this.movingWindowSize), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE), Integer.valueOf(1));
        }
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)textBoxActionControl);
        if (spinnerActionControl != null) {
            arrayList.add((ActionControl)spinnerActionControl);
        }
        return arrayList;
    }

    protected String getScript(ActionDialog.Values values) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.movingWindow) {
            int n = Integer.parseInt(values.get(WINDOW_SIZE));
            if (n != this.movingWindowSize) {
                stringBuilder.append("BEGIN\n");
                stringBuilder.append("   DBMS_WORKLOAD_REPOSITORY.MODIFY_BASELINE_WINDOW_SIZE(WINDOW_SIZE => '");
                stringBuilder.append(n);
                stringBuilder.append("');\n");
                stringBuilder.append("END;\n");
            }
        } else {
            String string = values.get(BASELINE_NAME);
            if (!string.equals(this.getObjectName())) {
                stringBuilder.append("BEGIN\n");
                stringBuilder.append("   DBMS_WORKLOAD_REPOSITORY.RENAME_BASELINE(OLD_BASELINE_NAME => '");
                stringBuilder.append(this.getObjectName());
                stringBuilder.append("', NEW_BASELINE_NAME => '");
                stringBuilder.append(string);
                stringBuilder.append("');\n");
                stringBuilder.append("END;\n");
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMovingWindowInfo(Connection connection) {
        block8: {
            if (Connections.getInstance().lock(connection)) {
                ResultSet resultSet = null;
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("NAME", this.getObjectName());
                    resultSet = dBUtil.executeOracleQuery(Utils.getQuery(((Object)((Object)this)).getClass(), (Connection)connection, (String)"getBaselineInfo"), hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            this.movingWindow = resultSet.getString(1).equals("MOVING_WINDOW");
                            this.movingWindowSize = resultSet.getInt(2);
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block8;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }
}

