/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backuptabs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;

public class OverridePoliciesTab
extends ActionDialogTab {
    public static final String BACKUP_UNCHANGED_FILES = "BACKUP_UNCHANGED_FILES";
    public static final String OVERRIDE_TABLESPACE_EXCLUSIONS = "OVERRIDE_TABLESPACE_EXCLUSIONS";
    public static final String OVERRIDE_RETENTION_POLICY = "OVERRIDE_RETENTION_POLICY";
    public static final String RETENTION_TIME = "RETENTION_TIME";
    private static final String DO_NOT_OVERRIDE = DbaNavigatorResources.getString("DO_NOT_OVERRIDE");
    private static final String KEEP_FOR_PERIOD = DbaNavigatorResources.getString("KEEP_FOR_PERIOD");
    private boolean _includeWholeDatabasePolicies;

    public OverridePoliciesTab(String string, boolean bl) {
        super(string, DbaNavigatorResources.getString("OVERRIDE_POLICIES_TAB"));
        this._includeWholeDatabasePolicies = bl;
    }

    public List<ActionControl> createControls(Connection connection) {
        BooleanCheckBoxActionControl booleanCheckBoxActionControl = this._includeWholeDatabasePolicies ? new BooleanCheckBoxActionControl(BACKUP_UNCHANGED_FILES, DbaNavigatorResources.getString("BACKUP_UNCHANGED_FILES_LABEL"), false) : null;
        BooleanCheckBoxActionControl booleanCheckBoxActionControl2 = this._includeWholeDatabasePolicies ? new BooleanCheckBoxActionControl(OVERRIDE_TABLESPACE_EXCLUSIONS, DbaNavigatorResources.getString("OVERRIDE_TABLESPACE_EXCLUSIONS_LABEL"), false) : null;
        ComboBoxActionControl comboBoxActionControl = new ComboBoxActionControl(OVERRIDE_RETENTION_POLICY, DbaNavigatorResources.getString("OVERRIDE_RETENTION_POLICY_LABEL"), new String[]{DO_NOT_OVERRIDE, KEEP_FOR_PERIOD}, DO_NOT_OVERRIDE);
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(RETENTION_TIME, DbaNavigatorResources.getString("RETENTION_TIME_LABEL"), "31", TextBoxActionControl.getIntegerFormat());
        textBoxActionControl.enableUI(false);
        comboBoxActionControl.addPropertyChangeListener(new PropertyChangeListener(){
            final /* synthetic */ ActionControl val$overrideRetentionCtl;
            final /* synthetic */ ActionControl val$retentionTimeCtl;
            {
                this.val$overrideRetentionCtl = actionControl;
                this.val$retentionTimeCtl = actionControl2;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = this.val$overrideRetentionCtl.getValue().get().equals(KEEP_FOR_PERIOD);
                this.val$retentionTimeCtl.enableUI(bl);
            }
        });
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        if (booleanCheckBoxActionControl != null) {
            arrayList.add((ActionControl)booleanCheckBoxActionControl);
        }
        if (booleanCheckBoxActionControl2 != null) {
            arrayList.add((ActionControl)booleanCheckBoxActionControl2);
        }
        arrayList.add((ActionControl)comboBoxActionControl);
        arrayList.add((ActionControl)textBoxActionControl);
        return arrayList;
    }

    public static boolean isBackupUnchangedFiles(ActionDialog.Lookup lookup) {
        return Boolean.parseBoolean(lookup.get(BACKUP_UNCHANGED_FILES));
    }

    public static boolean isOverrideTablespaceExclusions(ActionDialog.Lookup lookup) {
        return Boolean.parseBoolean(lookup.get(OVERRIDE_TABLESPACE_EXCLUSIONS));
    }

    public static boolean isDoNotOverride(ActionDialog.Lookup lookup) {
        return lookup.get(OVERRIDE_RETENTION_POLICY).equals(DO_NOT_OVERRIDE);
    }

    public static boolean isKeepForPeriod(ActionDialog.Lookup lookup) {
        return lookup.get(OVERRIDE_RETENTION_POLICY).equals(KEEP_FOR_PERIOD);
    }

    public static int getRetentionTime(ActionDialog.Lookup lookup) {
        return Integer.parseInt(lookup.get(RETENTION_TIME));
    }
}

