/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator.actions.backuptabs;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.actions.backupjobs.DiskEncryptionActionGroup;
import oracle.dbtools.raptor.dba.navigator.actions.scriptprocessors.RMANScriptProcessorActionControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.actions.ActionDialogTab;
import oracle.dbtools.raptor.ui.controls.BooleanCheckBoxActionControl;
import oracle.dbtools.raptor.ui.controls.ComboBoxActionControl;
import oracle.dbtools.raptor.ui.controls.FileSizeActionControl;
import oracle.dbtools.raptor.ui.controls.GroupActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;

public class BackupOptionsTab
extends ActionDialogTab {
    public static final String DESTINATION_MEDIA = "DESTINATION_MEDIA";
    public static final String USE_DEFAULT_SETTINGS = "USE_DEFAULT_SETTINGS";
    public static final String BACKUP_TYPE = "BACKUP_TYPE";
    public static final String USE_FOR_INCREMENTAL = "USE_FOR_INCREMENTAL";
    public static final String REFRESH_DATAFILE_COPY = "REFRESH_DATAFILE_COPY";
    public static final String BACKUP_ARCHIVED_LOGS = "BACKUP_ARCHIVED_LOGS";
    public static final String DELETE_LOGS_AFTER_BACKUP = "DELETE_LOGS_AFTER_BACKUP";
    public static final String DELETE_OBSOLETE_BACKUPS = "DELETE_OBSOLETE_BACKUPS";
    public static final String USE_PROXY_COPY = "USE_PROXY_COPY";
    public static final String USE_DEFAULT_MAX_FILES = "USE_DEFAULT_MAX_FILES";
    public static final String MAX_FILES_PER_BACKUP_SET = "MAX_FILES_PER_BACKUP_SET";
    public static final String MAX_ALLOWABLE_CORRUPTIONS = "MAX_ALLOWABLE_CORRUPTIONS";
    public static final String MULTI_SECTION_BACKUP = "MULTI_SECTION_BACKUP";
    public static final String SECTION_SIZE = "SECTION_SIZE";
    private static final String FULL_BACKUP = DbaNavigatorResources.getString("FULL_BACKUP");
    private static final String INCREMENTAL_BACKUP = DbaNavigatorResources.getString("INCREMENTAL_BACKUP");
    private static final String DISK_MEDIA = DbaNavigatorResources.getString("DISK_MEDIA");
    private static final String TAPE_MEDIA = DbaNavigatorResources.getString("TAPE_MEDIA");
    public static final int GENERAL_CONTROL_GROUP = 1;
    public static final int MAX_FILES_CONTROL_GROUP = 2;
    public static final int USE_PROXY_CONTROL_GROUP = 4;
    public static final int CORRUPTIONS_CONTROL_GROUP = 8;
    private int _controlGroupsMask;
    private boolean _tapeOnly;
    private String[] _settingsTabs;
    private ActionDialog _owningDialog;
    private RMANScriptProcessorActionControl _scriptProcessorActionControl;

    public BackupOptionsTab(String string, int n, RMANScriptProcessorActionControl rMANScriptProcessorActionControl) {
        this(string, n, rMANScriptProcessorActionControl, false, null, null);
    }

    public BackupOptionsTab(String string, int n, RMANScriptProcessorActionControl rMANScriptProcessorActionControl, boolean bl) {
        this(string, n, rMANScriptProcessorActionControl, bl, null, null);
    }

    public BackupOptionsTab(String string, int n, RMANScriptProcessorActionControl rMANScriptProcessorActionControl, ActionDialog actionDialog, String[] stringArray) {
        this(string, n, rMANScriptProcessorActionControl, false, actionDialog, stringArray);
    }

    public BackupOptionsTab(String string, int n, RMANScriptProcessorActionControl rMANScriptProcessorActionControl, boolean bl, ActionDialog actionDialog, String[] stringArray) {
        super(string, DbaNavigatorResources.getString("OPTIONS_TAB"));
        this._controlGroupsMask = n;
        this._tapeOnly = bl;
        this._owningDialog = actionDialog;
        this._settingsTabs = stringArray;
        this._scriptProcessorActionControl = rMANScriptProcessorActionControl;
    }

    public List<ActionControl> createControls(Connection connection) {
        ComboBoxActionControl comboBoxActionControl = new ComboBoxActionControl(DESTINATION_MEDIA, DbaNavigatorResources.getString("DESTINATION_MEDIA_LABEL"), new String[]{DISK_MEDIA, TAPE_MEDIA}, this._tapeOnly ? TAPE_MEDIA : DISK_MEDIA);
        BooleanCheckBoxActionControl booleanCheckBoxActionControl = this._settingsTabs != null ? new BooleanCheckBoxActionControl(USE_DEFAULT_SETTINGS, DbaNavigatorResources.getString("USE_DEFAULT_SETTINGS_LABEL"), true) : null;
        ComboBoxActionControl comboBoxActionControl2 = this.useControl(1) ? new ComboBoxActionControl(BACKUP_TYPE, DbaNavigatorResources.getString("BACKUP_TYPE_LABEL"), new String[]{FULL_BACKUP, INCREMENTAL_BACKUP}, FULL_BACKUP) : null;
        BooleanCheckBoxActionControl booleanCheckBoxActionControl2 = this.useControl(1) ? new BooleanCheckBoxActionControl(USE_FOR_INCREMENTAL, DbaNavigatorResources.getString("USE_FOR_INCREMENTAL_LABEL"), false) : null;
        BooleanCheckBoxActionControl booleanCheckBoxActionControl3 = this.useControl(1) ? new BooleanCheckBoxActionControl(REFRESH_DATAFILE_COPY, DbaNavigatorResources.getString("REFRESH_DATAFILE_COPY_LABEL"), false) : null;
        BooleanCheckBoxActionControl booleanCheckBoxActionControl4 = this.useControl(1) ? new BooleanCheckBoxActionControl(BACKUP_ARCHIVED_LOGS, DbaNavigatorResources.getString("BACKUP_ARCHIVED_LOGS_LABEL"), true) : null;
        BooleanCheckBoxActionControl booleanCheckBoxActionControl5 = this.useControl(1) ? new BooleanCheckBoxActionControl(DELETE_LOGS_AFTER_BACKUP, DbaNavigatorResources.getString("DELETE_LOGS_AFTER_BACKUP_LABEL"), false) : null;
        BooleanCheckBoxActionControl booleanCheckBoxActionControl6 = this.useControl(1) ? new BooleanCheckBoxActionControl(DELETE_OBSOLETE_BACKUPS, DbaNavigatorResources.getString("DELETE_OBSOLETE_BACKUPS_LABEL"), false) : null;
        BooleanCheckBoxActionControl booleanCheckBoxActionControl7 = this.useControl(4) ? new BooleanCheckBoxActionControl(USE_PROXY_COPY, DbaNavigatorResources.getString("USE_PROXY_COPY_LABEL"), false) : null;
        BooleanCheckBoxActionControl booleanCheckBoxActionControl8 = this.useControl(2) ? new BooleanCheckBoxActionControl(USE_DEFAULT_MAX_FILES, DbaNavigatorResources.getString("USE_DEFAULT_MAX_FILES_LABEL"), true) : null;
        TextBoxActionControl textBoxActionControl = this.useControl(2) ? new TextBoxActionControl(MAX_FILES_PER_BACKUP_SET, DbaNavigatorResources.getString("MAX_FILES_PER_BACKUP_SET_LABEL"), "1", TextBoxActionControl.getIntegerFormat()) : null;
        TextBoxActionControl textBoxActionControl2 = this.useControl(8) ? new TextBoxActionControl(MAX_ALLOWABLE_CORRUPTIONS, DbaNavigatorResources.getString("MAX_ALLOWABLE_CORRUPTIONS_LABEL"), "0", TextBoxActionControl.getIntegerFormat()) : null;
        BooleanCheckBoxActionControl booleanCheckBoxActionControl9 = this.useControl(1) ? new BooleanCheckBoxActionControl(MULTI_SECTION_BACKUP, DbaNavigatorResources.getString("MULTI_SECTION_BACKUP_LABEL"), false) : null;
        FileSizeActionControl fileSizeActionControl = this.useControl(1) ? new FileSizeActionControl(SECTION_SIZE, DbaNavigatorResources.getString("SECTION_SIZE_LABEL"), 0xA00000L) : null;
        DiskEncryptionActionGroup diskEncryptionActionGroup = new DiskEncryptionActionGroup(connection, this._scriptProcessorActionControl);
        if (this._tapeOnly) {
            comboBoxActionControl.enableUI(false);
        }
        if (booleanCheckBoxActionControl != null) {
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ ActionControl val$destinationMediaCtl;
                {
                    this.val$destinationMediaCtl = actionControl;
                }

                @Override
                public void run() {
                    BackupOptionsTab.this.enableSettingsTabs(false, this.val$destinationMediaCtl.getValue().get());
                }
            });
            comboBoxActionControl.addPropertyChangeListener(new PropertyChangeListener(){
                final /* synthetic */ ActionControl val$useDefaultSettingsCtl;
                final /* synthetic */ ActionControl val$destinationMediaCtl;
                {
                    this.val$useDefaultSettingsCtl = actionControl;
                    this.val$destinationMediaCtl = actionControl2;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    boolean bl = !Boolean.parseBoolean(this.val$useDefaultSettingsCtl.getValue().get());
                    BackupOptionsTab.this.enableSettingsTabs(bl, this.val$destinationMediaCtl.getValue().get());
                }
            });
            booleanCheckBoxActionControl.addPropertyChangeListener(new PropertyChangeListener(){
                final /* synthetic */ ActionControl val$useDefaultSettingsCtl;
                final /* synthetic */ ActionControl val$destinationMediaCtl;
                {
                    this.val$useDefaultSettingsCtl = actionControl;
                    this.val$destinationMediaCtl = actionControl2;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    boolean bl = !Boolean.parseBoolean(this.val$useDefaultSettingsCtl.getValue().get());
                    BackupOptionsTab.this.enableSettingsTabs(bl, this.val$destinationMediaCtl.getValue().get());
                }
            });
        }
        if (this.useControl(1)) {
            booleanCheckBoxActionControl2.enableUI(true);
            booleanCheckBoxActionControl3.enableUI(false);
            comboBoxActionControl2.addPropertyChangeListener(new PropertyChangeListener(){
                final /* synthetic */ ActionControl val$backupTypeCtl;
                final /* synthetic */ ActionControl val$useForIncrementalCtl;
                final /* synthetic */ ActionControl val$refreshDatafileCopyCtl;
                {
                    this.val$backupTypeCtl = actionControl;
                    this.val$useForIncrementalCtl = actionControl2;
                    this.val$refreshDatafileCopyCtl = actionControl3;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    boolean bl = this.val$backupTypeCtl.getValue().get().equals(FULL_BACKUP);
                    this.val$useForIncrementalCtl.enableUI(bl);
                    this.val$refreshDatafileCopyCtl.enableUI(!bl);
                }
            });
            booleanCheckBoxActionControl5.enableUI(false);
            booleanCheckBoxActionControl4.addPropertyChangeListener(new PropertyChangeListener(){
                final /* synthetic */ ActionControl val$backupArchivedLogsCtl;
                final /* synthetic */ ActionControl val$deleteLogsAfterBackupCtl;
                {
                    this.val$backupArchivedLogsCtl = actionControl;
                    this.val$deleteLogsAfterBackupCtl = actionControl2;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    boolean bl = Boolean.parseBoolean(this.val$backupArchivedLogsCtl.getValue().get());
                    this.val$deleteLogsAfterBackupCtl.enableUI(bl);
                }
            });
            fileSizeActionControl.enableUI(false);
            booleanCheckBoxActionControl9.addPropertyChangeListener(new PropertyChangeListener(){
                final /* synthetic */ ActionControl val$multiSectionBackupCtl;
                final /* synthetic */ ActionControl val$sectionSizeCtl;
                {
                    this.val$multiSectionBackupCtl = actionControl;
                    this.val$sectionSizeCtl = actionControl2;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    boolean bl = Boolean.parseBoolean(this.val$multiSectionBackupCtl.getValue().get());
                    this.val$sectionSizeCtl.enableUI(bl);
                }
            });
        }
        if (this.useControl(4)) {
            booleanCheckBoxActionControl7.enableUI(false);
            comboBoxActionControl.addPropertyChangeListener(new PropertyChangeListener(){
                final /* synthetic */ ActionControl val$destinationMediaCtl;
                final /* synthetic */ ActionControl val$useProxyCopyCtl;
                {
                    this.val$destinationMediaCtl = actionControl;
                    this.val$useProxyCopyCtl = actionControl2;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    boolean bl = this.val$destinationMediaCtl.getValue().get().equals(TAPE_MEDIA);
                    this.val$useProxyCopyCtl.enableUI(bl);
                }
            });
        }
        if (this.useControl(2)) {
            textBoxActionControl.enableUI(false);
            booleanCheckBoxActionControl8.addPropertyChangeListener(new PropertyChangeListener(){
                final /* synthetic */ ActionControl val$useDefaultMaxFilesCtl;
                final /* synthetic */ ActionControl val$maxFilesPerBackupCtl;
                {
                    this.val$useDefaultMaxFilesCtl = actionControl;
                    this.val$maxFilesPerBackupCtl = actionControl2;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    boolean bl = Boolean.parseBoolean(this.val$useDefaultMaxFilesCtl.getValue().get());
                    this.val$maxFilesPerBackupCtl.enableUI(!bl);
                }
            });
        }
        diskEncryptionActionGroup.enableUI(true);
        comboBoxActionControl.addPropertyChangeListener(new PropertyChangeListener(){
            final /* synthetic */ ActionControl val$destinationMediaCtl;
            final /* synthetic */ GroupActionControl val$encryptionGroup;
            {
                this.val$destinationMediaCtl = actionControl;
                this.val$encryptionGroup = groupActionControl;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = this.val$destinationMediaCtl.getValue().get().equals(DISK_MEDIA);
                this.val$encryptionGroup.enableUI(bl);
            }
        });
        ArrayList<ActionControl> arrayList = new ArrayList<ActionControl>();
        arrayList.add((ActionControl)comboBoxActionControl);
        if (booleanCheckBoxActionControl != null) {
            arrayList.add((ActionControl)booleanCheckBoxActionControl);
        }
        if (comboBoxActionControl2 != null) {
            arrayList.add((ActionControl)comboBoxActionControl2);
        }
        if (booleanCheckBoxActionControl2 != null) {
            arrayList.add((ActionControl)booleanCheckBoxActionControl2);
        }
        if (booleanCheckBoxActionControl3 != null) {
            arrayList.add((ActionControl)booleanCheckBoxActionControl3);
        }
        if (booleanCheckBoxActionControl4 != null) {
            arrayList.add((ActionControl)booleanCheckBoxActionControl4);
        }
        if (booleanCheckBoxActionControl5 != null) {
            arrayList.add((ActionControl)booleanCheckBoxActionControl5);
        }
        if (booleanCheckBoxActionControl6 != null) {
            arrayList.add((ActionControl)booleanCheckBoxActionControl6);
        }
        if (booleanCheckBoxActionControl7 != null) {
            arrayList.add((ActionControl)booleanCheckBoxActionControl7);
        }
        if (booleanCheckBoxActionControl8 != null) {
            arrayList.add((ActionControl)booleanCheckBoxActionControl8);
        }
        if (textBoxActionControl != null) {
            arrayList.add((ActionControl)textBoxActionControl);
        }
        if (textBoxActionControl2 != null) {
            arrayList.add((ActionControl)textBoxActionControl2);
        }
        if (booleanCheckBoxActionControl9 != null) {
            arrayList.add((ActionControl)booleanCheckBoxActionControl9);
        }
        if (fileSizeActionControl != null) {
            arrayList.add((ActionControl)fileSizeActionControl);
        }
        arrayList.add((ActionControl)diskEncryptionActionGroup);
        return arrayList;
    }

    private boolean useControl(int n) {
        return (n & this._controlGroupsMask) == n;
    }

    private void enableSettingsTabs(boolean bl, String string) {
        for (String string2 : this._settingsTabs) {
            ActionDialogTab actionDialogTab = this._owningDialog.getAdditionalTab(string2);
            if (actionDialogTab == null) continue;
            boolean bl2 = bl;
            if (string2.equals("DISK_DEVICE_TAB")) {
                bl2 = bl2 && string.equals(DISK_MEDIA);
            } else if (string2.equals("TAPE_DEVICE_TAB")) {
                bl2 = bl2 && string.equals(TAPE_MEDIA);
            }
            actionDialogTab.enableUI(bl2);
            if (bl2) continue;
            actionDialogTab.reset();
        }
    }

    public static boolean hasBackupType(ActionDialog.Lookup lookup) {
        return lookup.get(BACKUP_TYPE) != null;
    }

    public static boolean hasUseDefaultSettings(ActionDialog.Lookup lookup) {
        return lookup.get(USE_DEFAULT_SETTINGS) != null;
    }

    public static boolean hasUseForIncremental(ActionDialog.Lookup lookup) {
        return lookup.get(USE_FOR_INCREMENTAL) != null;
    }

    public static boolean hasRefreshDatafileCopy(ActionDialog.Lookup lookup) {
        return lookup.get(REFRESH_DATAFILE_COPY) != null;
    }

    public static boolean hasBackupArchivedLogs(ActionDialog.Lookup lookup) {
        return lookup.get(BACKUP_ARCHIVED_LOGS) != null;
    }

    public static boolean hasDeleteLogsAfterBackup(ActionDialog.Lookup lookup) {
        return lookup.get(DELETE_LOGS_AFTER_BACKUP) != null;
    }

    public static boolean hasDeleteObsoleteBackups(ActionDialog.Lookup lookup) {
        return lookup.get(DELETE_OBSOLETE_BACKUPS) != null;
    }

    public static boolean hasUseProxyCopy(ActionDialog.Lookup lookup) {
        return lookup.get(USE_PROXY_COPY) != null;
    }

    public static boolean hasUseDefaultMaxFiles(ActionDialog.Lookup lookup) {
        return lookup.get(USE_DEFAULT_MAX_FILES) != null;
    }

    public static boolean hasMaxFilesPerBackupSet(ActionDialog.Lookup lookup) {
        return lookup.get(MAX_FILES_PER_BACKUP_SET) != null;
    }

    public static boolean hasMaxAllowableCorruptions(ActionDialog.Lookup lookup) {
        return lookup.get(MAX_ALLOWABLE_CORRUPTIONS) != null;
    }

    public static boolean hasMultiSectionBackup(ActionDialog.Lookup lookup) {
        return lookup.get(MULTI_SECTION_BACKUP) != null;
    }

    public static boolean hasSectionSize(ActionDialog.Lookup lookup) {
        return lookup.get(SECTION_SIZE, "SizeClause") != null;
    }

    public static boolean isFullBackup(ActionDialog.Lookup lookup) {
        return lookup.get(BACKUP_TYPE).equals(FULL_BACKUP);
    }

    public static boolean isIncrementalBackup(ActionDialog.Lookup lookup) {
        return lookup.get(BACKUP_TYPE).equals(INCREMENTAL_BACKUP);
    }

    public static boolean isUseDefaultSettings(ActionDialog.Lookup lookup) {
        return Boolean.parseBoolean(lookup.get(USE_DEFAULT_SETTINGS));
    }

    public static boolean isDiskMedia(ActionDialog.Lookup lookup) {
        return lookup.get(DESTINATION_MEDIA).equals(DISK_MEDIA);
    }

    public static boolean isTapeMedia(ActionDialog.Lookup lookup) {
        return lookup.get(DESTINATION_MEDIA).equals(TAPE_MEDIA);
    }

    public static boolean isUseForIncremental(ActionDialog.Lookup lookup) {
        return Boolean.parseBoolean(lookup.get(USE_FOR_INCREMENTAL));
    }

    public static boolean isRefreshDatafileCopy(ActionDialog.Lookup lookup) {
        return Boolean.parseBoolean(lookup.get(REFRESH_DATAFILE_COPY));
    }

    public static boolean isBackupArchivedLogs(ActionDialog.Lookup lookup) {
        return Boolean.parseBoolean(lookup.get(BACKUP_ARCHIVED_LOGS));
    }

    public static boolean isDeleteLogsAfterBackup(ActionDialog.Lookup lookup) {
        return Boolean.parseBoolean(lookup.get(DELETE_LOGS_AFTER_BACKUP));
    }

    public static boolean isDeleteObsoleteBackups(ActionDialog.Lookup lookup) {
        return Boolean.parseBoolean(lookup.get(DELETE_OBSOLETE_BACKUPS));
    }

    public static boolean isUseProxyCopy(ActionDialog.Lookup lookup) {
        return Boolean.parseBoolean(lookup.get(USE_PROXY_COPY));
    }

    public static boolean isUseDefaultMaxFiles(ActionDialog.Lookup lookup) {
        return Boolean.parseBoolean(lookup.get(USE_DEFAULT_MAX_FILES));
    }

    public static int getMaxFilesPerBackupSet(ActionDialog.Lookup lookup) {
        return Integer.parseInt(lookup.get(MAX_FILES_PER_BACKUP_SET));
    }

    public static int getMaxAllowableCorruptions(ActionDialog.Lookup lookup) {
        return Integer.parseInt(lookup.get(MAX_ALLOWABLE_CORRUPTIONS));
    }

    public static boolean isMultiSectionBackup(ActionDialog.Lookup lookup) {
        return Boolean.parseBoolean(lookup.get(MULTI_SECTION_BACKUP));
    }

    public static String getSectionSize(ActionDialog.Lookup lookup) {
        return lookup.get(SECTION_SIZE, "SizeClause");
    }
}

