/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dba.navigator;

import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.dba.DbaNavigatorResources;
import oracle.dbtools.raptor.dba.navigator.DbaNavigatorManager;
import oracle.dbtools.raptor.navigator.core.NavigatorManager;
import oracle.dbtools.raptor.navigator.core.NavigatorMenuController;
import oracle.dbtools.raptor.service.dba.DBAViewer;
import oracle.dbtools.raptor.utils.LicenseUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.SingletonProvider;

public class DBANavigatorViewController
extends NavigatorMenuController {
    private static final String DBA_NAV_CMD = "DbaNavigator.SHOW_NAVIGATOR";
    private static final int DBA_NAV_CMD_ID = Ide.findOrCreateCmdID((String)"DbaNavigator.SHOW_NAVIGATOR");
    private static final int TOGGLE_TOOLBAR_CMD_ID = Ide.findOrCreateCmdID((String)"DbaNavigator.TOGGLE_TOOLBAR_CMD_ID");
    private static final int OPEN_SQL_MONITOR = Ide.findOrCreateCmdID((String)"MetricsSqlMonitor.OPEN");

    public DBANavigatorViewController() {
        super(DBA_NAV_CMD_ID, TOGGLE_TOOLBAR_CMD_ID);
    }

    protected NavigatorManager getNavMgr() {
        return DbaNavigatorManager.getInstance();
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = super.handleEvent(ideAction, context);
        if (!bl && OPEN_SQL_MONITOR == ideAction.getCommandId()) {
            String string;
            DBAViewer dBAViewer = (DBAViewer)SingletonProvider.find(DBAViewer.class);
            if (dBAViewer != null && (string = ConnectionSelectorUI.getConnection((String)DbaNavigatorResources.getString("SQL_MONITOR_CONNECTION_CHOICE_TITLE"), (String)DbaNavigatorResources.getString("SQL_MONITOR_CONNECTION_CHOICE_LABEL"), null, (boolean)true, (boolean)false)) != null && LicenseUtils.requiresTuning((String)string)) {
                dBAViewer.show(string, null, "SQL_MONITOR");
            }
            bl = true;
        }
        return bl;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return super.update(ideAction, context) || OPEN_SQL_MONITOR == ideAction.getCommandId();
    }
}

