/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.mysql5;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdEnumColumn;
import oracle.dbtools.metadata.persistence.MdIdentityColumn;
import oracle.dbtools.metadata.persistence.MdIndexDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdPrivilege;
import oracle.dbtools.metadata.persistence.MdSetColumn;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.MdUserPrivilege;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.capture.CaptureAudience;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.CaptureQueries;
import oracle.dbtools.migration.capture.QueryCapture;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.mysql3.MySQLColumnHelper;
import oracle.dbtools.migration.workbench.mysql3.MySQLMigrationAddinArb;
import oracle.dbtools.migration.workbench.mysql4.MySQL4Capturer;
import oracle.dbtools.migration.workbench.mysql5.Messages;
import oracle.dbtools.migration.workbench.mysql5.MySQL5CaptureQueries;
import oracle.dbtools.migration.workbench.mysql5.MySQL5MigrationAddinArb;

public class MySQL5Capturer
extends MySQL4Capturer {
    private static MySQL5CaptureQueries s_captureQueries;
    private static final String CAPTURE_COLUMNS_QUERY = "SELECT COLUMN_NAME,IS_NULLABLE,COLUMN_TYPE,CHARACTER_MAXIMUM_LENGTH, NUMERIC_PRECISION,NUMERIC_SCALE,COLUMN_DEFAULT,COLUMN_KEY,PRIVILEGES,EXTRA,COLUMN_COMMENT FROM INFORMATION_SCHEMA.COLUMNS WHERE (TABLE_SCHEMA='";
    private static final String CAPTURE_INDEX_QUERY = "SELECT DISTINCT (INDEX_NAME) INDEX_NAME ,TABLE_NAME , SEQ_IN_INDEX,COLUMN_NAME ,SUB_PART , INDEX_TYPE,NON_UNIQUE FROM INFORMATION_SCHEMA.STATISTICS WHERE (TABLE_SCHEMA='";
    private static final String CAPTURE_CONSTRAINT_QUERY = "SELECT CONSTRAINT_NAME,CONSTRAINT_TYPE FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE (TABLE_SCHEMA ='";
    private static final String CAPTURE_CONSTRAINT_DETAILS_QUERY = "SELECT CONSTRAINT_NAME , TABLE_SCHEMA ,TABLE_NAME,COLUMN_NAME , REFERENCED_TABLE_SCHEMA ,REFERENCED_TABLE_NAME,REFERENCED_COLUMN_NAME FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE WHERE ( TABLE_SCHEMA ='";
    private static final String CAPTURE_STORED_PROGRAMS_QUERY = "SELECT ROUTINE_NAME , ROUTINE_TYPE , ROUTINE_DEFINITION,ROUTINE_SCHEMA ,CREATED , DEFINER , LAST_ALTERED,ROUTINE_COMMENT  FROM INFORMATION_SCHEMA.ROUTINES ";
    private static final String CAPTURE_VIEWS_QUERY = "SELECT TABLE_SCHEMA, TABLE_NAME, VIEW_DEFINITION, DEFINER  FROM  INFORMATION_SCHEMA.VIEWS ";
    private static final String INDEX_TYPE = "INDEX_TYPE";

    public MySQL5Capturer(MigrationStorer migrationStorer, Connection connection) {
        super(migrationStorer, connection);
    }

    @Override
    public CaptureQueries getCaptureQueries() {
        if (s_captureQueries == null) {
            s_captureQueries = new MySQL5CaptureQueries();
        }
        return s_captureQueries;
    }

    @Override
    public void captureObjects(String string, CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        if (string.equals("MD_STORED_PROGRAMS")) {
            this.captureStoredPrograms(captureContext, migrationObjectFilter);
        } else if (string.equals("MD_VIEWS")) {
            this.captureViews(captureContext, migrationObjectFilter);
        } else {
            super.captureObjects(string, captureContext, migrationObjectFilter);
        }
    }

    @Override
    protected void captureUsers(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) {
        try {
            CloseableResultSet closeableResultSet = null;
            CaptureAudience captureAudience = captureContext.getAudience();
            String string = captureContext.applyToSQLString("${schema}");
            String string2 = "SELECT DISTINCT GRANTEE FROM INFORMATION_SCHEMA.SCHEMA_PRIVILEGES WHERE TABLE_SCHEMA = '" + string + "'";
            CloseableResultSet closeableResultSet2 = QueryCapture.issueSQL((String)string2, (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            ResultSet resultSet = closeableResultSet2.getResultSet();
            while (resultSet.next() && !captureContext.shouldCancel()) {
                boolean bl;
                String string3 = "SELECT GRANTEE , PRIVILEGE_TYPE, IS_GRANTABLE FROM INFORMATION_SCHEMA.USER_PRIVILEGES";
                StringBuffer stringBuffer = new StringBuffer(string3 + " WHERE GRANTEE LIKE \"" + resultSet.getString(1) + "\"");
                String string4 = this.getHostFromGrantee(resultSet.getString(1));
                closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
                ResultSet resultSet2 = closeableResultSet.getResultSet();
                boolean bl2 = bl = !resultSet2.next();
                while (!bl) {
                    DBObjectId dBObjectId;
                    if (captureContext.shouldCancel()) {
                        dBObjectId = new CaptureEvent(-1, "USERS", "");
                        captureContext.getAudience().fireListeners((CaptureEvent)dBObjectId);
                        closeableResultSet.close();
                        return;
                    }
                    dBObjectId = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
                    if (resultSet2.getString(1) == null || resultSet2.getString(1).length() <= 0) continue;
                    if (string4.equals(this.getHostFromGrantee(resultSet2.getString(1)))) {
                        String string5;
                        MdUser mdUser;
                        boolean bl3 = false;
                        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
                        CloseableIterator closeableIterator = persistenceUtility.getUsersforSchemaId(dBObjectId);
                        while (closeableIterator.hasNext()) {
                            mdUser = (MdUser)closeableIterator.next();
                            string5 = mdUser.getProperty(MySQLMigrationAddinArb.getString("MySQL_GRANTEE"));
                            if (!mdUser.getObjectName().equalsIgnoreCase(this.getUserFromGrantee(resultSet2.getString(1))) || !string5.equalsIgnoreCase(resultSet2.getString(1))) continue;
                            bl3 = true;
                            break;
                        }
                        if (bl3) continue;
                        if (this.getUserFromGrantee(resultSet2.getString(1)).length() > 0) {
                            mdUser = new MdUser(dBObjectId, this.getUserFromGrantee(resultSet2.getString(1)));
                            string5 = this.getPassword(this.getUserFromGrantee(resultSet2.getString(1)), string4, captureContext);
                            mdUser.setPassword(string5);
                            DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
                            mdUser.addProperty(new AdditionalProperty(MySQLMigrationAddinArb.getString("MySQL_GRANTEE"), resultSet2.getString(1)), dBObjectId2);
                            CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_USER"), mdUser.getUsername());
                            captureAudience.fireListeners(captureEvent);
                            mdUser = (MdUser)this.getStorer().storeObject((PersistableObject)mdUser);
                            captureEvent.setEventId(4);
                            captureAudience.fireListeners(captureEvent);
                            do {
                                this.createUserPrivilegeDetails(captureContext, mdUser, resultSet2);
                            } while (!(bl = !resultSet2.next()) && this.getUserFromGrantee(resultSet2.getString(1)).equals(mdUser.getUsername()));
                            continue;
                        }
                        bl = !resultSet2.next();
                        continue;
                    }
                    resultSet2.next();
                }
            }
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
            if (closeableResultSet2 != null) {
                closeableResultSet2.close();
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPassword(String string, String string2, CaptureContext captureContext) {
        try (CloseableResultSet closeableResultSet = null;){
            StringBuffer stringBuffer = new StringBuffer("SELECT HOST , USER , PASSWORD FROM mysql.user ");
            stringBuffer.append("WHERE (HOST='" + string2 + "' AND USER='" + string + "')");
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            ResultSet resultSet = closeableResultSet.getResultSet();
            resultSet.next();
            String string3 = resultSet.getString(3);
            return string3;
        }
    }

    private String getHostFromGrantee(String string) {
        String string2 = string.substring(string.lastIndexOf("@'") + 2, string.length() - 1);
        return string2;
    }

    private String getUserFromGrantee(String string) {
        String string2 = string.substring(1, string.lastIndexOf("'@'"));
        return string2;
    }

    @Override
    protected void createUserPrivilegeDetails(CaptureContext captureContext, MdUser mdUser, ResultSet resultSet) {
        try {
            PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
            DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
            DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
            String string = this.getOracleSpecificPrivilege(resultSet.getString(2));
            boolean bl = false;
            if (string.length() == 0) {
                string = resultSet.getString(2);
                bl = true;
            }
            MdPrivilege mdPrivilege = new MdPrivilege(dBObjectId, " ", "MD_USERS", string, new ClobHelper(" "));
            DBObjectId dBObjectId3 = persistenceUtility.getIdForUser(dBObjectId, mdUser.getUsername());
            mdPrivilege.setPrivelegeObjectId(dBObjectId3);
            if (resultSet.getString(3).equals("YES")) {
                mdPrivilege.setAdminOption("Y");
            } else {
                mdPrivilege.setAdminOption("N");
            }
            if (bl) {
                mdPrivilege.addProperty(new AdditionalProperty(MySQLMigrationAddinArb.getString("MySQL_PRIVILEGE"), string), dBObjectId2);
            }
            CaptureEvent captureEvent = new CaptureEvent(3, "USER PRIVILEGE", resultSet.getString(2));
            captureContext.getAudience().fireListeners(captureEvent);
            mdPrivilege = (MdPrivilege)this.getStorer().storeObject((PersistableObject)mdPrivilege);
            captureEvent.setEventId(4);
            captureContext.getAudience().fireListeners(captureEvent);
            MdUserPrivilege mdUserPrivilege = new MdUserPrivilege(mdUser.getKey());
            mdUserPrivilege.setPrivilegeId(mdPrivilege.getKey());
            mdUserPrivilege = (MdUserPrivilege)this.getStorer().storeObject((PersistableObject)mdUserPrivilege);
        }
        catch (SQLException sQLException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
        }
    }

    @Override
    protected void captureColumnDetails(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        Object object;
        StringBuffer stringBuffer;
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
        CaptureAudience captureAudience = captureContext.getAudience();
        Object object2 = null;
        String string = captureContext.applyToSQLString("${schema}");
        String string2 = captureContext.applyToSQLString("${table}");
        StringBuffer stringBuffer2 = new StringBuffer(CAPTURE_COLUMNS_QUERY);
        stringBuffer2.append(string).append("' AND (binary TABLE_NAME='").append(string2).append("' OR (TABLE_NAME = '").append(string2).append("'").append(" AND length('").append(string2).append("')").append(" <> char_length('").append(string2).append("')))");
        if (migrationObjectFilter != null) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(migrationObjectFilter.toWhereClause("COLUMN_NAME "));
            object = stringBuffer.toString().replaceAll("WHERE", "AND");
            stringBuffer2.append((String)object);
        }
        stringBuffer2.append(")");
        stringBuffer = QueryCapture.issueSQL((String)stringBuffer2.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
        object = stringBuffer.getResultSet();
        int n = 1;
        DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("TABLEID");
        while (object.next()) {
            CloseableResultSet closeableResultSet;
            Object object3;
            String string3;
            String[] stringArray;
            if (captureContext.shouldCancel()) {
                stringArray = new CaptureEvent(-1, MigrationAddinArb.getString((String)"MD_COLUMNS"), "");
                captureContext.getAudience().fireListeners((CaptureEvent)stringArray);
                stringBuffer.close();
                return;
            }
            stringArray = null;
            boolean bl = false;
            MySQLColumnHelper mySQLColumnHelper = new MySQLColumnHelper(object.getString(3));
            String string4 = mySQLColumnHelper.getDataTypeName();
            if (string4 != null && (string4.equals("ENUM") || string4.equals("SET")) && (stringArray = this.getAllValues(object.getString(3))) != null) {
                object2 = string4.equals("ENUM") ? new MdEnumColumn(dBObjectId2, object.getString(1), Integer.valueOf(n++), stringArray, dBObjectId) : new MdSetColumn(dBObjectId2, object.getString(1), Integer.valueOf(n++), stringArray, dBObjectId);
                bl = true;
            }
            if ((string3 = object.getString(10)).equals("auto_increment") && !bl) {
                object3 = "SELECT MAX(`" + object.getString(1) + "`) FROM `" + string + "`.`" + string2 + "`";
                closeableResultSet = QueryCapture.issueSQL((String)object3, (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
                ResultSet resultSet = closeableResultSet.getResultSet();
                long l = 0L;
                while (resultSet.next()) {
                    l = resultSet.getLong(1);
                }
                closeableResultSet.close();
                object2 = new MdIdentityColumn(dBObjectId2, object.getString(1), Integer.valueOf(n++), 0L, 1L, l, dBObjectId);
                bl = true;
            }
            if (!bl) {
                object2 = new MdColumn(dBObjectId2, object.getString(1), Integer.valueOf(n++));
            }
            if (string3 != null && string3.trim().length() > 0) {
                object2.addProperty(new AdditionalProperty("EXTRA", string3), dBObjectId);
            }
            if (string4 != null) {
                object2.setColumnType(string4);
            } else {
                object2.setColumnType(mySQLColumnHelper.getOriginalType());
                Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, mySQLColumnHelper.getOriginalType() + Messages.getString("MySQL5Capturer.0"), object2.getColumnName());
            }
            object2.setPrecision(Integer.valueOf(mySQLColumnHelper.getPrecision()));
            if (mySQLColumnHelper.hasPrecisionAndScale()) {
                object2.setScale(Integer.valueOf(mySQLColumnHelper.getScale()));
            }
            if (object.getString(2).equalsIgnoreCase("YES")) {
                object2.setNullable("Y");
            } else {
                object2.setNullable("N");
            }
            String string5 = object.getString(8);
            if (string5.equals("PRI")) {
                // empty if block
            }
            object2.setDefaultValue(object.getString(7));
            object3 = object.getString(11);
            if (object3 != null && ((String)object3).length() > 0) {
                object2.setComments((String)object3);
            }
            closeableResultSet = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_COLUMNS"), object2.getColumnName());
            captureAudience.fireListeners((CaptureEvent)closeableResultSet);
            object2 = (MdColumn)this.getStorer().storeObject((PersistableObject)object2);
            closeableResultSet.setEventId(4);
            captureAudience.fireListeners((CaptureEvent)closeableResultSet);
            String string6 = object.getString(9);
            if (string6 == null || string6.trim().length() <= 0) continue;
            this.captureColumnPrivilege(string6, captureContext, (MdColumn)object2);
        }
        stringBuffer.close();
    }

    @Override
    protected void captureIndexForTable(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        boolean bl;
        Object object;
        StringBuffer stringBuffer = new StringBuffer(CAPTURE_INDEX_QUERY);
        String string = captureContext.applyToSQLString("${schema}");
        String string2 = captureContext.applyToSQLString("${table}");
        stringBuffer.append(string).append("' AND TABLE_NAME='").append(string2).append("'");
        CloseableResultSet closeableResultSet = null;
        if (migrationObjectFilter != null) {
            object = new StringBuffer();
            ((StringBuffer)object).append(migrationObjectFilter.toWhereClause("INDEX_NAME "));
            String string3 = ((StringBuffer)object).toString().replaceAll("WHERE", "AND");
            stringBuffer.append(string3);
        }
        stringBuffer.append(")");
        closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
        object = closeableResultSet.getResultSet();
        boolean bl2 = bl = !object.next();
        while (!bl) {
            DBObjectId dBObjectId;
            Object object2;
            DBObjectId dBObjectId2;
            int n = 1;
            if (captureContext.shouldCancel()) {
                dBObjectId2 = new CaptureEvent(-1, "INDEX", "");
                captureContext.getAudience().fireListeners((CaptureEvent)dBObjectId2);
                closeableResultSet.close();
                return;
            }
            dBObjectId2 = (DBObjectId)captureContext.getContextVariable("TABLEID");
            int n2 = object.getInt(7);
            String string4 = "select COLUMN_NAME , COLUMN_KEY from information_schema.columns where (TABLE_SCHEMA = '" + string + "' AND TABLE_NAME ='" + object.getString(2) + "')";
            CloseableResultSet closeableResultSet2 = QueryCapture.issueSQL((String)string4, (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            ResultSet resultSet = closeableResultSet2.getResultSet();
            String string5 = "";
            while (resultSet.next()) {
                if (!resultSet.getString(1).equals(object.getString(4))) continue;
                string5 = resultSet.getString(2);
                break;
            }
            closeableResultSet2.close();
            if (string5.startsWith("PRI") && n2 == 0 && object.getString(1).equals("PRIMARY")) {
                object2 = this.createPrimaryIndexConstraint(captureContext, object.getString(1), dBObjectId2);
                do {
                    this.createPrimaryIndexConstraintDetails(captureContext, (MdConstraint)object2, object.getString(4), n++, dBObjectId2);
                } while (!(bl = !object.next()) && object.getString(1).equals(object2.getObjectName()));
                continue;
            }
            MdIndexe mdIndexe = new MdIndexe(dBObjectId2);
            mdIndexe.setIndexName(object.getString(1));
            if (n2 == 0) {
                mdIndexe.setIndexType("UNIQUE");
            } else {
                mdIndexe.setIndexType("NON_UNIQUE");
            }
            object2 = object.getString(6);
            if (object2 != null && ((String)object2).trim().length() > 0) {
                dBObjectId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
                mdIndexe.addProperty(new AdditionalProperty(INDEX_TYPE, (String)object2), dBObjectId);
            }
            dBObjectId = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEXES"), mdIndexe.getIndexName());
            captureContext.getAudience().fireListeners((CaptureEvent)dBObjectId);
            mdIndexe = (MdIndexe)this.getStorer().storeObject((PersistableObject)mdIndexe);
            dBObjectId.setEventId(4);
            captureContext.getAudience().fireListeners((CaptureEvent)dBObjectId);
            do {
                this.createIndexDetails(captureContext, mdIndexe, (ResultSet)object, n++);
            } while (!(bl = !object.next()) && object.getString(1).equals(mdIndexe.getIndexName()));
        }
        closeableResultSet.close();
    }

    @Override
    protected void createIndexDetails(CaptureContext captureContext, MdIndexe mdIndexe, ResultSet resultSet, int n) throws PersistenceException, SQLException {
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        MdIndexDetail mdIndexDetail = new MdIndexDetail(mdIndexe.getKey(), persistenceUtility.getIdForColumn(mdIndexe.getTableId(), resultSet.getString(4)), Integer.valueOf(n));
        int n2 = resultSet.getInt(5);
        if (!resultSet.wasNull()) {
            mdIndexDetail.setIndexPortion(Integer.valueOf(n2));
        }
        CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEX_DETAILS"), mdIndexe.getIndexName());
        captureContext.getAudience().fireListeners(captureEvent);
        mdIndexDetail = (MdIndexDetail)this.getStorer().storeObject((PersistableObject)mdIndexDetail);
        captureEvent.setEventId(4);
        captureContext.getAudience().fireListeners(captureEvent);
    }

    @Override
    protected void captureConstraintForTable(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        String string;
        StringBuffer stringBuffer;
        String string2 = captureContext.applyToSQLString("${schema}");
        String string3 = captureContext.applyToSQLString("${table}");
        StringBuffer stringBuffer2 = new StringBuffer(CAPTURE_CONSTRAINT_QUERY);
        stringBuffer2.append(string2).append("' AND TABLE_NAME='").append(string3).append("'");
        if (migrationObjectFilter != null) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(migrationObjectFilter.toWhereClause("CONSTRAINT_NAME "));
            string = stringBuffer.toString().replaceAll("WHERE", "AND");
            stringBuffer2.append(string);
        }
        stringBuffer2.append(")");
        stringBuffer = QueryCapture.issueSQL((String)stringBuffer2.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
        string = (DBObjectId)captureContext.getContextVariable("TABLEID");
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
        ResultSet resultSet = stringBuffer.getResultSet();
        while (resultSet.next() && !captureContext.shouldCancel()) {
            CloseableResultSet closeableResultSet;
            Object object;
            StringBuffer stringBuffer3;
            if (resultSet.getString(2).equals("FOREIGN KEY")) {
                stringBuffer3 = new StringBuffer("SELECT DISTINCT CONSTRAINT_NAME , REFERENCED_TABLE_NAME FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE WHERE ");
                stringBuffer3.append("CONSTRAINT_NAME ='").append(resultSet.getString(1)).append("'");
                object = this.getStorer().getPersistenceUtility();
                closeableResultSet = QueryCapture.issueSQL((String)stringBuffer3.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
                ResultSet resultSet2 = closeableResultSet.getResultSet();
                resultSet2.next();
                DBObjectId dBObjectId2 = object.getIdForTable(dBObjectId, resultSet2.getString(2));
                MdConstraint mdConstraint = new MdConstraint((DBObjectId)string, "MySQL");
                mdConstraint.setConstraintType("FOREIGN KEY");
                mdConstraint.setName(resultSet.getString(1));
                mdConstraint.setReftableId(dBObjectId2);
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint.getName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
                this.processConstraintRow(captureContext, mdConstraint, dBObjectId, string3, string2, false);
                continue;
            }
            if (!resultSet.getString(2).equals("UNIQUE")) continue;
            stringBuffer3 = new MdConstraint((DBObjectId)string, "MySQL");
            stringBuffer3.setConstraintType("UNIQUE");
            object = resultSet.getString(1);
            stringBuffer3.setName((String)object);
            closeableResultSet = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), stringBuffer3.getName());
            captureContext.getAudience().fireListeners((CaptureEvent)closeableResultSet);
            stringBuffer3 = (MdConstraint)this.getStorer().storeObject((PersistableObject)stringBuffer3);
            closeableResultSet.setEventId(4);
            captureContext.getAudience().fireListeners((CaptureEvent)closeableResultSet);
            this.processConstraintRow(captureContext, (MdConstraint)stringBuffer3, dBObjectId, string3, string2, true);
        }
        stringBuffer.close();
    }

    private void processConstraintRow(CaptureContext captureContext, MdConstraint mdConstraint, DBObjectId dBObjectId, String string, String string2, boolean bl) throws SQLException, PersistenceException {
        StringBuffer stringBuffer = new StringBuffer(CAPTURE_CONSTRAINT_DETAILS_QUERY);
        stringBuffer.append(string2).append("' AND TABLE_NAME='").append(string).append("' AND CONSTRAINT_NAME ='").append(mdConstraint.getName()).append("')");
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        CloseableResultSet closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
        ResultSet resultSet = closeableResultSet.getResultSet();
        int n = 1;
        while (resultSet.next()) {
            DBObjectId dBObjectId2 = persistenceUtility.getIdForTable(dBObjectId, resultSet.getString(3));
            DBObjectId dBObjectId3 = persistenceUtility.getIdForColumn(dBObjectId2, resultSet.getString(4));
            DBObjectId dBObjectId4 = persistenceUtility.getIdForTable(dBObjectId, resultSet.getString(6));
            if (dBObjectId4 == null && !bl) {
                Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, "Capture.CONSTRAINTSKIPPED", new String[]{mdConstraint.getName(), resultSet.getString(6)});
                continue;
            }
            if (bl) {
                n = this.createConstraintDetails(mdConstraint.getKey(), dBObjectId3, "N", n, captureContext);
                continue;
            }
            DBObjectId dBObjectId5 = persistenceUtility.getIdForColumn(dBObjectId4, resultSet.getString(7));
            n = this.createConstraintDetails(mdConstraint.getKey(), dBObjectId3, "N", n, captureContext);
            n = this.createConstraintDetails(mdConstraint.getKey(), dBObjectId5, "Y", n, captureContext);
        }
        closeableResultSet.close();
    }

    private int createConstraintDetails(DBObjectId dBObjectId, DBObjectId dBObjectId2, String string, int n, CaptureContext captureContext) throws PersistenceException, SQLException {
        int n2 = n;
        MdConstraintDetail mdConstraintDetail = new MdConstraintDetail(dBObjectId, Integer.valueOf(n2++));
        mdConstraintDetail.setColumnId(dBObjectId2);
        mdConstraintDetail.setRefFlag(string);
        CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), "");
        captureContext.getAudience().fireListeners(captureEvent);
        captureEvent.setEventId(4);
        captureContext.getAudience().fireListeners(captureEvent);
        mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureStoredPrograms(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) {
        try (CloseableResultSet closeableResultSet = null;){
            Object object;
            StringBuffer stringBuffer;
            String string = captureContext.applyToSQLString("${schema}");
            StringBuffer stringBuffer2 = new StringBuffer(CAPTURE_STORED_PROGRAMS_QUERY);
            stringBuffer2.append(" WHERE ( ROUTINE_SCHEMA='").append(string).append("' ");
            if (migrationObjectFilter != null) {
                stringBuffer = new StringBuffer();
                stringBuffer.append(migrationObjectFilter.toWhereClause("ROUTINE_NAME "));
                object = stringBuffer.toString().replaceAll("WHERE", "AND");
                stringBuffer2.append((String)object);
            }
            stringBuffer2.append(")");
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer2.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            stringBuffer = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
            object = closeableResultSet.getResultSet();
            while (object.next() && !captureContext.shouldCancel()) {
                MdStoredProgram mdStoredProgram = new MdStoredProgram((DBObjectId)stringBuffer, "MySQL");
                String string2 = object.getString(1);
                mdStoredProgram.setName(string2);
                String string3 = object.getString(2);
                mdStoredProgram.setProgramtype(string3);
                String string4 = object.getString(8);
                if (string4 != null && string4.length() > 0) {
                    mdStoredProgram.setComments(string4);
                }
                String string5 = "SHOW CREATE " + string3 + " " + string + "." + string2;
                CloseableResultSet closeableResultSet2 = QueryCapture.issueSQL((String)string5, (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
                ResultSet resultSet = closeableResultSet2.getResultSet();
                StringBuffer stringBuffer3 = new StringBuffer();
                while (resultSet.next()) {
                    stringBuffer3.append(resultSet.getString(3));
                }
                closeableResultSet2.close();
                String string6 = stringBuffer3.toString();
                if (string6.trim().length() == 0) {
                    Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, MySQL5MigrationAddinArb.getString("NoRightsOnProcedue"), new Object[]{string3, string, string2});
                    continue;
                }
                mdStoredProgram.setNativeSql(string6);
                mdStoredProgram.setCreatedOn(object.getDate(5));
                mdStoredProgram.setCreatedBy(object.getString(6));
                mdStoredProgram.setLastUpdatedOn(object.getDate(7));
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_STORED_PROGRAMS"), mdStoredProgram.getName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdStoredProgram = (MdStoredProgram)this.getStorer().storeObject((PersistableObject)mdStoredProgram);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureViews(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) {
        try (CloseableResultSet closeableResultSet = null;){
            Object object;
            StringBuffer stringBuffer;
            String string = captureContext.applyToSQLString("${schema}");
            StringBuffer stringBuffer2 = new StringBuffer(CAPTURE_VIEWS_QUERY);
            stringBuffer2.append(" WHERE ( TABLE_SCHEMA='").append(string).append("' ");
            if (migrationObjectFilter != null) {
                stringBuffer = new StringBuffer();
                stringBuffer.append(migrationObjectFilter.toWhereClause("TABLE_NAME "));
                object = stringBuffer.toString().replaceAll("WHERE", "AND");
                stringBuffer2.append((String)object);
            }
            stringBuffer2.append(")");
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer2.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            stringBuffer = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
            object = closeableResultSet.getResultSet();
            while (object.next() && !captureContext.shouldCancel()) {
                MdView mdView = new MdView((DBObjectId)stringBuffer, "MySQL");
                String string2 = object.getString(2);
                mdView.setViewName(string2);
                mdView.setNativeSql(this.putInViewPrefix(object.getString(3), string2));
                mdView.setCreatedBy(object.getString(4));
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_VIEWS"), mdView.getViewName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdView = (MdView)this.getStorer().storeObject((PersistableObject)mdView);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        }
    }
}

