/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.worksheet.extension;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.olap.OLAPArb;
import oracle.olap.dml.parser.OLAPDMLBackgroundParser;
import oracle.olap.worksheet.extension.OLAPWorksheetURLFileSystemHelper;

public class OLAPWorksheetNode
extends TextNode {
    public static final String EXT = ".olapdml";
    private static final Logger LOGGER = Logger.getLogger(OLAPWorksheetNode.class.getName());
    private OLAPDMLBackgroundParser parser = new OLAPDMLBackgroundParser();
    private String m_connName;
    private Icon m_icon;

    public OLAPWorksheetNode() {
        this(null);
    }

    public OLAPWorksheetNode(URL uRL) {
        super(uRL);
    }

    public String getConnectionName() {
        return this.m_connName;
    }

    public void setConnectionName(String string) {
        this.m_connName = string;
        OLAPWorksheetURLFileSystemHelper.updateDisplayName(this.getURL(), string);
        UpdateMessage.fireObjectRenamed((Subject)this);
    }

    public String getShortLabel() {
        return OLAPWorksheetNode.getDisplayName(this);
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public OLAPDMLBackgroundParser getParser() {
        return this.parser;
    }

    protected void closeImpl() throws IOException {
        super.closeImpl();
        this.m_connName = null;
    }

    public Icon getIcon() {
        return this.m_icon != null ? this.m_icon : OLAPArb.getIcon("OLAP_WORKSHEET_ICON");
    }

    public void setIcon(Icon icon) {
        this.m_icon = icon;
    }

    private static String getDisplayName(OLAPWorksheetNode oLAPWorksheetNode) {
        return URLFileSystem.getPlatformPathName((URL)oLAPWorksheetNode.getURL());
    }

    static {
        CodeEditor.registerNodeType(OLAPWorksheetNode.class, (String)"olapdml");
    }
}

