/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.qdr;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.olap.OLAPArb;
import oracle.olap.OLAPResources;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.NamedObject;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.app.table.Queries;
import oracle.olap.app.templates.templatelist.QDRData;
import oracle.olap.app.templates.templateview.ItemElement;
import oracle.olap.app.tree.model.DefaultNode;
import oracle.olap.app.tree.model.HierarchyNodeData;
import oracle.olap.hierarchyviewer.HierarchyET;
import oracle.olap.hierarchyviewer.HierarchyViewerDialog;
import oracle.olap.stringexpr.ParamProperty;
import oracle.olap.stringexpr.ParamStringExpr;
import oracle.olap.syntaxbuilder.TableCellButtonWrapper;
import oracle.olap.syntaxbuilder.qdr.QDRTableModel;
import oracle.olap.util.OLAPErrorDisplay;

public class QDRPanel
extends JPanel {
    private transient Logger LOG = Logger.getLogger(QDRPanel.class.getName());
    private final QDRTableModel model;
    private transient Connection conn;
    private final String owner;
    private static final String XMLFILE = "QDRQueries.xml";
    private static final String PACK = "oracle.olap.app.table";
    private transient Queries queries;
    private Schema schema;
    private String initialHierarchy;

    public QDRPanel(Connection connection, Vector<QDRData> vector, String string, String string2) {
        super(new BorderLayout());
        this.conn = connection;
        this.owner = string;
        this.initialHierarchy = string2;
        try {
            this.queries = (Queries)JavaXMLBind.BindToJava(this.getClass().getResource(XMLFILE), PACK, null);
        }
        catch (Exception exception) {
            this.LOG.log(Level.SEVERE, exception.getMessage(), exception);
        }
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "olap_select_qdr");
        final JTable jTable = new JTable();
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.add((Component)jScrollPane, "Center");
        this.model = new QDRTableModel(vector);
        jTable.setModel(this.model);
        TableColumn tableColumn = jTable.getColumn(QDRTableModel.COLUMNS[1]);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setEditable(true);
        jComboBox.addItem("");
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jComboBox);
        SearchButton searchButton = new SearchButton(defaultCellEditor);
        SearchButton searchButton2 = new SearchButton(new DefaultTableCellRenderer());
        tableColumn.setCellEditor(searchButton);
        tableColumn.setCellRenderer(searchButton2);
        AbstractAction abstractAction = new AbstractAction("MEMBERSELECTOR"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = jTable.getSelectedRow();
                if (n >= 0 && n < QDRPanel.this.model.getRowCount()) {
                    QDRPanel.this.showSelector(n);
                }
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(114, 0);
        jTable.getInputMap(1).put(keyStroke, abstractAction.getValue("Name"));
        jTable.getActionMap().put(abstractAction.getValue("Name"), abstractAction);
        jTable.getInputMap().put(keyStroke, abstractAction.getValue("Name"));
        jTable.getActionMap().put(abstractAction.getValue("Name"), abstractAction);
    }

    private void showSelector(int n) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        String string = (String)this.model.getValueAt(n, 0);
        QDRData qDRData = this.model.getRowValue(n);
        QDRData[] qDRDataArray = null;
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        OLAPErrorDisplay oLAPErrorDisplay = new OLAPErrorDisplay();
        String string2 = OLAPArb.getString("DIMENSION_MEMBER_SELECTOR_TITLE");
        OLAPResources oLAPResources = new OLAPResources();
        String string3 = qDRData.getMemberKey();
        if (string3 != null) {
            qDRDataArray = new QDRData[]{qDRData};
        }
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.conn);
        String string4 = Connections.getInstance().getConnectionName(this.conn);
        try {
            this.schema = OLAPMetadataCache.getUpdatedSchema(string4, this.owner);
        }
        catch (Exception exception) {
            this.LOG.log(Level.SEVERE, exception.getMessage(), exception);
        }
        oracle.olap.app.olapmetadata.Dimension dimension = this.schema.findDimension(string);
        ArrayList<HierarchyET> arrayList = new ArrayList<HierarchyET>();
        if (!dimension.isFlat()) {
            boolean bl = false;
            object6 = dimension.getHierarchies();
            Iterator<DimensionHierarchy> iterator = object6.iterator();
            while (iterator.hasNext()) {
                object5 = iterator.next();
                try {
                    arrayList.add(new HierarchyET(this.conn, dimension, (DimensionHierarchy)object5));
                    if (bl || qDRDataArray == null) continue;
                    object4 = qDRDataArray;
                    object3 = "select count({hierarchy.keyColumnName}) from {hierarchy.viewName} where {hierarchy.keyColumnName} in ({hierarchy_members})";
                    object2 = new ParamProperty(){
                        final /* synthetic */ DimensionHierarchy val$dimHier;
                        final /* synthetic */ QDRData[] val$qdrs2;
                        {
                            this.val$dimHier = dimensionHierarchy;
                            this.val$qdrs2 = qDRDataArray;
                        }

                        @Override
                        public String getParamPropertyValue(String string, String string2, Measure measure, ItemElement itemElement, HashMap<String, String> hashMap) throws SQLException, IOException {
                            Object object = this.getMetadataProperty(string, string2);
                            String string3 = object != null ? object.toString() : null;
                            return string3;
                        }

                        private Object getMetadataProperty(String string, String string2) {
                            Object object = null;
                            if (string.equalsIgnoreCase("hierarchy")) {
                                object = this.val$dimHier.getValue(string2);
                            }
                            if (string.equalsIgnoreCase("hierarchy_members")) {
                                int n = 0;
                                StringBuffer stringBuffer = new StringBuffer();
                                for (QDRData qDRData : this.val$qdrs2) {
                                    Object object2 = qDRData.getMemberKey();
                                    object2 = n == 0 ? "'" + (String)object2 + "'" : ",'" + (String)object2 + "'";
                                    stringBuffer.append((String)object2);
                                    ++n;
                                }
                                return stringBuffer;
                            }
                            return object;
                        }
                    };
                    object = ParamStringExpr.getInstance();
                    String string5 = ((ParamStringExpr)object).getExpression((String)object3, null, (ParamProperty)object2, null, null, null);
                    String string6 = dBUtil.executeReturnOneCol(string5, new ArrayList());
                    int n2 = Integer.valueOf(string6);
                    if (n2 != qDRDataArray.length) continue;
                    bl = true;
                    this.initialHierarchy = ((NamedObject)object5).getName();
                }
                catch (SQLException sQLException) {
                    this.LOG.log(Level.SEVERE, sQLException.getLocalizedMessage(), sQLException);
                }
                catch (IOException iOException) {
                    this.LOG.log(Level.SEVERE, iOException.getLocalizedMessage(), iOException);
                }
            }
        } else {
            try {
                arrayList.add(new HierarchyET(this.conn, dimension, null));
            }
            catch (SQLException sQLException) {
                this.LOG.log(Level.SEVERE, sQLException.getLocalizedMessage(), sQLException);
            }
            catch (IOException iOException) {
                this.LOG.log(Level.SEVERE, iOException.getLocalizedMessage(), iOException);
            }
        }
        if (arrayList.size() > 0) {
            try {
                String string7 = this.initialHierarchy;
                if (this.initialHierarchy == null) {
                    string7 = dimension.getDefaultHierarchy().getName();
                }
                HierarchyViewerDialog hierarchyViewerDialog = new HierarchyViewerDialog((Window)ideMainWindow, string2, arrayList, string7, oLAPResources, "SELECT_DIMENSION_MEMBERS_MODE", qDRDataArray);
                hierarchyViewerDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
                object6 = new Dimension(350, 400);
                hierarchyViewerDialog.setPreferredSize((Dimension)object6);
                hierarchyViewerDialog.setSize((Dimension)object6);
                hierarchyViewerDialog.setVisible(true);
                boolean bl = hierarchyViewerDialog.isOKSelected();
                if (bl && (object5 = hierarchyViewerDialog.getTree().getSelectionPath()) != null) {
                    object4 = ((TreePath)object5).getLastPathComponent();
                    object3 = (DefaultNode)object4;
                    object2 = (HierarchyNodeData)((DefaultNode)object3).getUserObject();
                    object = new QDRData(string, ((HierarchyNodeData)object2).dimKey, ((HierarchyNodeData)object2).desc);
                    this.model.setRowValue((QDRData)object, n);
                }
            }
            catch (Exception exception) {
                oLAPErrorDisplay.show(exception, OLAPArb.get("DIMENSION_MEMBER_SELECTOR_HVIEWER_ERROR"), OLAPArb.get("DIMENSION_MEMBER_SELECTOR_HVIEWER_ERROR_TITLE"), this);
                this.LOG.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
            }
        } else {
            MessageDialog.error((Component)this, (Object)OLAPArb.get("DIMENSION_MEMBER_SELECTOR_NOT_FOUND"), (String)OLAPArb.get("DIMENSION_MEMBER_SELECTOR_HVIEWER_ERROR_TITLE"), null);
        }
    }

    class SearchButton
    extends TableCellButtonWrapper {
        SearchButton(TableCellRenderer tableCellRenderer) {
            super(tableCellRenderer, OracleIcons.getIcon((String)"edit.png"));
        }

        SearchButton(TableCellEditor tableCellEditor) {
            super(tableCellEditor, OracleIcons.getIcon((String)"edit.png"));
        }

        @Override
        public void buttonPress() {
            QDRPanel.this.showSelector(this.getRow());
        }
    }

    class DeleteButton
    extends TableCellButtonWrapper {
        DeleteButton(TableCellRenderer tableCellRenderer) {
            super(tableCellRenderer, OracleIcons.getIcon((String)"delete.png"));
        }

        DeleteButton(TableCellEditor tableCellEditor) {
            super(tableCellEditor, OracleIcons.getIcon((String)"delete.png"));
        }

        @Override
        public void buttonPress() {
            QDRPanel.this.model.setValueAt(null, this.getRow(), this.getColumn());
        }
    }
}

