/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.syntaxbuilder.details;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.olap.app.olapmetadata.Measure;

public class CalculatedMeasureTablePanel
extends JPanel {
    private List<Measure> measures;
    private ResultSetTable table;

    public CalculatedMeasureTablePanel(List<Measure> list, TableModel tableModel) {
        this.measures = list;
        this.init(tableModel);
    }

    private void init(TableModel tableModel) {
        this.table = new ResultSetTable();
        this.table.setModel(tableModel);
        this.populateTable();
        this.layoutComponents();
    }

    private void populateTable() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        if (this.measures != null && !this.measures.isEmpty()) {
            for (Measure measure : this.measures) {
                Object[] objectArray;
                if (measure.getType().equals("DERIVED")) {
                    objectArray = new Object[]{measure.getCube().getName(), measure.getName(), measure.getDescription(), measure.getShortDescription(), measure.getDescription(), measure.getExpression()};
                    defaultTableModel.addRow(objectArray);
                    continue;
                }
                if (!measure.getType().equals("BASE")) continue;
                objectArray = new Object[]{measure.getCube().getName(), measure.getName(), measure.getDescription(), measure.getShortDescription(), measure.getDescription(), ""};
                defaultTableModel.addRow(objectArray);
            }
        }
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane((Component)this.table);
        this.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 1, 1));
    }

    private void clearTable() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        while (defaultTableModel.getRowCount() > 0) {
            defaultTableModel.removeRow(defaultTableModel.getRowCount() - 1);
        }
    }

    public void refresh(List<Measure> list) {
        this.measures = list;
        this.clearTable();
        this.populateTable();
    }
}

