/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.security;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.dbtools.db.DBUtil;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.olap.OLAPArb;
import oracle.olap.OLAPImagesArb;
import oracle.olap.OLAPResources;
import oracle.olap.app.Resources;
import oracle.olap.app.tree.model.CheckTreeSelectionModel;
import oracle.olap.app.tree.view.CheckTreeManager;
import oracle.olap.app.tree.view.JTree2;
import oracle.olap.security.AccessControlList;
import oracle.olap.security.ORASUtil;

public class UserSelectionDialog
extends JDialog
implements SearchListener {
    private Icon ICON_USER = OLAPImagesArb.getIcon("SCHEMA");
    private Icon ICON_FOLDER = OLAPImagesArb.getIcon("SCHEMA_FOLDER");
    protected JTree2 m_tree;
    protected DefaultTreeModel m_model;
    private CheckTreeManager checkTreeManager;
    private Connection conn;
    protected TreePath m_clickedPath;
    private JLabel descriptionLabel;
    private JLabel filterLabel;
    private SearchField searchField;
    private JButton okButton;
    private JButton cancelButton;
    private JButton helpButton;
    private Action cancelAction;
    private Action createAction;
    private Action helpAction;
    private List<UserNode> selection;
    private List<String> skipUsers;
    private List<String> skipRoles;
    private List<String> skipDSACLs;
    private boolean isDSACLDisplayed;
    Resources resources = new OLAPResources();

    public UserSelectionDialog(Connection connection, Window window) {
        this(connection, window, null, null, null, false);
    }

    public UserSelectionDialog(Connection connection, Window window, List<String> list, List<String> list2, List<String> list3, boolean bl) {
        super(window);
        this.setName("UserSelectionDialog");
        this.setTitle(this.resources.getString("USER_SELECTION_DIALOG_TITLE"));
        this.setModal(true);
        this.setLocationRelativeTo(window);
        this.conn = connection;
        this.skipUsers = list;
        this.skipRoles = list2;
        this.skipDSACLs = list3;
        this.isDSACLDisplayed = bl;
        this.layoutComponents();
    }

    private void layoutComponents() {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(this.resources.getString("USER_SELECTION_DIALOG_ROOT_NODE"));
        try {
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            serializable = new DefaultMutableTreeNode(new IconData(this.ICON_FOLDER, this.resources.getString("USER_SELECTION_DIALOG_USERS_NODE")));
            defaultMutableTreeNode.add((MutableTreeNode)((Object)serializable));
            object3 = DBUtil.getInstance((Connection)this.conn);
            object2 = object3.executeReturnList("select username from all_users order by username", null);
            object = object2.iterator();
            while (object.hasNext()) {
                object7 = (Map)object.next();
                object6 = (String)object7.get("USERNAME");
                if (this.skipUsers != null && this.skipUsers.contains(object6)) continue;
                ((DefaultMutableTreeNode)serializable).add(new UserNode(new IconData(this.ICON_USER, object6), 1));
            }
            object = new DefaultMutableTreeNode(new IconData(this.ICON_FOLDER, this.resources.getString("USER_SELECTION_DIALOG_ROLES_NODE")));
            defaultMutableTreeNode.add((MutableTreeNode)object);
            object7 = object3.executeReturnList("select role from dba_roles order by role", null);
            object6 = object7.iterator();
            while (object6.hasNext()) {
                object5 = (Map)object6.next();
                object4 = (String)object5.get("ROLE");
                if (this.skipRoles != null && this.skipRoles.contains(object4)) continue;
                ((DefaultMutableTreeNode)object).add(new UserNode(new IconData(this.ICON_USER, object4), 2));
            }
            if (this.isDSACLDisplayed) {
                object6 = new DefaultMutableTreeNode(new IconData(this.ICON_FOLDER, this.resources.getString("USER_SELECTION_DIALOG_DSACLS_NODE")));
                defaultMutableTreeNode.add((MutableTreeNode)object6);
                object5 = ORASUtil.getInstance();
                object4 = ((ORASUtil)object5).getACLDOsInDataSecurityRolesClass(this.conn);
                Iterator iterator = object4.iterator();
                while (iterator.hasNext()) {
                    AccessControlList accessControlList = (AccessControlList)iterator.next();
                    String string = accessControlList.getName();
                    if (this.skipDSACLs != null && this.skipDSACLs.contains(string)) continue;
                    IconData iconData = new IconData(this.ICON_USER, string);
                    UserNode userNode = new UserNode(iconData, 3);
                    ((DefaultMutableTreeNode)object6).add(userNode);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.selection = new ArrayList<UserNode>();
        this.m_model = new DefaultTreeModel(defaultMutableTreeNode);
        this.m_tree = new JTree2(this.m_model);
        this.m_tree.putClientProperty("JTree.lineStyle", "Angled");
        serializable = new IconCellRenderer();
        this.m_tree.setCellRenderer((TreeCellRenderer)((Object)serializable));
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.setShowsRootHandles(true);
        this.m_tree.setEditable(false);
        object3 = new CheckTreeSelectionModel(this.m_tree.getModel());
        this.checkTreeManager = new CheckTreeManager(this.m_tree, new CheckTreeCellRenderer(this.m_tree.getCellRenderer(), (CheckTreeSelectionModel)object3), (CheckTreeSelectionModel)object3);
        this.descriptionLabel = new JLabel(OLAPArb.getString("USER_SELECTION_DIALOG_DESCRIPTION"));
        this.getContentPane().add((Component)this.descriptionLabel, "North");
        this.filterLabel = new JLabel();
        this.filterLabel.setName("filterLabel");
        this.searchField = new SearchField(SearchField.Style.FIND);
        this.searchField.setName("searchField");
        this.searchField.setAllowEmptySearch(true);
        this.searchField.addSearchListener((SearchListener)this);
        ResourceUtils.resLabel((JLabel)this.filterLabel, (Component)this.searchField, (String)OLAPArb.getString("SOURCE_SELECTION_DIALOG_FILTER_LABEL"));
        object2 = new JScrollPane();
        ((JScrollPane)object2).getViewport().add(this.m_tree);
        this.getContentPane().add((Component)object2, "Center");
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.createAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserNode userNode;
                Object object;
                TreePath[] treePathArray = UserSelectionDialog.this.checkTreeManager.getSelectionModel().getSelectionPaths();
                int n = 0;
                for (int i = 0; i < treePathArray.length; ++i) {
                    object = treePathArray[i];
                    if (!(((TreePath)object).getLastPathComponent() instanceof UserNode)) continue;
                    userNode = (UserNode)((TreePath)object).getLastPathComponent();
                    int n2 = userNode.getType();
                    if (n2 == 3) {
                        ++n;
                    }
                    UserSelectionDialog.this.selection.add(userNode);
                }
                if (n > 1 || n > 0 && UserSelectionDialog.this.skipDSACLs != null && UserSelectionDialog.this.skipDSACLs.size() > 0) {
                    UserSelectionDialog.this.selection.clear();
                    String string = OLAPArb.get("USERSELECTIONFILTERMODE_MULTISELECTION_MSG");
                    object = OLAPArb.get("USERSELECTIONFILTERMODE_MULTISELECTION_TITLE");
                    userNode = null;
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)object, (String)((Object)userNode));
                } else {
                    UserSelectionDialog.this.setVisible(false);
                }
            }
        };
        this.cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserSelectionDialog.this.selection.clear();
                UserSelectionDialog.this.dispose();
            }
        };
        this.helpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        this.cancelButton.setAction(this.cancelAction);
        this.cancelButton.setText(this.resources.getString("USER_SELECTION_DIALOG_CANCEL"));
        this.okButton.setAction(this.createAction);
        this.okButton.setText(this.resources.getString("USER_SELECTION_DIALOG_OK"));
        this.helpButton = new JButton();
        this.helpButton.setVisible(true);
        this.helpButton.setAction(this.helpAction);
        this.helpButton.setText(this.resources.getString("USER_SELECTION_DIALOG_HELP"));
        object = new DialogButtonBar();
        object.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_APPLY);
        object.add((Component)this.cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
        object.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
        this.getContentPane().add((Component)object, "South");
        this.setDefaultCloseOperation(1);
        this.pack();
    }

    public List<UserNode> getSelection() {
        return this.selection;
    }

    DefaultMutableTreeNode getTreeNode(TreePath treePath) {
        return (DefaultMutableTreeNode)treePath.getLastPathComponent();
    }

    public CheckTreeManager getCheckTreeManager() {
        return this.checkTreeManager;
    }

    public void searchPerformed(SearchEvent searchEvent) {
        String string = searchEvent.getSearchText();
    }

    public void searchCategoryChanged(SearchEvent searchEvent) {
    }

    class IconData {
        protected Icon m_icon;
        protected Icon m_expandedIcon;
        protected Object m_data;

        public IconData(Icon icon, Object object) {
            this.m_icon = icon;
            this.m_expandedIcon = null;
            this.m_data = object;
        }

        public IconData(Icon icon, Icon icon2, Object object) {
            this.m_icon = icon;
            this.m_expandedIcon = icon2;
            this.m_data = object;
        }

        public Icon getIcon() {
            return this.m_icon;
        }

        public Icon getExpandedIcon() {
            return this.m_expandedIcon != null ? this.m_expandedIcon : this.m_icon;
        }

        public Object getObject() {
            return this.m_data;
        }

        public String toString() {
            return this.m_data.toString();
        }
    }

    public class UserNode
    extends DefaultMutableTreeNode {
        protected String m_name;
        int type = 0;
        static final int USER_TYPE = 1;
        static final int ROLE_TYPE = 2;
        static final int DSACL_TYPE = 3;

        public UserNode(String string, int n) {
            this.m_name = string;
            this.type = n;
            this.setUserObject(this.m_name);
        }

        public UserNode(IconData iconData, int n) {
            this.m_name = (String)iconData.getObject();
            this.type = n;
            this.setUserObject(iconData);
        }

        public String getName() {
            return this.m_name;
        }

        @Override
        public String toString() {
            return this.m_name;
        }

        public int compareTo(UserNode userNode) {
            return this.m_name.compareToIgnoreCase(userNode.getName());
        }

        public void setType(int n) {
            this.type = n;
        }

        public int getType() {
            return this.type;
        }

        public boolean isUserType() {
            return this.type == 1;
        }
    }

    class IconCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        protected Color m_textSelectionColor = UIManager.getColor("Tree.selectionForeground");
        protected Color m_textNonSelectionColor = UIManager.getColor("Tree.textForeground");
        protected Color m_bkSelectionColor = UIManager.getColor("Tree.selectionBackground");
        protected Color m_bkNonSelectionColor = UIManager.getColor("Tree.textBackground");
        protected Color m_borderSelectionColor = UIManager.getColor("Tree.selectionBorderColor");
        protected boolean m_selected;

        public IconCellRenderer() {
            this.setOpaque(false);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            this.setText(object2.toString());
            if (object2 instanceof IconData) {
                IconData iconData = (IconData)object2;
                if (bl2) {
                    this.setIcon(iconData.getExpandedIcon());
                } else {
                    this.setIcon(iconData.getIcon());
                }
            } else {
                this.setIcon(null);
            }
            this.setFont(jTree.getFont());
            this.setForeground(bl ? this.m_textSelectionColor : this.m_textNonSelectionColor);
            this.setBackground(bl ? this.m_bkSelectionColor : this.m_bkNonSelectionColor);
            this.m_selected = bl;
            return this;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Color color = this.getBackground();
            Icon icon = this.getIcon();
            graphics.setColor(color);
            int n = 0;
            if (icon != null && this.getText() != null) {
                n = icon.getIconWidth() + this.getIconTextGap();
            }
            graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            if (this.m_selected) {
                graphics.setColor(this.m_borderSelectionColor);
                graphics.drawRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            }
            super.paintComponent(graphics);
        }
    }

    public class CheckTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        static final long serialVersionUID = 0L;
        CheckTreeSelectionModel selectionModel;
        private TreeCellRenderer delegate;
        JCheckBox checkBox = new JCheckBox();

        public CheckTreeCellRenderer(TreeCellRenderer treeCellRenderer, CheckTreeSelectionModel checkTreeSelectionModel) {
            this.delegate = treeCellRenderer;
            this.selectionModel = checkTreeSelectionModel;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.checkBox.setOpaque(false);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = this.delegate.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            TreePath treePath = jTree.getPathForRow(n);
            if (treePath != null) {
                if (this.selectionModel.isPathSelected(treePath, true)) {
                    this.checkBox.setSelected(true);
                } else {
                    this.checkBox.setSelected(false);
                }
            }
            this.removeAll();
            if (object instanceof UserNode) {
                this.add((Component)this.checkBox, "West");
            }
            this.add(component, "Center");
            return this;
        }

        public TreeCellRenderer getDelegate() {
            return this.delegate;
        }

        public void setDelegate(TreeCellRenderer treeCellRenderer) {
            this.delegate = treeCellRenderer;
        }
    }
}

