/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.measure;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.tree.model.DefaultTreeTableModel;
import oracle.olap.app.tree.model.TreeTable;
import oracle.olap.app.tree.model.TreeTableModel;
import oracle.olap.app.tree.view.AbstractCellEditor;
import oracle.olap.app.tree.view.NodeIcon;
import oracle.olap.app.tree.view.TreeTableModelAdapter;
import oracle.olap.measure.CheckTreeCellRenderer;
import oracle.olap.measure.MeasureSelectorNode;
import oracle.olap.measurefolder.model.MeasureID;
import oracle.olap.navigator.OLAPNavigatorResource;

public class CheckBoxTreeTable
extends JTable {
    private TreeTableCellRenderer jTree;
    private TreeTableModel treeTableModel;
    private List<String> filters = new ArrayList<String>();
    private boolean isSingleSelectionMode = false;

    public CheckBoxTreeTable() {
        this.init();
    }

    public CheckBoxTreeTable(TreeTableModel treeTableModel) {
        this.treeTableModel = treeTableModel;
        this.init();
        this.setModel(treeTableModel);
    }

    public CheckBoxTreeTable(TreeTableModel treeTableModel, boolean bl) {
        this.treeTableModel = treeTableModel;
        this.isSingleSelectionMode = bl;
        this.init();
        this.setModel(treeTableModel);
    }

    private void init() {
        this.setCellSelectionEnabled(true);
        this.jTree = new TreeTableCellRenderer(this.treeTableModel);
        this.jTree.setSelectionModel(new DefaultTreeSelectionModel(){
            {
                CheckBoxTreeTable.this.setSelectionModel(this.listSelectionModel);
            }
        });
        if (this.isSingleSelectionMode) {
            this.getSelectionModel().setSelectionMode(1);
            this.jTree.getSelectionModel().setSelectionMode(1);
        }
        this.jTree.setRowHeight(this.getRowHeight());
        this.jTree.setShowsRootHandles(true);
        this.setDefaultRenderer(TreeTableModel.class, this.jTree);
        TreeTableCellEditor treeTableCellEditor = new TreeTableCellEditor();
        this.setDefaultEditor(TreeTableModel.class, treeTableCellEditor);
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
    }

    public void setModel(TreeTableModel treeTableModel) {
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.jTree));
        this.jTree.setModel(treeTableModel);
        Object object = treeTableModel.getRoot();
        if (object != null) {
            this.jTree.setRootVisible(false);
        }
        if (this.getParent() != null) {
            this.getParent().invalidate();
        }
        this.invalidate();
    }

    public void setModel(TreeTable treeTable) {
        this.treeTableModel = new DefaultTreeTableModel(treeTable);
        this.setModel(this.treeTableModel);
    }

    public void expandAll(boolean bl) {
        for (int i = 0; i < this.jTree.getRowCount(); ++i) {
            if (bl) {
                this.jTree.expandRow(i);
                continue;
            }
            this.jTree.collapseRow(i);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.jTree != null) {
            this.jTree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    private int realEditingRow() {
        return this.editingRow;
    }

    @Override
    public void sizeColumnsToFit(int n) {
        super.sizeColumnsToFit(n);
        if (this.getEditingColumn() != -1 && this.getColumnClass(this.editingColumn) == TreeTableModel.class) {
            Rectangle rectangle = this.getCellRect(this.realEditingRow(), this.getEditingColumn(), false);
            Component component = this.getEditorComponent();
            component.setBounds(rectangle);
            component.validate();
        }
    }

    @Override
    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.jTree != null && this.jTree.getRowHeight() != n) {
            this.jTree.setRowHeight(this.getRowHeight());
        }
    }

    public List<MeasureID> getSelection() {
        MeasureSelectorNode measureSelectorNode = (MeasureSelectorNode)this.jTree.getModel().getRoot();
        if (measureSelectorNode == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Measure> arrayList = new ArrayList<Measure>();
        this.visitAllNodes(measureSelectorNode, arrayList);
        ArrayList<MeasureID> arrayList2 = new ArrayList<MeasureID>();
        for (Measure measure : arrayList) {
            String string = String.format("%s.%s", measure.getCube().getName(), measure.getName());
            arrayList2.add(new MeasureID(string));
        }
        return arrayList2;
    }

    private void visitAllNodes(MeasureSelectorNode measureSelectorNode, List<Measure> list) {
        if ((measureSelectorNode.getType().equalsIgnoreCase(MeasureSelectorNode.MEASURE) || measureSelectorNode.getType().equalsIgnoreCase(MeasureSelectorNode.DERIVED_MEASURE)) && measureSelectorNode.isSelected()) {
            list.add(measureSelectorNode.getMeasure());
        }
        for (Object object : Arrays.asList(measureSelectorNode.getChildren())) {
            this.visitAllNodes((MeasureSelectorNode)object, list);
        }
    }

    public void setSelection(List<MeasureID> list) {
        block0: for (int i = 0; i < this.getRowCount(); ++i) {
            TreePath treePath = this.jTree.getPathForRow(i);
            MeasureSelectorNode measureSelectorNode = (MeasureSelectorNode)treePath.getLastPathComponent();
            Measure measure = measureSelectorNode.getMeasure();
            if (measure == null) continue;
            String string = String.format("%s.%s", measure.getCube().getName(), measure.getName());
            for (MeasureID measureID : list) {
                if (!measureID.getName().equals(string)) continue;
                this.jTree.getSelectionModel().addSelectionPath(treePath);
                continue block0;
            }
        }
    }

    private void filterNodes(MeasureSelectorNode measureSelectorNode) {
        if (measureSelectorNode.getType().equalsIgnoreCase(MeasureSelectorNode.MEASURE_FOLDER) || measureSelectorNode.getType().equalsIgnoreCase(MeasureSelectorNode.DERIVED_FOLDER)) {
            measureSelectorNode.clearChildren();
            for (Measure object : measureSelectorNode.getMeasures()) {
                if (!this.passFilter(object)) continue;
                measureSelectorNode.addMeasureNode(object);
            }
        }
        for (Object object : Arrays.asList(measureSelectorNode.getChildren())) {
            this.filterNodes((MeasureSelectorNode)object);
        }
    }

    private boolean passFilter(Measure measure) {
        String string = measure.getName().toUpperCase();
        for (String string2 : this.filters) {
            if (!((string2 = string2.trim().toUpperCase()).endsWith("%") ? string.startsWith(string2.substring(0, string2.length() - 1)) : (string2.startsWith("%") ? string.endsWith(string2.substring(1)) : string.contains(string2)))) continue;
            return true;
        }
        return false;
    }

    public void filter(String string) {
        this.filters = Arrays.asList(string.split(","));
        if (this.filters.size() > 0) {
            MeasureSelectorNode measureSelectorNode = (MeasureSelectorNode)this.treeTableModel.getRoot();
            this.filterNodes(measureSelectorNode);
            this.updateUI();
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        private int visibleRow;

        public TreeTableCellRenderer(TreeModel treeModel) {
            super(treeModel);
            NodeIcon nodeIcon = new NodeIcon(){
                private Icon m_cubeIcon = OLAPNavigatorResource.getIcon("OLAPCUBE_ICON");
                private Icon m_measureIcon = OLAPNavigatorResource.getIcon("OLAPMEASURE_ICON");
                private Icon m_derivedMeasureIcon = OLAPNavigatorResource.getIcon("OLAPCALCMEASURE_ICON");
                private Icon m_cubeFolderIcon = OLAPNavigatorResource.getIcon("OLAPCUBE_FOLDER_ICON");
                private Icon m_measureFolderIcon = OLAPNavigatorResource.getIcon("OLAPMEASUREFOLDER_FOLDER_ICON");
                private Icon m_derivedFolderIcon = OLAPNavigatorResource.getIcon("OLAPCALCMEASURE_FOLDER_ICON");

                @Override
                public Icon getIcon(Object object) {
                    MeasureSelectorNode measureSelectorNode = (MeasureSelectorNode)object;
                    if (measureSelectorNode.getType().equalsIgnoreCase(MeasureSelectorNode.DERIVED_MEASURE)) {
                        return this.m_derivedMeasureIcon;
                    }
                    if (measureSelectorNode.getType().equalsIgnoreCase(MeasureSelectorNode.MEASURE)) {
                        return this.m_measureIcon;
                    }
                    if (measureSelectorNode.getType().equalsIgnoreCase(MeasureSelectorNode.CUBE_FOLDER)) {
                        return this.m_cubeFolderIcon;
                    }
                    if (measureSelectorNode.getType().equalsIgnoreCase(MeasureSelectorNode.CUBE)) {
                        return this.m_cubeIcon;
                    }
                    if (measureSelectorNode.getType().equalsIgnoreCase(MeasureSelectorNode.MEASURE_FOLDER)) {
                        return this.m_measureFolderIcon;
                    }
                    if (measureSelectorNode.getType().equalsIgnoreCase(MeasureSelectorNode.DERIVED_FOLDER)) {
                        return this.m_derivedFolderIcon;
                    }
                    return null;
                }

                @Override
                public Icon getDisabledIcon(Object object) {
                    return null;
                }
            };
            this.setCellRenderer(new CheckTreeCellRenderer(this.getCellRenderer(), nodeIcon));
        }

        public void setModel(TreeTableModel treeTableModel) {
            super.setModel(treeTableModel);
            this.updateUI();
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, 0, n3, CheckBoxTreeTable.this.getHeight());
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(graphics);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.visibleRow = n;
            return CheckBoxTreeTable.this.jTree;
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return CheckBoxTreeTable.this.jTree;
        }
    }
}

