/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.hierarchyviewer;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.olapmetadata.DimensionHierarchy;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.table.Queries;
import oracle.olap.app.templates.templatelist.QDRData;
import oracle.olap.app.templates.templateview.ItemElement;
import oracle.olap.app.tree.model.DefaultNode;
import oracle.olap.app.tree.model.HierarchyNodeData;
import oracle.olap.hierarchyviewer.DimensionLoader;
import oracle.olap.stringexpr.ParamProperty;
import oracle.olap.stringexpr.ParamStringExpr;
import oracle.olap.stringexpr.ParamValue;

public class HierarchyLoader
extends DimensionLoader
implements ParamValue,
ParamProperty {
    private int rowNum;
    private DimensionHierarchy dimensionHierarchy;
    private QDRData[] qdrs;
    private List<QDRData> hierarchyMembers;
    private List<QDRData> hierarchyParentMembers;
    private ParamStringExpr paramStringExpr;
    private static Queries queries;
    private static final String XMLFILE = "hierarchyloaderqueries.xml";
    private static final Logger LOG;
    final String DEPTH = "depth";
    final String KEY = "key";
    final String PARENT = "parent";
    final String DESCRIPTION = "description";

    public HierarchyLoader(Connection connection, DimensionHierarchy dimensionHierarchy) throws SQLException {
        super(connection, dimensionHierarchy.getViewName());
        this.dimensionHierarchy = dimensionHierarchy;
        this.rowNum = 1;
        this.paramStringExpr = ParamStringExpr.getInstance();
    }

    private String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = "oracle.olap.app.table";
                String string3 = JavaXMLBind.LoadDocument(this.getClass(), XMLFILE);
                JavaXMLBind.BindToJavaStr(string3, string2, this);
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        HierarchyLoader.queries = queries;
    }

    @Override
    public void loadData() throws SQLException, IOException {
        this.column = this.checkAttributes();
        if (this.column != null) {
            this.useDescription = true;
        }
        this.loadData1();
    }

    public void loadData(QDRData[] qDRDataArray) throws SQLException, IOException {
        this.column = this.checkAttributes();
        if (this.column != null) {
            this.useDescription = true;
        }
        this.loadData1(qDRDataArray);
    }

    @Override
    String checkAttributes() throws SQLException, IOException {
        String string = null;
        String string2 = "{hierarchy.displayColumnName}";
        string = this.paramStringExpr.getExpression(string2, this, this, null, null, null);
        return string;
    }

    private void loadData1() throws SQLException {
        this.loadData1(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadData1(QDRData[] qDRDataArray) throws SQLException {
        Object object;
        Object object2;
        this.qdrs = qDRDataArray;
        this.setLoadingState(true);
        String string = null;
        String string2 = null;
        if (qDRDataArray != null) {
            this.hierarchyMembers = new ArrayList<QDRData>();
            for (QDRData qDRData : qDRDataArray) {
                if (this.hierarchyMembers.contains(qDRData)) continue;
                this.hierarchyMembers.add(qDRData);
            }
            object2 = null;
            try {
                QDRData qDRData;
                object = null;
                String string3 = null;
                qDRData = null;
                Connections.getInstance().lock(this.connection);
                if (this.dimensionHierarchy.isLevelBased()) {
                    string3 = this.getQuery("member_key_level_lineage");
                    object = this.paramStringExpr.getExpression(string3, this, this, null, null, null);
                    String string4 = "$oexpr[loop({hierarchyLevels}, {levelColumnName})]$";
                    Object object3 = this.paramStringExpr.evaluateObjectExprs(string4, this);
                    List list = new ArrayList();
                    if (object3 != null && object3 instanceof List) {
                        list = (List)object3;
                    }
                    object2 = this.dbUtil.executeQuery((String)object, (Map)((Object)qDRData));
                    object2.setFetchSize(3000);
                    while (object2.next()) {
                        for (String string5 : list) {
                            String string6 = object2.getString(string5);
                            if (string6 == null) continue;
                            boolean bl = false;
                            for (QDRData qDRData2 : this.hierarchyMembers) {
                                String string7 = qDRData2.getMemberKey();
                                if (!string7.equalsIgnoreCase(string6)) continue;
                                bl = true;
                            }
                            if (bl) continue;
                            QDRData qDRData3 = new QDRData(this.dimensionHierarchy, string6, "");
                            this.hierarchyMembers.add(qDRData3);
                        }
                    }
                } else {
                    string3 = this.getQuery("member_key_parentage");
                    object = this.paramStringExpr.getExpression(string3, this, this, null, null, null);
                    boolean bl = true;
                    while (bl) {
                        object2 = this.dbUtil.executeQuery((String)object, (Map)((Object)qDRData));
                        object2.setFetchSize(3000);
                        this.hierarchyParentMembers = new ArrayList<QDRData>();
                        while (object2.next()) {
                            String string8 = object2.getString("parent");
                            if (string8 == null) continue;
                            boolean bl2 = false;
                            for (QDRData qDRData4 : this.hierarchyMembers) {
                                String string9 = qDRData4.getMemberKey();
                                if (!string9.equalsIgnoreCase(string8)) continue;
                                bl2 = true;
                            }
                            if (bl2) continue;
                            QDRData qDRData5 = new QDRData(this.dimensionHierarchy, string8, "");
                            this.hierarchyMembers.add(qDRData5);
                            this.hierarchyParentMembers.add(qDRData5);
                        }
                        if (this.hierarchyParentMembers.size() == 0) {
                            bl = false;
                            continue;
                        }
                        string3 = this.getQuery("parent_member_key_parentage");
                        object = this.paramStringExpr.getExpression(string3, this, this, null, null, null);
                    }
                }
            }
            catch (Exception exception) {
                oracle.dbtools.util.Logger.warn(HierarchyLoader.class, (Throwable)exception);
            }
            finally {
                DBUtil.closeResultSet((ResultSet)object2);
                Connections.getInstance().unlock(this.connection);
            }
            string2 = this.useDescription ? this.getQuery("selected_member_keys_with_descriptions") : this.getQuery("selected_member_keys");
        } else {
            string2 = this.useDescription ? this.getQuery("all_member_keys_with_descriptions") : this.getQuery("all_member_keys");
        }
        try {
            string = this.paramStringExpr.getExpression(string2, this, this, null, null, null);
        }
        catch (Exception exception) {
            oracle.dbtools.util.Logger.warn(HierarchyLoader.class, (Throwable)exception);
        }
        object2 = string;
        object = new Runnable(){
            final /* synthetic */ String val$sql;
            {
                this.val$sql = string;
            }

            @Override
            public void run() {
                try {
                    HierarchyLoader.this.loadTree(this.val$sql);
                }
                catch (Throwable throwable) {
                    oracle.dbtools.util.Logger.severe(HierarchyLoader.class, (Throwable)throwable);
                }
                finally {
                    HierarchyLoader.this.setLoadingState(false);
                }
            }
        };
        Thread thread = new Thread((Runnable)object);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            oracle.dbtools.util.Logger.warn(HierarchyLoader.class, (Throwable)interruptedException);
        }
    }

    private void loadTree(String string) throws SQLException {
        Map map = null;
        ResultSet resultSet = null;
        try {
            Connections.getInstance().lock(this.connection);
            resultSet = this.dbUtil.executeQuery(string, map);
            resultSet.setFetchSize(3000);
            int n = -1;
            int n2 = -1;
            while (resultSet.next()) {
                HierarchyNodeData hierarchyNodeData = new HierarchyNodeData(this.getTree());
                hierarchyNodeData.dimKey = resultSet.getString("key");
                hierarchyNodeData.parent = resultSet.getString("parent");
                n2 = resultSet.getInt("depth");
                if (this.useDescription) {
                    hierarchyNodeData.desc = resultSet.getString("description");
                }
                this.load(hierarchyNodeData, hierarchyNodeData, n2);
                ++this.rowNum;
                if (n2 == n) continue;
                this.setFinishedLoadingDepth(n);
                n = n2;
            }
        }
        catch (SQLException sQLException) {
            try {
                throw sQLException;
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(this.connection);
                throw throwable;
            }
        }
        DBUtil.closeResultSet((ResultSet)resultSet);
        Connections.getInstance().unlock(this.connection);
        this.getTree().setCount(this.rowNum);
    }

    @Override
    public void loadChildren(Object object) {
        if (object instanceof DefaultNode) {
            Object object2;
            this.setLoadingState(true);
            DefaultNode defaultNode = (DefaultNode)object;
            String string = null;
            if (defaultNode.getUserObject() instanceof String) {
                string = (String)defaultNode.getUserObject();
            } else {
                object2 = (HierarchyNodeData)defaultNode.getUserObject();
                string = ((HierarchyNodeData)object2).getName();
            }
            object2 = null;
            String string2 = null;
            string2 = this.useDescription ? String.format(this.getQuery("child_member_keys_with_descriptions"), string) : String.format(this.getQuery("child_member_keys"), string);
            try {
                object2 = this.paramStringExpr.getExpression(string2, this, this, null, null, null);
            }
            catch (Exception exception) {
                oracle.dbtools.util.Logger.warn(HierarchyLoader.class, (Throwable)exception);
            }
            HierarchyNodeData hierarchyNodeData = object2;
            Runnable runnable = new Runnable(){
                final /* synthetic */ String val$sql;
                {
                    this.val$sql = string;
                }

                @Override
                public void run() {
                    try {
                        HierarchyLoader.this.loadChildrenData(this.val$sql);
                    }
                    catch (SQLException sQLException) {
                        oracle.dbtools.util.Logger.severe(HierarchyLoader.class, (Throwable)sQLException);
                    }
                    finally {
                        HierarchyLoader.this.setLoadingState(false);
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                oracle.dbtools.util.Logger.warn(HierarchyLoader.class, (Throwable)interruptedException);
            }
        }
    }

    public void loadChildrenData(String string) throws SQLException {
        Map map = null;
        ResultSet resultSet = null;
        try {
            Connections.getInstance().lock(this.connection);
            resultSet = this.dbUtil.executeQuery(string, map);
            resultSet.setFetchSize(3000);
            int n = -1;
            while (resultSet.next()) {
                HierarchyNodeData hierarchyNodeData = new HierarchyNodeData(this.getTree());
                hierarchyNodeData.dimKey = resultSet.getString("key");
                hierarchyNodeData.parent = resultSet.getString("parent");
                n = resultSet.getInt("depth");
                if (this.useDescription) {
                    hierarchyNodeData.desc = resultSet.getString("description");
                }
                this.load(hierarchyNodeData, hierarchyNodeData, n);
                ++this.rowNum;
            }
        }
        catch (SQLException sQLException) {
            try {
                throw sQLException;
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(this.connection);
                throw throwable;
            }
        }
        DBUtil.closeResultSet((ResultSet)resultSet);
        Connections.getInstance().unlock(this.connection);
        this.getTree().setCount(this.rowNum);
    }

    @Override
    public Object getValue(String string) throws SQLException, IOException {
        List<ParamValue> list = null;
        if (string.equalsIgnoreCase("hierarchyLevels")) {
            list = this.dimensionHierarchy.getHierarchyLevels();
        }
        if (string.equalsIgnoreCase("hierarchy_members")) {
            list = this.hierarchyMembers;
        }
        if (string.equalsIgnoreCase("hierarchy_parent_members")) {
            list = this.hierarchyParentMembers;
        }
        return list;
    }

    @Override
    public String getParamPropertyValue(String string, String string2, Measure measure, ItemElement itemElement, HashMap<String, String> hashMap) throws SQLException, IOException {
        Object object = this.getMetadataProperty(string, string2);
        String string3 = object != null ? object.toString() : null;
        return string3;
    }

    private Object getMetadataProperty(String string, String string2) {
        Object object = null;
        if (string.equalsIgnoreCase("hierarchy")) {
            object = this.dimensionHierarchy.getValue(string2);
        }
        return object;
    }

    static {
        LOG = Logger.getLogger(HierarchyLoader.class.getName());
    }
}

