/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.eif;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressBar;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.actions.ExportToEIFRunnable;
import oracle.olap.eif.ExportToEIFDialog;

public class ExportToEIF {
    private static ExportToEIF INSTANCE;
    private static final Logger LOGGER;

    private ExportToEIF() {
    }

    public static ExportToEIF getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ExportToEIF();
        }
        return INSTANCE;
    }

    public void launchDialog(DBObject dBObject) {
        Connection connection = dBObject.getConnection();
        String string = dBObject.getSchemaName();
        String string2 = dBObject.getObjectName();
        String string3 = null;
        String string4 = null;
        ExportToEIFDialog exportToEIFDialog = new ExportToEIFDialog((Frame)Ide.getMainWindow(), connection, string, string2);
        exportToEIFDialog.setMinimumSize(new Dimension(400, 150));
        exportToEIFDialog.setLocationRelativeTo((Component)Ide.getMainWindow());
        exportToEIFDialog.setVisible(true);
        if (exportToEIFDialog.isOKSelected()) {
            string3 = exportToEIFDialog.getEIFFileName();
            string4 = exportToEIFDialog.getDirectoryName();
        }
        if (string4 != null && string3 != null) {
            this.exportToEIFFile(connection, string, string2, string4, string3);
        }
    }

    private void exportToEIFFile(Connection connection, String string, String string2, String string3, String string4) {
        try {
            ExportToEIFRunnable exportToEIFRunnable = new ExportToEIFRunnable(connection, string, string2, string3, string4);
            String string5 = OLAPArb.get("EIF_EXPORT_PROGRESSBAR_TITLE");
            string5 = MessageFormat.format(string5, "");
            ProgressBar progressBar = new ProgressBar((Component)Ide.getMainWindow(), string5, (Runnable)exportToEIFRunnable, true);
            progressBar.setCancelable(false);
            exportToEIFRunnable.setProgressBar(progressBar);
            progressBar.start(OLAPArb.get("EIF_EXPORT_PROGRESSBAR_WAIT_MSG"), null);
            if (exportToEIFRunnable.getException() != null) {
                throw exportToEIFRunnable.getException();
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            String string6 = null;
            String string7 = exception.getLocalizedMessage();
            if (string7 == null || string7.length() == 0) {
                string7 = exception.getClass().toString();
            }
            String string8 = OLAPArb.get("EIF_EXPORT_ERROR_TITLE");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string7, (String)string8, string6);
        }
    }

    static {
        LOGGER = Logger.getLogger(ExportToEIF.class.getName());
    }
}

