/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.dml;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.db.DBUtil;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.app.ui.RestrictedTextField;
import oracle.olap.dml.DMLProgram;
import oracle.olap.dml.editor.language.OLAPKeywords;

public class NewDMLProgramDialog
extends JDialog
implements ActionListener {
    private NewDMLProgramDialog currentInstance = null;
    private String owner = null;
    private String awName = null;
    private Connection conn = null;
    private DMLProgram program = null;
    private final String PROGRAM_LIST_SQL = "select * from (\n                SELECT DISTINCT obj_id, obj_name\n                FROM all_aw_obj\n                WHERE owner = :OWNER\n                AND aw_name = :AW_NAME\n                AND obj_type=35 and obj_name not in ('ONATTACH'))";
    private final String DIMENSION_LIST_SQL = "select DIMENSION_NAME from all_cube_dimensions where owner = :OWNER and aw_name = :AW_NAME order by dimension_name";
    private final String DEFAULT_PROGRAM_NAME = "PROGRAM";
    private final String DEFAULT_DATATYPE = "NUMBER";
    private final String OK_COMMAND = "OK_ID";
    private final String CANCEL_COMMAND = "CANCEL_ID";
    private final String HELP_COMMAND = "HELP_ID";
    private boolean m_clickedOK = false;
    private JPanel mainPanel = new JPanel(new GridBagLayout());
    private JButton m_btnOK = new JButton(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_OK_BUTTON_TEXT")));
    private JButton m_btnCancel = new JButton(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_CANCEL_BUTTON_TEXT")));
    private JButton m_btnHelp = new JButton(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_HELP_BUTTON_TEXT")));
    private JLabel nameLabel = new JLabel();
    private RestrictedTextField nameTextField = new RestrictedTextField();
    private JLabel ldLabel = new JLabel();
    private RestrictedTextField ldTextField = new RestrictedTextField();
    private TitledBorder returnTypeBorder = null;
    private DefaultComboBoxModel dataTypeModel = new DefaultComboBoxModel();
    private JComboBox datatypeComboBox = new JComboBox(this.dataTypeModel);
    private DefaultComboBoxModel dimensionModel = new DefaultComboBoxModel();
    private JComboBox dimensionComboBox = new JComboBox(this.dimensionModel);
    private JRadioButton datatypeRadioButton = new JRadioButton();
    private JRadioButton dimensionRadioButton = new JRadioButton();
    private JRadioButton noReturnTypeRadioButton = new JRadioButton();
    private ButtonGroup returnTypeRadioGroup = new ButtonGroup();
    boolean forcedDatatype;

    public NewDMLProgramDialog(Frame frame, Connection connection, String string, String string2, boolean bl) {
        super(frame, OLAPArb.get("NEW.PROGRAM.DIALOG.TITLE"), true);
        this.currentInstance = this;
        this.forcedDatatype = bl;
        this.owner = string;
        this.awName = string2;
        this.conn = connection;
        this.initDialog();
        this.initializeFields();
    }

    @Override
    protected void processComponentEvent(ComponentEvent componentEvent) {
        int n;
        int n2;
        super.processComponentEvent(componentEvent);
        if (componentEvent.getID() != 101) {
            return;
        }
        int n3 = n2 = this.getWidth();
        int n4 = n = this.getHeight();
        Dimension dimension = this.getMinimumSize();
        n3 = Math.max(dimension.width, n3);
        n4 = Math.max(dimension.height, n4);
        if (n2 != n3 || n != n4) {
            this.setSize(n3, n4);
        }
    }

    private void initDialog() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.mainPanel, "olap_new_olap_dml_program");
        this.getRootPane().setDefaultButton(this.m_btnOK);
        this.m_btnOK.setActionCommand("OK_ID");
        this.m_btnOK.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_OK_BUTTON_TEXT")));
        this.m_btnOK.addActionListener(this);
        this.m_btnCancel.setActionCommand("CANCEL_ID");
        this.m_btnCancel.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_CANCEL_BUTTON_TEXT")));
        this.m_btnCancel.addActionListener(this);
        this.m_btnHelp.setActionCommand("HELP_ID");
        this.m_btnHelp.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_HELP_BUTTON_TEXT")));
        this.m_btnHelp.addActionListener(this);
        this.mainPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.getNamePanel(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mainPanel.add((Component)this.getReturnTypePanel(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mainPanel.add((Component)new JPanel(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(10, 4, 5, 5);
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.add((Component)this.m_btnHelp, DialogButtonBar.CONSTRAINT_HELP);
        dialogButtonBar.add((Component)this.m_btnOK, DialogButtonBar.CONSTRAINT_APPLY);
        dialogButtonBar.add((Component)this.m_btnCancel, DialogButtonBar.CONSTRAINT_CANCEL);
        this.mainPanel.add((Component)dialogButtonBar, gridBagConstraints);
        this.add(this.mainPanel);
        this.registerKeyboardActions();
    }

    private JPanel getNamePanel() {
        JPanel jPanel = new JPanel();
        String string = OLAPArb.get("PROPERTY_VIEWER.AW.PROGRAM.BASIC.NAME.LABEL");
        this.nameLabel.setText(StringUtils.stripMnemonic((String)string));
        int n = StringUtils.getMnemonicIndex((String)string);
        this.nameLabel.setDisplayedMnemonicIndex(n);
        this.nameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.nameLabel.setLabelFor(this.nameTextField);
        string = OLAPArb.get("PROPERTY_VIEWER.AW.PROGRAM.BASIC.LD.LABEL");
        this.ldLabel.setText(StringUtils.stripMnemonic((String)string));
        n = StringUtils.getMnemonicIndex((String)string);
        this.ldLabel.setDisplayedMnemonicIndex(n);
        this.ldLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.ldLabel.setLabelFor(this.ldTextField);
        this.nameTextField.setColumns(15);
        this.nameTextField.setFilterMode(1);
        this.nameTextField.setMaximumLength(64);
        this.ldTextField.setColumns(15);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        jPanel.add((Component)this.nameTextField, gridBagConstraints);
        gridBagConstraints.gridx = -1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)this.ldLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        jPanel.add((Component)this.ldTextField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        JLabel jLabel = new JLabel();
        jPanel.add((Component)jLabel, gridBagConstraints);
        return jPanel;
    }

    private JPanel getReturnTypePanel() {
        Object object;
        JPanel jPanel = new JPanel();
        if (!this.forcedDatatype) {
            object = OLAPArb.get("PROPERTY_VIEWER.AW.PROGRAM.BASIC.DATATYPE.LABEL");
            this.datatypeRadioButton.setText(StringUtils.stripMnemonic((String)object));
            int n = StringUtils.getMnemonicIndex((String)object);
            this.datatypeRadioButton.setDisplayedMnemonicIndex(n);
            this.datatypeRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)object));
            object = OLAPArb.get("PROPERTY_VIEWER.AW.PROGRAM.BASIC.DIMENSION.LABEL");
            this.dimensionRadioButton.setText(StringUtils.stripMnemonic((String)object));
            n = StringUtils.getMnemonicIndex((String)object);
            this.dimensionRadioButton.setDisplayedMnemonicIndex(n);
            this.dimensionRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)object));
            object = OLAPArb.get("PROPERTY_VIEWER.AW.PROGRAM.BASIC.NO_RETURN_TYPE.LABEL");
            this.noReturnTypeRadioButton.setText(StringUtils.stripMnemonic((String)object));
            n = StringUtils.getMnemonicIndex((String)object);
            this.noReturnTypeRadioButton.setDisplayedMnemonicIndex(n);
            this.noReturnTypeRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)object));
            this.returnTypeRadioGroup.add(this.datatypeRadioButton);
            this.returnTypeRadioGroup.add(this.dimensionRadioButton);
            this.returnTypeRadioGroup.add(this.noReturnTypeRadioButton);
        }
        this.returnTypeBorder = new TitledBorder(OLAPArb.get("PROPERTY_VIEWER.AW.PROGRAM.BASIC.RETURN_TYPE_BORDER.TITLE"));
        jPanel.setBorder(this.returnTypeBorder);
        jPanel.setLayout(new GridBagLayout());
        object = new GridBagConstraints();
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridwidth = 1;
        ((GridBagConstraints)object).gridheight = 1;
        ((GridBagConstraints)object).weightx = 0.0;
        ((GridBagConstraints)object).weighty = 0.0;
        ((GridBagConstraints)object).fill = 0;
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).insets = new Insets(5, 5, 5, 5);
        if (this.forcedDatatype) {
            String string = OLAPArb.get("PROPERTY_VIEWER.AW.PROGRAM.BASIC.DATATYPE.LABEL");
            JLabel jLabel = new JLabel(string);
            jLabel.setText(StringUtils.stripMnemonic((String)string));
            int n = StringUtils.getMnemonicIndex((String)string);
            jLabel.setDisplayedMnemonicIndex(n);
            jPanel.add((Component)jLabel, object);
        } else {
            jPanel.add((Component)this.datatypeRadioButton, object);
        }
        ++((GridBagConstraints)object).gridx;
        ((GridBagConstraints)object).weightx = 1.0;
        ((GridBagConstraints)object).fill = 2;
        jPanel.add((Component)this.datatypeComboBox, object);
        if (!this.forcedDatatype) {
            ((GridBagConstraints)object).gridx = 0;
            ++((GridBagConstraints)object).gridy;
            ((GridBagConstraints)object).gridwidth = 1;
            ((GridBagConstraints)object).gridheight = 1;
            ((GridBagConstraints)object).weightx = 0.0;
            ((GridBagConstraints)object).weighty = 0.0;
            ((GridBagConstraints)object).fill = 0;
            ((GridBagConstraints)object).anchor = 18;
            jPanel.add((Component)this.dimensionRadioButton, object);
            ++((GridBagConstraints)object).gridx;
            ((GridBagConstraints)object).weightx = 1.0;
            ((GridBagConstraints)object).fill = 2;
            jPanel.add((Component)this.dimensionComboBox, object);
            ((GridBagConstraints)object).gridx = 0;
            ++((GridBagConstraints)object).gridy;
            ((GridBagConstraints)object).gridwidth = 2;
            ((GridBagConstraints)object).gridheight = 1;
            ((GridBagConstraints)object).weightx = 0.0;
            ((GridBagConstraints)object).weighty = 0.0;
            ((GridBagConstraints)object).fill = 0;
            ((GridBagConstraints)object).anchor = 18;
            jPanel.add((Component)this.noReturnTypeRadioButton, object);
        }
        return jPanel;
    }

    private void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this, "CANCEL_ID", KeyStroke.getKeyStroke(27, 0), 1);
        jRootPane.registerKeyboardAction(this, "HELP_ID", KeyStroke.getKeyStroke(112, 0), 1);
        jRootPane.registerKeyboardAction(this, "HELP_ID", KeyStroke.getKeyStroke(156, 0), 1);
    }

    private void initializeFields() {
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.conn);
        String string = this.generateDefaultName(dBUtil);
        this.nameTextField.setText(string);
        this.loadDataTypeCombo();
        this.datatypeComboBox.setSelectedItem("NUMBER");
        this.loadDimensionCombo(dBUtil);
        this.noReturnTypeRadioButton.setSelected(true);
    }

    private String generateDefaultName(DBUtil dBUtil) {
        Object object = "PROGRAM";
        List<String> list = this.getProgramsInAW(dBUtil);
        int n = 1;
        object = (String)object + n;
        while (list.contains(object)) {
            object = "PROGRAM" + ++n;
        }
        return object;
    }

    private List<String> getProgramsInAW(DBUtil dBUtil) {
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("AW_NAME", this.awName);
        hashMap.put("OWNER", this.owner);
        List list = dBUtil.executeReturnList("select * from (\n                SELECT DISTINCT obj_id, obj_name\n                FROM all_aw_obj\n                WHERE owner = :OWNER\n                AND aw_name = :AW_NAME\n                AND obj_type=35 and obj_name not in ('ONATTACH'))", hashMap);
        for (Map map : list) {
            String string = (String)map.get("OBJ_NAME");
            string = string.toUpperCase();
            arrayList.add(string);
        }
        return arrayList;
    }

    private void loadDataTypeCombo() {
        String[] stringArray = DMLProgram.RETURN_DATATYPES;
        for (int i = 0; i < stringArray.length; ++i) {
            this.dataTypeModel.addElement(stringArray[i]);
        }
    }

    private void loadDimensionCombo(DBUtil dBUtil) {
        List<String> list = this.getDimensionsInAW(dBUtil);
        for (String string : list) {
            this.dimensionModel.addElement(string);
        }
    }

    private List<String> getDimensionsInAW(DBUtil dBUtil) {
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("AW_NAME", this.awName);
        hashMap.put("OWNER", this.owner);
        List list = dBUtil.executeReturnList("select DIMENSION_NAME from all_cube_dimensions where owner = :OWNER and aw_name = :AW_NAME order by dimension_name", hashMap);
        for (Map map : list) {
            String string = (String)map.get("DIMENSION_NAME");
            arrayList.add(string);
        }
        return arrayList;
    }

    private boolean validateFields() {
        boolean bl = true;
        String string = this.nameTextField.getText().trim();
        string = string.toUpperCase();
        String string2 = null;
        String string3 = OLAPArb.get("NEW.PROGRAM.ERROR.TITLE");
        String string4 = null;
        if (string.length() == 0) {
            string2 = OLAPArb.get("NEW.PROGRAM.ERROR.MSG_NO_NAME");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)string3, string4);
            bl = false;
            return bl;
        }
        if (!this.isNameValid(string)) {
            string2 = OLAPArb.get("NEW.PROGRAM.ERROR.INVALID_NAME");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)string3, string4);
            bl = false;
            return bl;
        }
        if (this.isKeyword(string)) {
            string2 = OLAPArb.get("NEW.PROGRAM.ERROR.INVALID_NAME_KEYWORD");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)string3, string4);
            bl = false;
            return bl;
        }
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.conn);
        List<String> list = this.getProgramsInAW(dBUtil);
        if (list.contains(string)) {
            string2 = OLAPArb.get("NEW.PROGRAM.ERROR.MSG_DUPLICATE_NAME");
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)string3, string4);
            bl = false;
            return bl;
        }
        return bl;
    }

    private boolean isNameValid(String string) {
        char c;
        int n;
        boolean bl = true;
        if (string == null || string.length() == 0 || string.length() > 64) {
            bl = false;
        }
        if (bl && string.length() == 1) {
            n = string.charAt(0);
            boolean bl2 = bl = n != 46 && n != 95;
        }
        if (bl && string.length() == 2) {
            n = string.charAt(0);
            c = string.charAt(1);
            boolean bl3 = bl = n != 46 || !Character.isDigit(c);
        }
        if (bl && Character.isDigit(string.charAt(0))) {
            bl = false;
        }
        if (bl) {
            for (n = 0; n < string.length() && bl; ++n) {
                c = string.charAt(n);
                bl = Character.isDigit(c) || Character.isLetter(c) || c == '.' || c == '_';
            }
        }
        return bl;
    }

    public boolean isKeyword(String string) {
        boolean bl = false;
        for (String string2 : OLAPKeywords.keywords) {
            if (!string.equalsIgnoreCase(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isOKSelected() {
        return this.m_clickedOK;
    }

    public DMLProgram getProgram() {
        return this.program;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equalsIgnoreCase("OK_ID")) {
            if (this.validateFields()) {
                this.program = new DMLProgram(this.conn, this.owner, this.awName, this.nameTextField.getText());
                this.program.setDescription(this.ldTextField.getText());
                if (this.forcedDatatype || this.datatypeRadioButton.isSelected()) {
                    this.program.setDataType((String)this.datatypeComboBox.getSelectedItem());
                } else if (this.dimensionRadioButton.isSelected()) {
                    this.program.setDimension((String)this.dimensionComboBox.getSelectedItem());
                }
                this.m_clickedOK = true;
                this.currentInstance.setVisible(false);
            }
        } else if (string.equalsIgnoreCase("CANCEL_ID")) {
            this.m_clickedOK = false;
            this.currentInstance.setVisible(false);
        } else if (string.equalsIgnoreCase("HELP_ID")) {
            HelpSystem.getHelpSystem().showHelp((JComponent)this.mainPanel);
        }
    }
}

