/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.diagram.measure;

import ilog.views.IlvGraphic;
import ilog.views.swing.IlvPopupMenuContext;
import ilog.views.swing.IlvPopupMenuManager;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.ide.Ide;
import oracle.javatools.db.Schema;
import oracle.olap.OLAPArb;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.AnalyticWorkspace;
import oracle.olap.app.olapmetadata.CalcReferences;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.cube.model.Cube;
import oracle.olap.db.CubeCalcPersistSQL;
import oracle.olap.db.OLAPExceptionHandler;
import oracle.olap.diagram.measure.MeasureDependenciesDiagram;
import oracle.olap.measure.CalculatedMeasureDetailsDialog;
import oracle.olap.measure.MeasureDetailsDialog;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPISyntaxParser;

public class MeasureDependenciesDiagramContextMenu {
    public static final String POPUPMENU_NAME = "diagrammenu";
    private JPopupMenu menu = new JPopupMenu();
    private static MeasureDependenciesDiagramContextMenu _instance;

    private MeasureDependenciesDiagramContextMenu() {
        JMenuItem jMenuItem = new JMenuItem(new ViewDetailsAction());
        this.menu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(new DropDependenciesAction());
        this.menu.add(jMenuItem2);
    }

    public static MeasureDependenciesDiagramContextMenu getInstance() {
        if (_instance == null) {
            _instance = new MeasureDependenciesDiagramContextMenu();
        }
        return _instance;
    }

    public JPopupMenu getMenu() {
        return this.menu;
    }

    private class ViewDetailsAction
    extends AbstractAction {
        public ViewDetailsAction() {
            this.setEnabled(true);
            this.putValue("Name", OLAPArb.getString("CALCULATED_MEASURES_DEPENDENCIES_DIAGRAM_MENU_VIEW_DETAILS"));
            this.putValue("ShortDescription", this.getValue("Name"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            IlvPopupMenuContext ilvPopupMenuContext = IlvPopupMenuManager.getPopupMenuContext((MenuElement)jMenuItem);
            if (ilvPopupMenuContext != null) {
                IlvGraphic ilvGraphic = ilvPopupMenuContext.getGraphic();
                Measure measure = (Measure)ilvGraphic.getProperty("measure");
                MeasureDetailsDialog measureDetailsDialog = null;
                measureDetailsDialog = measure.isDerived() ? new CalculatedMeasureDetailsDialog(measure) : new MeasureDetailsDialog(measure);
                measureDetailsDialog.setVisible(true);
            }
        }
    }

    private class DropDependenciesAction
    extends AbstractAction {
        public DropDependenciesAction() {
            this.setEnabled(true);
            this.putValue("Name", OLAPArb.getString("CALCULATED_MEASURES_DEPENDENCIES_DIAGRAM_MENU_DROP_DEPENDENCIES"));
            this.putValue("ShortDescription", this.getValue("Name"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem;
            IlvPopupMenuContext ilvPopupMenuContext;
            int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), OLAPArb.getString("DROP_DEPENDENCIES_DIAGRAM_WARNING"), OLAPArb.getString("DROP_DEPENDENCIES_DIAGRAM_TITLE"), 1);
            if (n == 0 && (ilvPopupMenuContext = IlvPopupMenuManager.getPopupMenuContext((MenuElement)(jMenuItem = (JMenuItem)actionEvent.getSource()))) != null) {
                IlvGraphic ilvGraphic = ilvPopupMenuContext.getGraphic();
                Measure measure = (Measure)ilvGraphic.getProperty("measure");
                final MeasureDependenciesDiagram measureDependenciesDiagram = (MeasureDependenciesDiagram)((Object)ilvGraphic.getProperty("diagram"));
                AnalyticWorkspace analyticWorkspace = new AnalyticWorkspace();
                analyticWorkspace.setCubes(measure.getCube().getSchema().getCubes());
                OLAPISyntaxParser oLAPISyntaxParser = new OLAPISyntaxParser(measure.getCube().getSchema(), new Properties());
                final List<Measure> list = CalcReferences.getDependencies(analyticWorkspace, measure.getCube().getName(), measure.getName(), oLAPISyntaxParser);
                if (!measureDependenciesDiagram.isFullDiagram()) {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), OLAPArb.getString("DROP_DEPENDENCIES_NOT_FULL_DIAGRAM_WARNING"), OLAPArb.getString("DROP_DEPENDENCIES_DIAGRAM_TITLE"), 1);
                    return;
                }
                if (!list.isEmpty()) {
                    DatabaseImpl databaseImpl = new DatabaseImpl();
                    databaseImpl.setConnection((Connection)ilvGraphic.getProperty("connection"));
                    try {
                        Cube cube = new Cube();
                        Schema schema = new Schema(measure.getCube().getSchema().getName());
                        cube.setSchema(schema);
                        final CubeCalcPersistSQL cubeCalcPersistSQL = new CubeCalcPersistSQL(databaseImpl, measure.getCube(), cube);
                        String string = OLAPArb.getString("DROP_DEPENDENCIES_DIAGRAM_PROGRESS_MSG");
                        RaptorTask raptorTask = new RaptorTask(string, true, IRaptorTaskRunMode.MODAL){

                            protected Object doWork() throws TaskException {
                                Boolean bl = Boolean.TRUE;
                                try {
                                    for (Measure measure : list) {
                                        cubeCalcPersistSQL.addRemoveMeasure(measure.getName(), measure.getCube().getName());
                                    }
                                    cubeCalcPersistSQL.commit();
                                }
                                catch (Exception exception) {
                                    bl = Boolean.FALSE;
                                    throw new TaskException((Throwable)exception);
                                }
                                return bl;
                            }
                        };
                        raptorTask.setCancellable(false);
                        raptorTask.setPausable(false);
                        raptorTask.setMessage(string);
                        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                            public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                                Runnable runnable = new Runnable(){

                                    @Override
                                    public void run() {
                                        Throwable throwable = raptorTaskEvent.getThrowable();
                                        if (throwable.getCause() != null) {
                                            OLAPExceptionHandler.handleException((Window)Ide.getMainWindow(), (Exception)throwable.getCause());
                                        } else {
                                            OLAPExceptionHandler.handleException((Window)Ide.getMainWindow(), throwable.getMessage());
                                        }
                                    }
                                };
                                SwingUtilities.invokeLater(runnable);
                            }

                            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                                Runnable runnable = new Runnable(){

                                    @Override
                                    public void run() {
                                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), OLAPArb.getString("DROP_DEPENDENCIES_DIAGRAM_CONFIRM_MSG"), OLAPArb.getString("DROP_DEPENDENCIES_DIAGRAM_TITLE"), 1);
                                        measureDependenciesDiagram.refreshDiagram();
                                    }
                                };
                                SwingUtilities.invokeLater(runnable);
                            }
                        });
                        RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
                        raptorTaskManager.addTask(raptorTask);
                    }
                    catch (Exception exception) {}
                } else {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), OLAPArb.getString("DROP_DEPENDENCIES_DIAGRAM_NO_DEPENDENCIES_MSG"), OLAPArb.getString("DROP_DEPENDENCIES_DIAGRAM_TITLE"), 1);
                }
            }
        }
    }
}

