/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.ddl;

import java.util.ArrayList;
import java.util.List;
import oracle.olap.cubexml.ReservedWordsSyntaxHandler;

public class Identifier {
    private String identifier;
    private List<String> identifierComponents;
    private static final String DOUBLE_QUOTE = "\"";

    public Identifier(String string, String string2) {
        this.identifierComponents = new ArrayList<String>();
        this.identifierComponents.add(string);
        this.identifierComponents.add(string2);
    }

    public Identifier(String string) {
        this.identifier = string;
        this.identifierComponents = new ArrayList<String>();
        this.parse();
    }

    private void parse() {
        int n = 0;
        while (n < this.identifier.length()) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.identifier.charAt(n) == '\"') {
                ++n;
                while (n < this.identifier.length() && this.identifier.charAt(n) != '\"') {
                    stringBuffer.append(this.identifier.charAt(n++));
                }
                String string = stringBuffer.toString();
                Identifier identifier = new Identifier(string);
                this.identifierComponents.addAll(identifier.identifierComponents);
                if (n >= this.identifier.length()) continue;
                ++n;
                continue;
            }
            while (n < this.identifier.length() && this.identifier.charAt(n) != '.') {
                stringBuffer.append(this.identifier.charAt(n++));
            }
            if (n < this.identifier.length()) {
                ++n;
            }
            if (stringBuffer.length() <= 0) continue;
            if (ReservedWordsSyntaxHandler.IsCubeSQLReservedWord(stringBuffer.toString())) {
                this.identifierComponents.add(String.format("\"%s\"", stringBuffer));
                continue;
            }
            this.identifierComponents.add(stringBuffer.toString());
        }
    }

    private void addComponent(String string) {
        if (ReservedWordsSyntaxHandler.IsCubeSQLReservedWord(string)) {
            this.identifierComponents.add(String.format("\"%s\"", string));
        } else {
            this.identifierComponents.add(string);
        }
    }

    public String[] getComponents() {
        return this.identifierComponents.toArray(new String[this.identifierComponents.size()]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.identifierComponents) {
            boolean bl = false;
            if (!(string.indexOf(" ") < 0 && string.equals(string.toUpperCase()) || string.startsWith(DOUBLE_QUOTE))) {
                bl = true;
            }
            if (bl) {
                stringBuffer.append(String.format("\"%s\"", string));
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append(".");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.identifierComponents) {
            boolean bl2 = false;
            if (!(string.indexOf(" ") < 0 && string.equals(string.toUpperCase()) || string.startsWith(DOUBLE_QUOTE))) {
                bl2 = true;
            }
            if (bl2) {
                stringBuffer.append(String.format("\"%s\"", string));
            } else {
                if (!bl && string.startsWith(DOUBLE_QUOTE)) {
                    String string2 = string.substring(1, string.length());
                    if (ReservedWordsSyntaxHandler.IsCubeSQLReservedWord(string2 = string2.substring(0, string.length() - 2))) {
                        string = string2;
                    }
                }
                stringBuffer.append(string);
            }
            stringBuffer.append(".");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public static final String stripQuotes(String string) {
        if ((string = string.replaceAll("''", "'")).startsWith("'")) {
            string = string.substring(1, string.length());
        }
        if (string.endsWith("'")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.startsWith(DOUBLE_QUOTE)) {
            string = string.substring(1, string.length());
        }
        if (string.endsWith(DOUBLE_QUOTE)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"\"MEASURE\"", "MEASURE", "\"MEASURE.CHANNEL_ID\"", "MEASURE.CHANNEL_ID", "\"MY TABLE\".CHANNEL_ID", "\"MY TABLE\".CHANNEL_ID"};
        for (int i = 0; i < stringArray2.length; i += 2) {
            Identifier identifier = new Identifier(stringArray2[i]);
            String string = identifier.toString(false);
            System.out.print(String.format("%s=%s", stringArray2[i], string));
            if (!string.equals(stringArray2[i + 1])) {
                System.out.print("  *** Failed");
            }
            System.out.println();
        }
    }
}

