/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.i18n.util.LocaleMapper;
import oracle.javatools.db.DBException;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.OLAPMetadataCache;
import oracle.olap.app.olapmetadata.Schema;

public class LanguageDBSettings {
    public static String getDefaultLanguage() throws DBException {
        String string = "";
        boolean bl = Boolean.parseBoolean(System.getProperty("sqldev_olap.cache", "true"));
        if (!bl) {
            return "AMERICAN";
        }
        Connection connection = Connections.getInstance().getConnection(Connections.getActiveConnectionName());
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("language", "NLS_LANGUAGE");
        String string2 = "select value from nls_session_parameters where parameter = :language";
        string = dBUtil.executeReturnOneCol(string2, hashMap);
        return string;
    }

    public static void setLanguage(String string) throws DBException {
        Connection connection = Connections.getInstance().getConnection(Connections.getActiveConnectionName());
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        String string2 = String.format("alter session set NLS_LANGUAGE='%s'", string);
        dBUtil.execute(string2);
    }

    public static String getLanguageCodeForLanguage(String string) {
        return LocaleMapper.getOraShortNameFromLanguage((String)string);
    }

    public static List<String> getDescriptionLanguages(String string) throws Exception {
        String string2 = LanguageDBSettings.getDefaultLanguage();
        ArrayList<String> arrayList = Collections.EMPTY_LIST;
        Connection connection = Connections.getInstance().getConnection(Connections.getActiveConnectionName());
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("language", string2);
        String string3 = "select distinct OWNER,OBJECT_NAME,LANGUAGE from all_cube_descriptions where LANGUAGE <> :language order by LANGUAGE";
        Connections.getInstance().lock(connection);
        ResultSet resultSet = dBUtil.executeQuery(string3, hashMap);
        if (resultSet != null) {
            arrayList = new ArrayList<String>();
            while (resultSet.next()) {
                String string4 = resultSet.getString("OBJECT_NAME");
                String string5 = resultSet.getString("LANGUAGE");
                if (!LanguageDBSettings.objectBelongsToAw(string4, string, resultSet.getString("OWNER")) || arrayList.contains(string5)) continue;
                arrayList.add(string5);
            }
        }
        DBUtil.closeResultSet((ResultSet)resultSet);
        Connections.getInstance().unlock(connection);
        return arrayList;
    }

    private static boolean objectBelongsToAw(String string, String string2, String string3) throws Exception {
        Schema schema = OLAPMetadataCache.getUpdatedSchema(Connections.getActiveConnectionName(), string3);
        String string4 = "";
        string4 = string.indexOf(".") > 0 ? string.substring(0, string.indexOf(".")) : string;
        Dimension dimension = schema.findDimension(string4);
        if (dimension != null) {
            return dimension.getAWName().equalsIgnoreCase(string2);
        }
        Cube cube = schema.findCube(string4);
        if (cube != null) {
            return cube.getAWName().equalsIgnoreCase(string2);
        }
        return false;
    }

    public static List<String> getDescriptionLanguagesUnionForObjectType(String string, String string2) throws Exception {
        String string3 = LanguageDBSettings.getDefaultLanguage();
        ArrayList<String> arrayList = Collections.EMPTY_LIST;
        Connection connection = Connections.getInstance().getConnection(Connections.getActiveConnectionName());
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("language", string3);
        String string4 = String.format("select distinct LANGUAGE from all_cube_descriptions where LANGUAGE <> :language and OBJECT_TYPE in (%s) and OBJECT_NAME in (%s)", string, string2);
        Connections.getInstance().lock(connection);
        ResultSet resultSet = dBUtil.executeQuery(string4, hashMap);
        if (resultSet != null) {
            arrayList = new ArrayList<String>();
            while (resultSet.next()) {
                String string5 = resultSet.getString("LANGUAGE");
                arrayList.add(string5);
            }
        }
        DBUtil.closeResultSet((ResultSet)resultSet);
        Connections.getInstance().unlock(connection);
        return arrayList;
    }
}

