/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.db;

import java.awt.Window;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.dialogs.DBMessageDialog;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLDatabase;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.ResultSet;
import oracle.olap.OLAPArb;
import oracle.olap.db.CubeSQL;
import oracle.olap.db.OLAPExceptionHandler;
import oracle.olap.db.view.GeneralBaseEditorPanelContext;
import oracle.olap.db.view.OLAPDDLPanel;
import oracle.olap.db.view.TransactionWaitCursorManager;

public abstract class BasePanelLibrary
extends PanelLibrary {
    private Namespace namespace;

    public BasePanelLibrary(String string) {
        super(string);
    }

    protected Namespace getNamespace() {
        return this.namespace;
    }

    public void commitToProvider(DBEditorConfig dBEditorConfig) {
        this.commitToProviderDirect(dBEditorConfig);
    }

    private void commitToProviderDirect(DBEditorConfig dBEditorConfig) {
        DDLDatabase dDLDatabase = (DDLDatabase)dBEditorConfig.getProvider();
        DDLGenerator dDLGenerator = dDLDatabase.getDDLGenerator();
        SystemObject systemObject = dBEditorConfig.getOriginalObject();
        SystemObject systemObject2 = dBEditorConfig.getUpdatedObject();
        boolean bl = false;
        TransactionWaitCursorManager transactionWaitCursorManager = TransactionWaitCursorManager.getInstance();
        transactionWaitCursorManager.setDialog((Window)this.getNamespace().get("oracle.bali.ewt.dialog.JEWTDialog"));
        try {
            if (dBEditorConfig.getOriginalObject() == null) {
                this.createOLAPObject(dDLDatabase, bl, systemObject2);
            } else {
                this.alterOLAPObject(dDLDatabase, bl, systemObject, systemObject2);
            }
            this.finishUpdates(dBEditorConfig, systemObject, systemObject2);
        }
        catch (DBException dBException) {
            dBEditorConfig.setResult(DBEditorConfig.Result.FAILED);
            dBEditorConfig.setException(dBException);
            OLAPExceptionHandler.handleException((Window)this.getNamespace().get("oracle.bali.ewt.dialog.JEWTDialog"), (Exception)((Object)dBException));
        }
    }

    private void commitToProviderWithRaptorTask(final DBEditorConfig dBEditorConfig) {
        final DDLDatabase dDLDatabase = (DDLDatabase)dBEditorConfig.getProvider();
        DDLGenerator dDLGenerator = dDLDatabase.getDDLGenerator();
        final SystemObject systemObject = dBEditorConfig.getOriginalObject();
        final SystemObject systemObject2 = dBEditorConfig.getUpdatedObject();
        String string = systemObject == null ? OLAPArb.format("PERSISTING_OLAP_OBJECT_PROGRESS_MSG", systemObject2.getName()) : OLAPArb.format("PERSISTING_OLAP_OBJECT_PROGRESS_MSG", systemObject.getName());
        RaptorTask raptorTask = new RaptorTask(string, true, IRaptorTaskRunMode.MODAL){

            protected Object doWork() throws TaskException {
                Boolean bl = Boolean.TRUE;
                try {
                    boolean bl2 = false;
                    if (dBEditorConfig.getOriginalObject() == null) {
                        BasePanelLibrary.this.createOLAPObject(dDLDatabase, bl2, systemObject2);
                    } else {
                        BasePanelLibrary.this.alterOLAPObject(dDLDatabase, bl2, systemObject, systemObject2);
                    }
                }
                catch (Exception exception) {
                    bl = Boolean.FALSE;
                    throw new TaskException((Throwable)exception);
                }
                return bl;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.setMessage(string);
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Throwable throwable = raptorTaskEvent.getThrowable();
                        dBEditorConfig.setResult(DBEditorConfig.Result.FAILED);
                        DBException dBException = (DBException)throwable;
                        dBEditorConfig.setException(dBException);
                        OLAPExceptionHandler.handleException((Window)BasePanelLibrary.this.getNamespace().get("oracle.bali.ewt.dialog.JEWTDialog"), (Exception)((Object)dBException));
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            BasePanelLibrary.this.finishUpdates(dBEditorConfig, systemObject, systemObject2);
                        }
                        catch (DBException dBException) {
                            dBEditorConfig.setResult(DBEditorConfig.Result.FAILED);
                            dBEditorConfig.setException(dBException);
                            DBMessageDialog.showErrorDialog((Exception)((Object)dBException), (Object)systemObject2, (Level)Level.ALL);
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
        RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
        raptorTaskManager.addTask(raptorTask);
    }

    private void finishUpdates(DBEditorConfig dBEditorConfig, SystemObject systemObject, SystemObject systemObject2) throws DBException {
        dBEditorConfig.setResult(DBEditorConfig.Result.SUCCESS);
        DBObjectProvider dBObjectProvider = dBEditorConfig.getProvider();
        if (dBObjectProvider instanceof AbstractDatabase) {
            AbstractDatabase abstractDatabase = (AbstractDatabase)dBObjectProvider;
            SystemObject[] systemObjectArray = new SystemObject[]{systemObject};
            SystemObject[] systemObjectArray2 = new SystemObject[]{systemObject2};
            Difference difference = dBObjectProvider.getDiffEngine().difference((Object)systemObjectArray, (Object)systemObjectArray2);
            GeneralBaseEditorPanelContext generalBaseEditorPanelContext = GeneralBaseEditorPanelContext.getInstance();
            generalBaseEditorPanelContext.setDescriptionSynchOn(false);
            abstractDatabase.finishUpdates(difference);
            generalBaseEditorPanelContext.setDescriptionSynchOn(true);
        }
    }

    private void createOLAPObject(DDLDatabase dDLDatabase, boolean bl, SystemObject systemObject) throws DBException {
        DDLGenerator dDLGenerator = dDLDatabase.getDDLGenerator();
        Object var5_5 = null;
        String string = systemObject.getName();
        DBObject[] dBObjectArray = new DBObject[]{systemObject};
        DDL dDL = dDLGenerator.getCreateDDL(new DDLOptions(), dBObjectArray);
        this.execute(dDL, dDLDatabase, bl, null, systemObject);
    }

    protected void alterOLAPObject(DDLDatabase dDLDatabase, boolean bl, SystemObject systemObject, SystemObject systemObject2) throws DBException {
        DDLGenerator dDLGenerator = dDLDatabase.getDDLGenerator();
        Object var6_6 = null;
        DDLDatabase dDLDatabase2 = dDLDatabase;
        ResultSet resultSet = dDLDatabase2.getDiffEngine().diff((Object)systemObject, (Object)systemObject2).getResult();
        DDL dDL = dDLGenerator.getUpdateDDL(new DDLOptions(), (Difference)resultSet);
        this.execute(dDL, dDLDatabase, bl, systemObject, systemObject2);
    }

    private void execute(DDL dDL, DDLDatabase dDLDatabase, boolean bl, SystemObject systemObject, SystemObject systemObject2) throws DBException {
        Collection collection = dDL.getStatements();
        CubeSQL cubeSQL = new CubeSQL(dDLDatabase, bl, systemObject, systemObject2, collection, true);
        Map<String, Object> map = this.getProperties();
        cubeSQL.setProperties(map);
        if (collection.size() > 0) {
            cubeSQL.execute();
        }
    }

    protected Class<? extends Traversable> getDDLPanel() {
        return OLAPDDLPanel.class;
    }

    public Map<String, Object> getProperties() {
        return new HashMap<String, Object>();
    }

    public boolean shouldValidateOnExit(BaseEditorPanel baseEditorPanel, Namespace namespace) {
        this.namespace = namespace;
        return super.shouldValidateOnExit(baseEditorPanel, namespace);
    }
}

