/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubeviewer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.sql.SQLException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.olap.OLAPArb;
import oracle.olap.app.Resources;
import oracle.olap.app.olapmetadata.Dimension;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.table.TableCheckBoxCellEditor;
import oracle.olap.app.table.TableCheckBoxCellRenderer;
import oracle.olap.app.util.FetchIcon;
import oracle.olap.cubeviewer.CubeDimensionConditionPanel;
import oracle.olap.cubeviewer.CubeET;
import oracle.olap.data.CubeMetadataContext;

public class CubeQueryEditorPanel
extends JPanel
implements TableModelListener {
    private DefaultTableModel measureTableModel;
    private JTable measureTable;
    private JTextField measureFilterFld;
    private CubeMetadataContext cubeMetadataContext;
    private CubeET cubeET;
    private JTabbedPane tabPane;
    private CubeDimensionConditionPanel cubeDimCondPanel;
    private static final int COL_SELECT = 0;
    private static final int COL_MEASURE_NAME = 1;
    private static final int COL_DESC = 2;
    private static final int COL_EXPRESSION = 3;
    private static final int COL_COUNT = 4;

    public CubeQueryEditorPanel(Component component, CubeMetadataContext cubeMetadataContext, CubeET cubeET) throws SQLException, IOException {
        this.cubeMetadataContext = cubeMetadataContext;
        this.cubeET = cubeET;
        this.measureTableModel = new DefaultTableModel();
        this.measureTableModel.addTableModelListener(this);
        Resources resources = null;
        FetchIcon fetchIcon = null;
        this.cubeDimCondPanel = new CubeDimensionConditionPanel(cubeMetadataContext, resources, fetchIcon);
        this.layoutComponents();
        this.initTable();
        this.loadMeasureTable();
        Object var6_6 = null;
    }

    private void initTable() {
        this.measureTableModel.setRowCount(0);
        this.measureTableModel.setColumnCount(0);
        this.measureTableModel.addColumn(OLAPArb.get("MEASURE_SELECT_COLUMN"));
        this.measureTableModel.addColumn(OLAPArb.get("MEASURE_MEASURE_NAME_COLUMN"));
        this.measureTableModel.addColumn(OLAPArb.get("MEASURE_DESCRIPTION_COLUMN"));
        this.measureTableModel.addColumn(OLAPArb.get("MEASURE_EXPRESSION_COLUMN"));
        TableColumn tableColumn = this.measureTable.getColumnModel().getColumn(0);
        tableColumn.setCellEditor(new TableCheckBoxCellEditor());
        tableColumn.setCellRenderer(new TableCheckBoxCellRenderer());
        tableColumn.setPreferredWidth(70);
        tableColumn = this.measureTable.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(300);
    }

    private void loadMeasureTable() {
        String string = "";
        if (this.measureFilterFld.getText() != null) {
            string = this.measureFilterFld.getText();
        }
        this.measureTableModel.setRowCount(0);
        for (Measure measure : this.cubeMetadataContext.getMeasures()) {
            boolean bl;
            String string2 = measure.getName();
            if (string.length() > 0 && !(bl = string2.contains(string.toUpperCase()))) continue;
            Boolean bl2 = this.cubeET.getMeasureSelectedMap().get(measure);
            if (bl2 == null) {
                bl2 = false;
            }
            this.measureTableModel.addRow(new Object[]{bl2, measure.getName(), measure.getDescription(), measure.getExpression()});
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getColumn();
        if (n == -1) {
            return;
        }
        if (tableModelEvent.getSource() == this.measureTableModel && tableModelEvent.getType() == 0) {
            this.updateMeasureTableModelFromCell(n, n2);
        }
    }

    private void updateMeasureTableModelFromCell(int n, int n2) {
        if (n2 != 0) {
            return;
        }
        String string = (String)this.measureTable.getValueAt(n, 1);
        Object object = this.measureTable.getValueAt(n, n2);
        Boolean bl = (Boolean)object;
        for (Measure measure : this.cubeMetadataContext.getMeasures()) {
            if (!measure.getName().equals(string)) continue;
            this.cubeET.getMeasureSelectedMap().put(measure, bl);
        }
    }

    private void layoutComponents() {
        JLabel jLabel = new JLabel(OLAPArb.get("CUBE_QUERY_TOP_LABEL"));
        this.measureTable = new JTable(this.measureTableModel){

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (n2 == 3 && component instanceof JComponent) {
                    Object object = CubeQueryEditorPanel.this.measureTableModel.getValueAt(n, n2);
                    JComponent jComponent = (JComponent)component;
                    if (object != null) {
                        jComponent.setToolTipText(object.toString());
                    }
                }
                return component;
            }
        };
        this.measureTable.setAutoResizeMode(0);
        JLabel jLabel2 = new JLabel(OLAPArb.get("MEASURE_FILTER"));
        this.measureFilterFld = new JTextField();
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.measureTable);
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 5, 0));
        jPanel.add((Component)this.measureFilterFld, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 5, 0));
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        n = 0;
        for (Dimension dimension : this.cubeMetadataContext.getCubeDimensions()) {
            JLabel jLabel3 = new JLabel(dimension.getName());
            jPanel2.add((Component)jLabel3, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 5, 0));
            ++n;
        }
        this.tabPane = new JTabbedPane();
        this.tabPane.add(OLAPArb.get("CUBE_MEASURES"), jPanel);
        this.tabPane.add(OLAPArb.get("CUBE_QUERY_DIMENSION_TAB"), this.cubeDimCondPanel);
        this.setLayout(new GridBagLayout());
        n = 0;
        this.add((Component)jLabel, new GridBagConstraints(0, n, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 5, 0));
        this.add((Component)this.tabPane, new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.measureFilterFld.getDocument().addDocumentListener(new DocumentListener(){

            private void changed() {
                CubeQueryEditorPanel.this.loadMeasureTable();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.changed();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.changed();
            }
        });
    }
}

