/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubetemplate;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.xml.xpath.XPathExpressionException;
import oracle.olap.app.Resources;
import oracle.olap.cubetemplate.ObjectType;
import oracle.olap.cubetemplate.TreeModelHelper;
import oracle.olap.cubetemplate.TreeNode;

public class ObjectPreviewPanel
extends JPanel {
    private TreeModelHelper preprocessor;
    private static final String ERROR_PANEL = "ERROR PANEL";
    private static final String TREE_PANEL = "TREE PANEL";
    private final CardLayout cardLayout;
    private final Resources resources;
    private final JTextArea errorTextArea = new JTextArea();
    private final JScrollPane errorScrollPane;
    private final DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode(""));
    private final JTree tree = new JTree(this.model);
    private final JScrollPane dTreeScrollPane = new JScrollPane(this.tree);

    public ObjectPreviewPanel(Resources resources) {
        super(new CardLayout());
        this.errorTextArea.setEditable(false);
        this.errorTextArea.setName("errorTextArea");
        this.tree.setName("tree");
        this.dTreeScrollPane.setName("dTreeScrollPane");
        this.tree.setSelectionModel(new DefaultTreeSelectionModel(){

            @Override
            public void setSelectionPath(TreePath treePath) {
            }

            @Override
            public void setSelectionPaths(TreePath[] treePathArray) {
            }
        });
        this.cardLayout = (CardLayout)this.getLayout();
        this.resources = resources;
        this.tree.setExpandsSelectedPaths(true);
        this.tree.setCellRenderer(new TreeCellRenderer(){
            TreeCellRenderer defRenderer;
            {
                this.defRenderer = ObjectPreviewPanel.this.tree.getCellRenderer();
            }

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                Component component = this.defRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                if (object instanceof TreeNode && component instanceof JLabel) {
                    ((JLabel)component).setIcon(((TreeNode)object).getIcon());
                }
                return component;
            }
        });
        this.dTreeScrollPane.setVerticalScrollBarPolicy(20);
        this.errorTextArea.setLineWrap(true);
        this.errorScrollPane = new JScrollPane(this.errorTextArea);
        this.errorScrollPane.setName("errorScrollPane");
        this.add((Component)this.errorScrollPane, ERROR_PANEL);
        this.add((Component)this.dTreeScrollPane, TREE_PANEL);
    }

    public void configure(TreeModelHelper treeModelHelper, boolean bl) {
        try {
            this.preprocessor = treeModelHelper;
            this.generateTree();
            if (bl) {
                this.tree.expandPath(new TreePath(this.model.getRoot()));
                for (int i = 0; i < this.tree.getRowCount(); ++i) {
                    this.tree.expandRow(i);
                }
            }
            this.cardLayout.show(this, TREE_PANEL);
        }
        catch (Exception exception) {
            this.showError(exception.getLocalizedMessage());
        }
    }

    public void showError(String string) {
        this.errorTextArea.append(string + "\n");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JViewport jViewport = ObjectPreviewPanel.this.errorScrollPane.getViewport();
                jViewport.setViewPosition(new Point(0, 0));
            }
        });
        this.cardLayout.show(this, ERROR_PANEL);
    }

    public void clear() {
        this.preprocessor = null;
        this.errorTextArea.setText(this.resources.getString("READ_FROM_TEMPLATE_DLG.OBJECTS_TAB_ERROR") + "\n\n");
    }

    private void generateTree() throws XPathExpressionException {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("");
        this.model.setRoot(defaultMutableTreeNode);
        ObjectType objectType = ObjectType.ALL;
        this.addNodeList(defaultMutableTreeNode, new ArrayList<TreeNode>(0), objectType);
    }

    private boolean addNodeList(DefaultMutableTreeNode defaultMutableTreeNode, List<TreeNode> list, ObjectType objectType) throws XPathExpressionException {
        boolean bl = false;
        if (list.size() == 0) {
            list.add(null);
        }
        for (TreeNode treeNode : list) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
            if (treeNode != null) {
                this.model.insertNodeInto(treeNode, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                bl = true;
                defaultMutableTreeNode2 = treeNode;
                if (treeNode.isSelected()) {
                    this.tree.addSelectionPath(new TreePath(this.model.getPathToRoot(treeNode)));
                }
            }
            ObjectType[] objectTypeArray = objectType.getChildTypes();
            for (int i = 0; i < objectTypeArray.length; ++i) {
                TreeNode treeNode2 = new TreeNode(objectTypeArray[i].toString(), objectTypeArray[i], false, true);
                this.model.insertNodeInto(treeNode2, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
                String string = treeNode == null ? null : treeNode.getUserObject().toString();
                boolean bl2 = this.addNodeList(treeNode2, this.preprocessor.getObjects(objectTypeArray[i], string), objectTypeArray[i]);
                if (!bl2) {
                    this.model.removeNodeFromParent(treeNode2);
                }
                bl = bl || bl2;
            }
        }
        return bl;
    }
}

