/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubedimension.panels;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.ide.Ide;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.ChildTableEditorPanel;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;
import oracle.olap.OLAPArb;
import oracle.olap.actions.DropCascadeAction;
import oracle.olap.actions.DropCascadeConfirmDialog;
import oracle.olap.actions.model.CascadeDeleteDimensionWrapper;
import oracle.olap.cube.model.DependentTransactionalCubes;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.cubedimension.panels.CubeDimensionHierarchyTableEditorPanel;
import oracle.olap.db.model.AbstractChildObjectWithDesc;
import oracle.olap.db.view.OLAPBaseChildTablePanel;
import oracle.olap.util.UIUtilities;

public class CubeDimensionHierarchyTablePanel<C extends CubeDimensionHierarchy, P extends CubeDimension>
extends OLAPBaseChildTablePanel<C, P>
implements DropCascadeAction {
    MyCellEditor myCellEditor;
    private final int HIERACHY_NAME_COLUMN = 0;
    private final int DEFAULT_HIERARCHY_COLUMN = 4;
    DBObjectListener hierarchyAddDeleteListener;
    private int doCascadeDelete;

    public CubeDimensionHierarchyTablePanel() {
        super("CubeDimensionHierarchyTablePanel");
        this.init();
        this.setupHierarchyAddDeleteListener();
    }

    public CubeDimensionHierarchyTablePanel(String string) {
        super(string);
        this.init();
        this.setupHierarchyAddDeleteListener();
    }

    private void setupHierarchyAddDeleteListener() {
        this.hierarchyAddDeleteListener = new DBObjectListener(){

            public void objectUpdated(DBObjectChange dBObjectChange) {
                Object object;
                CubeDimensionHierarchy[] cubeDimensionHierarchyArray;
                Object object2;
                Object object3;
                CubeDimension cubeDimension = (CubeDimension)CubeDimensionHierarchyTablePanel.this.getUpdatedObject();
                List list = dBObjectChange.getOwnedObjectsRemoved();
                if (list != null && list.size() > 0) {
                    object3 = cubeDimension;
                    for (DBObject dBObject : list) {
                        if (!(dBObject instanceof CubeDimensionHierarchy) || !((CubeDimensionHierarchy)(object2 = (CubeDimensionHierarchy)dBObject)).isHierarchyDefault() || (cubeDimensionHierarchyArray = ((CubeDimension)object3).getHierarchies()).length <= 0) continue;
                        object = cubeDimensionHierarchyArray[0];
                        ((CubeDimensionHierarchy)object).setHierarchyDefault(true);
                        ChildTableEditorPanel.ComponentWrapperTableModel componentWrapperTableModel = CubeDimensionHierarchyTablePanel.this.getWrapperTableModel();
                        componentWrapperTableModel.setValueAt((Object)Boolean.TRUE, 0, 4);
                        GenericTable genericTable = CubeDimensionHierarchyTablePanel.this.getWrapperTable();
                        genericTable.repaint();
                    }
                }
                if ((object3 = dBObjectChange.getOwnedObjectsAdded()) != null && object3.size() > 0) {
                    DBObject dBObject;
                    CubeDimension cubeDimension2 = cubeDimension;
                    dBObject = object3.iterator();
                    while (dBObject.hasNext()) {
                        object2 = (DBObject)dBObject.next();
                        if (!(object2 instanceof CubeDimensionHierarchy)) continue;
                        cubeDimensionHierarchyArray = (CubeDimensionHierarchy[])object2;
                        object = cubeDimension2.getHierarchies();
                        if (((CubeDimensionHierarchy[])object).length != 0 && ((CubeDimensionHierarchy[])object).length != 1) continue;
                        cubeDimensionHierarchyArray.setHierarchyDefault(true);
                    }
                }
            }
        };
    }

    protected boolean useSplitter() {
        return true;
    }

    protected JComponent createSplitPane(Component component, Component component2) {
        Object object;
        if (component instanceof ReorderableTableWithTitleBar) {
            object = (ReorderableTableWithTitleBar)component;
            ReorderableTableWithTitleBar reorderableTableWithTitleBar = new ReorderableTableWithTitleBar(object.getTable(), false, true);
            reorderableTableWithTitleBar.setTableToolbar(object.getTableToolbar());
            component = reorderableTableWithTitleBar;
        }
        object = new JSplitPane(this.isHorizontalSplit() ? 1 : 0, component, component2);
        ((JComponent)object).setBorder(new EmptyBorder(0, 0, 0, 0));
        ((JSplitPane)object).setDividerLocation(125);
        return object;
    }

    @Override
    protected void init() {
        this.setNameColumnIndex(0);
        PropertyDisplayRegistry propertyDisplayRegistry = PropertyDisplayRegistry.getInstance();
        propertyDisplayRegistry.registerDisplayName("hierarchies", OLAPArb.getString("CUBE_DIMENSION_HIERARCHIES"));
    }

    @Override
    protected void initialisePanel() {
        this.initImpl(this.getProvider());
        super.initialisePanel();
        ((CubeDimension)this.getUpdatedObject()).removeObjectListener(this.hierarchyAddDeleteListener);
        ((CubeDimension)this.getUpdatedObject()).addObjectListener(this.hierarchyAddDeleteListener);
    }

    protected String getChildProperty() {
        return "hierarchies";
    }

    protected Class getChildClass() {
        return CubeDimensionHierarchy.class;
    }

    protected ChildObjectEditorPanel createChildPanel() {
        return new CubeDimensionHierarchyTableEditorPanel();
    }

    @Override
    protected void initialiseComponents() {
        super.initialiseComponents();
        this.myCellEditor = new MyCellEditor();
        GenericTable genericTable = this.getWrapperTable();
        TableColumnModel tableColumnModel = genericTable.getColumnModel();
        int n = this.getNameColumnIndex();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        tableColumn.setCellEditor(this.myCellEditor);
        int n2 = this.getDescriptionColumnIndex();
        TableColumn tableColumn2 = tableColumnModel.getColumn(n2);
        tableColumn2.setCellEditor(this.myCellEditor);
        int n3 = this.getShortLabelColumnIndex();
        TableColumn tableColumn3 = tableColumnModel.getColumn(n3);
        tableColumn3.setCellEditor(this.myCellEditor);
        int n4 = this.getLongLabelColumnIndex();
        TableColumn tableColumn4 = tableColumnModel.getColumn(n4);
        tableColumn4.setCellEditor(this.myCellEditor);
        DefaultHierarchyCellRenderer defaultHierarchyCellRenderer = new DefaultHierarchyCellRenderer();
        TableColumn tableColumn5 = tableColumnModel.getColumn(4);
        tableColumn5.setCellRenderer(defaultHierarchyCellRenderer);
    }

    @Override
    protected void initialiseTableComponents() {
        super.initialiseTableComponents();
        ChildTableEditorPanel.NonPropertyColumnLogic nonPropertyColumnLogic = new ChildTableEditorPanel.NonPropertyColumnLogic<C>(){

            public void setValueAt(Object object, int n, int n2) {
                CubeDimensionHierarchyTablePanel.this.setRowPropertyValue(object, n, n2);
            }

            public Object getCellValue(C c) {
                Object c2 = c;
                return ((CubeDimensionHierarchy)c2).isHierarchyDefault();
            }

            public boolean isCellEditable(C c) {
                Object c2 = c;
                return !((CubeDimensionHierarchy)c2).isHierarchyDefault();
            }
        };
        this.addColumn(4, OLAPArb.get("BUILD.SPECIFICATION.DEFAULT.LABEL"), Boolean.class, nonPropertyColumnLogic);
    }

    @Override
    protected void setRowPropertyValue(Object object, int n, int n2) {
        ChildTableEditorPanel.ComponentWrapperTableModel componentWrapperTableModel = this.getWrapperTableModel();
        int n3 = componentWrapperTableModel.getRowCount();
        ChildTableEditorPanel.RowInfo rowInfo = componentWrapperTableModel.getRow(n);
        CubeDimensionHierarchy cubeDimensionHierarchy = (CubeDimensionHierarchy)rowInfo.getRowObject();
        switch (n2) {
            case 4: {
                Boolean bl = (Boolean)object;
                cubeDimensionHierarchy.setHierarchyDefault(bl);
                if (bl.booleanValue()) {
                    for (int i = 0; i < n3; ++i) {
                        if (i == n) continue;
                        componentWrapperTableModel.setValueAt((Object)Boolean.FALSE, i, n2);
                    }
                    componentWrapperTableModel.fireTableRowsUpdated(0, n3 - 1);
                }
                GenericTable genericTable = this.getWrapperTable();
                genericTable.repaint();
                break;
            }
            default: {
                super.setRowPropertyValue(object, n, n2);
            }
        }
    }

    @Override
    public C newChild() {
        CubeDimensionHierarchy cubeDimensionHierarchy = (CubeDimensionHierarchy)super.newChild();
        String string = cubeDimensionHierarchy.getName();
        if (string.startsWith("DIM_HIERARCHY")) {
            string = string.replace("DIM_HIERARCHY", "HIERARCHY");
        }
        cubeDimensionHierarchy.setName(string);
        cubeDimensionHierarchy.setHierarchyLevelType(true);
        cubeDimensionHierarchy.setNotSkipLevel(false);
        cubeDimensionHierarchy.setNotRagged(false);
        cubeDimensionHierarchy.setHierarchyDefault(false);
        cubeDimensionHierarchy.generateDescriptions();
        cubeDimensionHierarchy.setOriginalHierarchyName(cubeDimensionHierarchy.getName());
        ((CubeDimension)this.getUpdatedObject()).addHierarchy(cubeDimensionHierarchy);
        return (C)cubeDimensionHierarchy;
    }

    protected boolean confirmRowCanBeDeleted(int n) {
        CubeDimension cubeDimension;
        ChildTableEditorPanel.RowInfo rowInfo;
        AbstractChildObjectWithDesc abstractChildObjectWithDesc;
        boolean bl = true;
        if (this.isEditing() && !(abstractChildObjectWithDesc = (AbstractChildObjectWithDesc)(rowInfo = this.getWrapperTableModel().getRow(n)).getRowObject()).getNewObject() && (cubeDimension = (CubeDimension)this.getUpdatedObject()).getDimensionUsedInCube().equalsIgnoreCase("TRUE")) {
            CubeDimensionHierarchy cubeDimensionHierarchy = (CubeDimensionHierarchy)abstractChildObjectWithDesc;
            String string = cubeDimensionHierarchy.getOriginalHierarchyName();
            DependentTransactionalCubes dependentTransactionalCubes = DependentTransactionalCubes.getInstance();
            CascadeDeleteDimensionWrapper cascadeDeleteDimensionWrapper = dependentTransactionalCubes.handleHierarchyDelete(string);
            if (cascadeDeleteDimensionWrapper.areDependencies()) {
                DropCascadeConfirmDialog dropCascadeConfirmDialog = new DropCascadeConfirmDialog(this, cascadeDeleteDimensionWrapper, string, OLAPArb.format("DROP_HIERARCHY_CASCADE_DIALOG_TITLE", string), false, null);
                Rectangle rectangle = UIUtilities.centerWindow((Component)Ide.getMainWindow(), 650, 400);
                dropCascadeConfirmDialog.setBounds(rectangle);
                dropCascadeConfirmDialog.setVisible(true);
                if (this.doCascadeDelete == 0) {
                    dependentTransactionalCubes.confirmDelete();
                } else {
                    bl = false;
                }
            }
        }
        return bl;
    }

    @Override
    public void setUserDeleteChoice(int n) {
        this.doCascadeDelete = n;
    }

    class MyCellEditor
    extends OLAPBaseChildTablePanel.MyBaseCellEditor {
        public MyCellEditor() {
            super(CubeDimensionHierarchyTablePanel.this);
        }

        @Override
        public boolean stopCellEditing() {
            int n = CubeDimensionHierarchyTablePanel.this.getNameColumnIndex();
            if (this.column == n) {
                String string;
                boolean bl = true;
                String string2 = null;
                CubeDimension cubeDimension = (CubeDimension)this.abstractChildObjectWithDesc.getParent();
                String string3 = this.abstractChildObjectWithDesc.getName();
                String string4 = this.cellTextField.getText().toUpperCase();
                if (string4 == null || string4.length() == 0) {
                    bl = false;
                    string2 = OLAPArb.getString("CUBE_DIMENSION_HIERARCHY_NAME_VALIDATION_ERROR_MSG");
                } else {
                    try {
                        CubeDimensionHierarchyTablePanel.this.prov.validateName("DIM_HIERARCHY", string4);
                    }
                    catch (InvalidNameException invalidNameException) {
                        string2 = invalidNameException.getMessage();
                        bl = false;
                    }
                }
                if (bl && cubeDimension.findHierarchy(string = CubeDimensionHierarchyTablePanel.this.prov.getInternalName(string4)) != null && !string.equals(string3)) {
                    string2 = OLAPArb.format("VALIDATION_ERROR_DUPLICATE_HIERARCHY_NAME_MSG", string);
                    bl = false;
                }
                if (!bl) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)OLAPArb.get("CUBE_MEASURE_NAME_ERROR_TITLE"), null);
                    this.cellTextField.setText(string3);
                    return bl;
                }
                CubeDimensionHierarchyTablePanel.this.upcaseNameFlag = true;
            }
            return super.stopCellEditing();
        }
    }

    private class DefaultHierarchyCellRenderer
    extends DefaultTableCellRenderer {
        DefaultHierarchyCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setToolTipText(OLAPArb.get("BUILD.SPECIFICATION.DEFAULT.LABEL"));
            if (object != null) {
                if (object == Boolean.TRUE) {
                    jLabel.setIcon(OLAPArb.getIcon("OLAPBUILD_STATUS_DIALOG_SUCCESS"));
                    jLabel.setText(null);
                    jLabel.setHorizontalAlignment(0);
                } else {
                    jLabel.setIcon(null);
                    jLabel.setText(null);
                }
            }
            JLabel jLabel2 = jLabel;
            return jLabel2;
        }
    }
}

