/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cubebuildprocess.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.db.DBUtil;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.OLAPArb;
import oracle.olap.app.JavaXMLBind;
import oracle.olap.app.table.Queries;
import oracle.olap.build.BuildObject;
import oracle.olap.cubebuildprocess.CubeBuildProcessInitializer;
import oracle.olap.cubebuildprocess.buildprocbuilder.BuildProcBuilder;
import oracle.olap.cubebuildprocess.model.CubeBuildProcess;
import oracle.olap.cubexml.ReservedWordsSyntaxHandler;
import oracle.olap.db.view.GeneralBaseEditorPanel;
import oracle.olap.syntaxbuilder.SyntaxBuilderPanel;
import oracle.olapi.syntax.BuildItem;
import oracle.olapi.syntax.BuildProcess;
import oracle.olapi.syntax.SyntaxObject;

public class CubeBuildProcessGeneralPanel
extends GeneralBaseEditorPanel<CubeBuildProcess> {
    private static final Logger LOG = Logger.getLogger(CubeBuildProcessGeneralPanel.class.getName());
    private SyntaxBuilderPanel buildCommandExpressionEditorPanel;
    private transient BuildProcBuilder builder;
    private CubeBuildProcess cubeBuildProcess;
    private Connection conn;
    private DBObjectProvider prov;
    private boolean m_initialized = false;
    private static Queries queries;
    private static final String XMLFILE = "buildobjectqueries.xml";
    private static final String CUBE_AW_QUERY = "CUBE_AW";
    private static final String DIM_AW_QUERY = "DIMENSION_AW";
    private static final String AW_COLUMN_NAME = "AW_NAME";

    public CubeBuildProcessGeneralPanel() {
        this.layoutComponents();
        this.setDbObjectInitializer(new CubeBuildProcessInitializer());
    }

    private void layoutComponents() {
        this.registerDescriptionFields();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setName("pnlContext");
        JPanel jPanel2 = new JPanel();
        jPanel2.setName("pnlDetails");
        this.layoutDescriptionFields(jPanel);
        try {
            jPanel2 = this.getBuildItemsPanel();
        }
        catch (Throwable throwable) {
            LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
        }
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setName("pnlCenter");
        jPanel3.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        jPanel3.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.setLayout(new BorderLayout());
        this.add(jPanel3, "Center");
    }

    private JPanel getBuildItemsPanel() throws SQLException, IOException {
        JPanel jPanel = new JPanel();
        jPanel.setName("buildItemsPanel");
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = new JLabel(OLAPArb.get("BUILD.SPECIFICATION.COMMANDS.LABEL"));
        jLabel.setName("lblBuildItems");
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.builder = new BuildProcBuilder();
        this.buildCommandExpressionEditorPanel = this.builder.createBuilder();
        jPanel.add((Component)this.buildCommandExpressionEditorPanel, gridBagConstraints);
        return jPanel;
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.cubeBuildProcess = (CubeBuildProcess)this.getUpdatedObject();
        this.prov = this.getProvider();
        this.conn = this.getConnection();
        if (!this.m_initialized) {
            this.m_initialized = true;
            this.cubeBuildProcess.addObjectListener(new DBObjectListener(){

                public void objectUpdated(DBObjectChange dBObjectChange) {
                    Map map = dBObjectChange.getPropertiesChanged();
                    for (String string : map.keySet()) {
                        if (!string.equals("analyticWorkspace")) continue;
                        CubeBuildProcessGeneralPanel.this.populateExpressionEditor();
                    }
                }
            });
        }
        this.populateExpressionEditor();
    }

    private Connection getConnection() {
        Connection connection = null;
        if (this.prov instanceof OracleDatabaseImpl) {
            OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.prov;
            connection = oracleDatabaseImpl.getConnection();
        }
        return connection;
    }

    @Override
    protected void commitPanel() throws TraversalException {
        Object object;
        super.commitPanel();
        String string = this.buildCommandExpressionEditorPanel.getText();
        if (string == null || string.length() == 0) {
            String string2 = OLAPArb.format("CUBE_BUILD_PROCESS_VALIDATE_NO_ITEMS_ERROR", new Object[0]);
            throw new TraversalException(string2);
        }
        BuildItem[] buildItemArray = null;
        try {
            object = (BuildProcess)SyntaxObject.fromSyntax((String)string, null);
            buildItemArray = object.getBuildItems();
        }
        catch (Exception exception) {
            Object object2 = OLAPArb.format("CUBE_BUILD_PROCESS_VALIDATE_SYNTAX_ERROR", this.cubeBuildProcess.getName());
            object2 = (String)object2 + "  " + exception.getLocalizedMessage();
            throw new TraversalException((String)object2);
        }
        object = this.cubeBuildProcess.getAnalyticWorkspace();
        String string3 = ((CubeBuildProcess)this.getUpdatedObject()).getSchema().getName();
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.getConnection());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("owner", string3);
        String string4 = null;
        for (BuildItem buildItem : buildItemArray) {
            Map map;
            Object object3;
            String string5;
            String string6 = string5 = buildItem.getBuildObjectID();
            String string7 = null;
            if (string5.contains(".")) {
                object3 = string5.split("\\.");
                string6 = object3[1];
            }
            hashMap.put("objname", string6);
            string4 = this.getQuery(CUBE_AW_QUERY);
            object3 = dBUtil.executeReturnList(string4, hashMap);
            Object object4 = object3.iterator();
            while (object4.hasNext()) {
                map = (Map)object4.next();
                string7 = (String)map.get(AW_COLUMN_NAME);
            }
            if (string7 == null) {
                string4 = this.getQuery(DIM_AW_QUERY);
                object3 = dBUtil.executeReturnList(string4, hashMap);
                object4 = object3.iterator();
                while (object4.hasNext()) {
                    map = (Map)object4.next();
                    string7 = (String)map.get(AW_COLUMN_NAME);
                }
            }
            if (((String)object).equalsIgnoreCase(string7)) continue;
            object4 = OLAPArb.format("CUBE_BUILD_PROCESS_VALIDATE_AW_ERROR", string6, object);
            throw new TraversalException((String)object4);
        }
        this.cubeBuildProcess.setBuildItems(string);
    }

    private void populateExpressionEditor() {
        this.builder.initialize(this.conn, this.cubeBuildProcess);
        String string = this.cubeBuildProcess.getBuildItems();
        if (string == null || string.length() == 0) {
            Object object2;
            String string2 = this.cubeBuildProcess.getAnalyticWorkspace();
            String string3 = this.cubeBuildProcess.getSchema().getName();
            DBUtil dBUtil = DBUtil.getInstance((Connection)this.getConnection());
            StringBuffer stringBuffer = new StringBuffer();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("owner", string3);
            hashMap.put("awname", string2);
            String string4 = "select dimension_name from all_cube_dimensions where owner = :owner and aw_name = :awname";
            List list = dBUtil.executeReturnList(string4, hashMap);
            int n = 0;
            stringBuffer.append("BUILD ");
            for (Object object2 : list) {
                Object object3 = (String)object2.get("DIMENSION_NAME");
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                if (ReservedWordsSyntaxHandler.IsCubeSQLReservedWord((String)object3)) {
                    object3 = String.format("\"%s\"", object3);
                }
                stringBuffer.append((String)object3);
                stringBuffer.append(" USING(LOAD, COMPILE)");
                ++n;
            }
            String string5 = "select cube_name from all_cubes where owner = :owner and aw_name = :awname";
            list = dBUtil.executeReturnList(string5, hashMap);
            for (Object object3 : list) {
                String string6 = (String)object3.get("CUBE_NAME");
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                if (ReservedWordsSyntaxHandler.IsCubeSQLReservedWord(string6)) {
                    string6 = String.format("\"%s\"", string6);
                }
                stringBuffer.append(string6);
                stringBuffer.append(" USING(CLEAR, LOAD, SOLVE)");
                ++n;
            }
            string = stringBuffer.toString();
            object2 = (BuildProcess)SyntaxObject.fromSyntax((String)string, null);
            string = object2.toSyntax();
        }
        this.buildCommandExpressionEditorPanel.setText(string);
    }

    private String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = "oracle.olap.app.table";
                BuildObject buildObject = new BuildObject();
                String string3 = JavaXMLBind.LoadDocument(buildObject.getClass(), XMLFILE);
                JavaXMLBind.BindToJavaStr(string3, string2, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        CubeBuildProcessGeneralPanel.queries = queries;
    }
}

