/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.partition;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import oracle.olap.app.Resources;
import oracle.olap.app.ui.RestrictedTextField;
import oracle.olap.cube.partition.MainPartitionPanel;
import oracle.olap.cube.partition.OrderedPanel;
import oracle.olap.cube.partition.PanelComponentUIHelper;
import oracle.olap.cube.partition.model.HierarchyLevelWrapper;
import oracle.olap.cube.partition.model.PrecomputeSelection;

public class CubePartitionPrecomputePanel
extends JPanel
implements OrderedPanel {
    private Resources resources;
    private MainPartitionPanel partitionMainPanel;
    private JTable precomputeGrid;
    private DefaultTableModel tableModel;
    private int partitionCount;
    private PrecomputeCellEditor precomputeCellEditor;
    private Map<String, List<PrecomputeSelection>> precomputeSelectionsCache = new HashMap<String, List<PrecomputeSelection>>();
    private List<PrecomputeRow> precomputeRows = new ArrayList<PrecomputeRow>();
    private JLabel instructionsLabel;
    private static final int PARTITION_ORDER_COLUMN = 0;
    private static final int PARTITION_NAME_COLUMN = 1;
    private static final int PARTITION_INCLUDES_COLUMN = 2;
    private static final int PRECOMPUTE_COLUMN = 3;
    private static final int INITIAL_ROW_SIZE = 1;

    public CubePartitionPrecomputePanel(MainPartitionPanel mainPartitionPanel, Resources resources) {
        this.partitionMainPanel = mainPartitionPanel;
        this.resources = resources;
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        PanelComponentUIHelper panelComponentUIHelper = new PanelComponentUIHelper(this.resources);
        String string = "MODELER.CUBE.PARTITION.PRECOMPUTE.PANEL.INSTRUCTIONS_LABEL";
        this.instructionsLabel = panelComponentUIHelper.newJLabel(string);
        this.add((Component)this.instructionsLabel, "North");
        Object[] objectArray = new String[]{this.resources.getString("MODELER.CUBE.PARTITION.PARTITION_ORDER"), this.resources.getString("MODELER.CUBE.PARTITION.PARTITION_NAME"), this.resources.getString("MODELER.CUBE.PARTITION.PARTITION_INCLUDES"), this.resources.getString("MODELER.CUBE.PARTITION.PARTITION_PRECOMPUTE_PERCENT.COLUMN_LABEL")};
        this.tableModel = new DefaultTableModel(objectArray, 1);
        this.precomputeGrid = new JTable(this.tableModel);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.precomputeGrid);
        this.precomputeGrid.getColumnModel().getColumn(0).setPreferredWidth(75);
        this.precomputeGrid.getColumnModel().getColumn(1).setPreferredWidth(175);
        this.precomputeGrid.getColumnModel().getColumn(2).setPreferredWidth(200);
        this.precomputeGrid.getColumnModel().getColumn(3).setPreferredWidth(100);
        this.add((Component)jScrollPane, "Center");
        this.precomputeCellEditor = new PrecomputeCellEditor();
        this.precomputeGrid.setDefaultEditor(Object.class, this.precomputeCellEditor);
        this.precomputeGrid.setCellSelectionEnabled(true);
        this.partitionCount = 0;
    }

    public void clearCache() {
        this.precomputeSelectionsCache.clear();
        this.partitionCount = 0;
    }

    public void initializeCache(String string, List<PrecomputeSelection> list) {
        this.precomputeSelectionsCache.clear();
        this.precomputeSelectionsCache.put(string, list);
    }

    public void cacheCurrentSelections(String string) {
        ArrayList<PrecomputeSelection> arrayList = new ArrayList<PrecomputeSelection>();
        if (this.partitionCount > 0) {
            for (int i = 0; i < this.partitionCount; ++i) {
                String string2 = (String)this.precomputeGrid.getValueAt(i, 1);
                int n = string2.indexOf(".");
                if (n <= 0) continue;
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                String string5 = (String)this.precomputeGrid.getValueAt(i, 3);
                PrecomputeSelection precomputeSelection = new PrecomputeSelection(string3, string4, string5);
                arrayList.add(precomputeSelection);
            }
            this.precomputeSelectionsCache.put(string, arrayList);
        }
    }

    public void restoreCachedSelections(String string) {
        List<PrecomputeSelection> list = this.precomputeSelectionsCache.get(string);
        if (list != null && list.size() > 0) {
            for (PrecomputeSelection precomputeSelection : list) {
                int n = this.getRow(precomputeSelection.getHierarchyName(), precomputeSelection.getLevelName());
                if (n < 0) continue;
                String string2 = precomputeSelection.getPrecomputeValue();
                Integer n2 = Integer.parseInt(string2);
                if (n2 < 0) {
                    string2 = "0";
                }
                this.precomputeGrid.setValueAt(string2, n, 3);
            }
        }
    }

    public Integer getPrecomputeForHierarchyLevel(HierarchyLevelWrapper hierarchyLevelWrapper) {
        Integer n = null;
        int n2 = this.getRow(hierarchyLevelWrapper.getHierarchyName(), hierarchyLevelWrapper.getLevelName());
        if (n2 > -1) {
            String string = (String)this.precomputeGrid.getValueAt(n2, 3);
            if (string == null || string.length() == 0) {
                string = "0";
            }
            n = new Integer(string);
        }
        return n;
    }

    public void enableUI(boolean bl) {
        this.precomputeGrid.setEnabled(bl);
    }

    public void stopEditing() {
        this.precomputeCellEditor.stopEditing();
    }

    public void populateTable(List<HierarchyLevelWrapper> list) {
        if (this.partitionMainPanel.allowPrecomputePercentEdit()) {
            this.instructionsLabel.setVisible(true);
        } else {
            this.instructionsLabel.setVisible(false);
        }
        this.stopEditing();
        this.savePrecomputeGridForReordering();
        this.tableModel.setRowCount(0);
        this.partitionCount = 0;
        for (HierarchyLevelWrapper hierarchyLevelWrapper : list) {
            if (this.precomputeGrid.getRowCount() <= this.partitionCount) {
                this.tableModel.addRow(new Object[]{"", "", "", ""});
            }
            String string = hierarchyLevelWrapper.getHierarchyName() + "." + hierarchyLevelWrapper.getLevelName();
            this.precomputeGrid.setValueAt(Integer.valueOf(this.partitionCount + 1).toString(), this.partitionCount, 0);
            this.precomputeGrid.setValueAt(string, this.partitionCount, 1);
            this.precomputeGrid.setValueAt("40", this.partitionCount, 3);
            ++this.partitionCount;
        }
        this.restorePrecomputeValues();
    }

    protected void savePrecomputeGridForReordering() {
        this.precomputeRows = new ArrayList<PrecomputeRow>();
        for (int i = 0; i < this.partitionCount; ++i) {
            String string = (String)this.precomputeGrid.getValueAt(i, 1);
            int n = string.indexOf(".");
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            String string4 = (String)this.precomputeGrid.getValueAt(i, 3);
            PrecomputeRow precomputeRow = new PrecomputeRow(string2, string3, string4);
            this.precomputeRows.add(precomputeRow);
        }
    }

    private void restorePrecomputeValues() {
        for (PrecomputeRow precomputeRow : this.precomputeRows) {
            int n;
            String string = precomputeRow.hierarchyName;
            String string2 = precomputeRow.levelName;
            String string3 = precomputeRow.precomputeValue;
            int n2 = Integer.parseInt(string3);
            if (n2 < 0) {
                string3 = "0";
            }
            if ((n = this.getRow(string, string2)) < 0) continue;
            this.precomputeGrid.setValueAt(string3, n, 3);
        }
    }

    public void refreshPartitionLevelNames(List<HierarchyLevelWrapper> list, List<String> list2) {
        int n = 0;
        for (HierarchyLevelWrapper hierarchyLevelWrapper : list) {
            int n2 = this.getRow(hierarchyLevelWrapper.getHierarchyName(), hierarchyLevelWrapper.getLevelName());
            if (n2 > -1) {
                this.precomputeGrid.setValueAt(list2.get(n), n2, 2);
            }
            ++n;
        }
    }

    protected int getRow(String string, String string2) {
        int n = -1;
        for (int i = 0; i < this.partitionCount; ++i) {
            String string3 = (String)this.precomputeGrid.getValueAt(i, 1);
            int n2 = string3.indexOf(".");
            String string4 = string3.substring(0, n2);
            String string5 = string3.substring(n2 + 1);
            if (!string.equalsIgnoreCase(string4) || !string2.equalsIgnoreCase(string5)) continue;
            n = i;
            break;
        }
        return n;
    }

    private void reflectReorderOperation() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.partitionCount; ++i) {
            arrayList.add((String)this.precomputeGrid.getValueAt(i, 1));
        }
        this.partitionMainPanel.reorderPartitionSelections(arrayList);
    }

    @Override
    public void upArrowSelected() {
        int n = this.precomputeGrid.getSelectedRow();
        if (n == -1) {
            return;
        }
        if (n == 0) {
            return;
        }
        if (n >= this.partitionCount) {
            return;
        }
        String string = (String)this.precomputeGrid.getValueAt(n - 1, 1);
        String string2 = (String)this.precomputeGrid.getValueAt(n - 1, 2);
        String string3 = (String)this.precomputeGrid.getValueAt(n - 1, 3);
        String string4 = (String)this.precomputeGrid.getValueAt(n, 1);
        String string5 = (String)this.precomputeGrid.getValueAt(n, 2);
        String string6 = (String)this.precomputeGrid.getValueAt(n, 3);
        this.precomputeGrid.setValueAt(string4, n - 1, 1);
        this.precomputeGrid.setValueAt(string5, n - 1, 2);
        this.precomputeGrid.setValueAt(string6, n - 1, 3);
        this.precomputeGrid.setValueAt(string, n, 1);
        this.precomputeGrid.setValueAt(string2, n, 2);
        this.precomputeGrid.setValueAt(string3, n, 3);
        this.precomputeGrid.setRowSelectionInterval(n - 1, n - 1);
        this.reflectReorderOperation();
        this.partitionMainPanel.fieldValueChanged();
    }

    @Override
    public void downArrowSelected() {
        int n = this.precomputeGrid.getSelectedRow();
        if (n == -1) {
            return;
        }
        if (n >= this.partitionCount - 1) {
            return;
        }
        String string = (String)this.precomputeGrid.getValueAt(n + 1, 1);
        String string2 = (String)this.precomputeGrid.getValueAt(n + 1, 2);
        String string3 = (String)this.precomputeGrid.getValueAt(n + 1, 3);
        String string4 = (String)this.precomputeGrid.getValueAt(n, 1);
        String string5 = (String)this.precomputeGrid.getValueAt(n, 2);
        String string6 = (String)this.precomputeGrid.getValueAt(n, 3);
        this.precomputeGrid.setValueAt(string4, n + 1, 1);
        this.precomputeGrid.setValueAt(string5, n + 1, 2);
        this.precomputeGrid.setValueAt(string6, n + 1, 3);
        this.precomputeGrid.setValueAt(string, n, 1);
        this.precomputeGrid.setValueAt(string2, n, 2);
        this.precomputeGrid.setValueAt(string3, n, 3);
        this.precomputeGrid.setRowSelectionInterval(n + 1, n + 1);
        this.reflectReorderOperation();
        this.partitionMainPanel.fieldValueChanged();
    }

    private class PrecomputeCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private RestrictedTextField precomputeTextField = new RestrictedTextField();
        private int currentColumn;
        private int currentRow;

        public PrecomputeCellEditor() {
            this.precomputeTextField.setFilterMode(2);
            this.precomputeTextField.setMaximumLength(3);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.currentColumn = n2;
            this.currentRow = n;
            if (!CubePartitionPrecomputePanel.this.partitionMainPanel.allowPrecomputePercentEdit()) {
                return null;
            }
            if (!CubePartitionPrecomputePanel.this.partitionMainPanel.isCompressed()) {
                return null;
            }
            if (n2 == 3 && this.currentRow < CubePartitionPrecomputePanel.this.partitionCount) {
                this.precomputeTextField.setText((String)CubePartitionPrecomputePanel.this.precomputeGrid.getValueAt(n, 3));
                if (this.precomputeTextField.getText().length() > 0) {
                    this.precomputeTextField.select(0, this.precomputeTextField.getText().length());
                }
                return this.precomputeTextField;
            }
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.currentColumn == 3 && this.currentRow < CubePartitionPrecomputePanel.this.partitionCount) {
                int n;
                String string = this.precomputeTextField.getText();
                if (string != null && string.length() == 3 && (n = Integer.parseInt(string)) > 100) {
                    this.precomputeTextField.setText("100");
                }
                if (string == null || string.length() == 0) {
                    this.precomputeTextField.setText("0");
                }
                CubePartitionPrecomputePanel.this.partitionMainPanel.fieldValueChanged();
                return this.precomputeTextField.getText();
            }
            return null;
        }

        public void stopEditing() {
            this.fireEditingStopped();
        }
    }

    private class PrecomputeRow {
        protected String hierarchyName;
        protected String levelName;
        protected String precomputeValue;

        public PrecomputeRow(String string, String string2, String string3) {
            this.hierarchyName = string;
            this.levelName = string2;
            this.precomputeValue = string3;
        }
    }
}

