/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.partition;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import oracle.dss.dataView.UIView;
import oracle.dss.graph.Graph;
import oracle.dss.graph.gui.GraphToolBar;
import oracle.dss.util.DataSource;
import oracle.olap.app.ErrorDisplay;
import oracle.olap.app.Resources;
import oracle.olap.app.ui.GroupCheckBoxSelection;
import oracle.olap.app.util.CursorUtil;
import oracle.olap.cube.partition.MainPartitionPanel;
import oracle.olap.cube.partition.PartitionDataSource;
import oracle.olap.cube.partition.model.PartitionHierarchyLevelHelper;
import oracle.olap.cube.partition.model.PartitionMemberAndCount;
import oracle.olap.cube.partition.model.PartitionQueryCancelExecuteContext;
import oracle.olap.cube.partition.query.CubePartitionQuery;

public class CubePartitionMemberAnalysisPanel
extends JPanel
implements ListSelectionListener {
    private Resources resources;
    private ErrorDisplay errorDisplay;
    private MainPartitionPanel mainPartitionPanel;
    private JTable partitionTable;
    private DefaultTableModel partitionTableModel;
    private String currentOwner;
    private String currentDimensionName;
    private List<GroupCheckBoxSelection> selections = new ArrayList<GroupCheckBoxSelection>();
    private PartitionHierarchyLevelHelper partitionHierarchyLevelHelper;
    private Graph graph;
    private PartitionDataSource pds;
    private int lastRow;
    private int lastColumn;
    private int row;
    private boolean skipValueChanged = false;

    public CubePartitionMemberAnalysisPanel(MainPartitionPanel mainPartitionPanel, PartitionHierarchyLevelHelper partitionHierarchyLevelHelper, Resources resources, ErrorDisplay errorDisplay) {
        this.mainPartitionPanel = mainPartitionPanel;
        this.partitionHierarchyLevelHelper = partitionHierarchyLevelHelper;
        this.resources = resources;
        this.errorDisplay = errorDisplay;
        this.jbInit();
        this.lastRow = 0;
        this.lastColumn = 0;
    }

    public void setPartitionHierarchyLevelHelper(PartitionHierarchyLevelHelper partitionHierarchyLevelHelper) {
        this.partitionHierarchyLevelHelper = partitionHierarchyLevelHelper;
    }

    public synchronized void updateUI(String string, String string2, List<GroupCheckBoxSelection> list) {
        CubePartitionQuery cubePartitionQuery = null;
        if (this.currentDimensionName != null && !this.currentDimensionName.equals(string2)) {
            this.lastRow = 0;
            this.setRowSelectionInterval(0, 0);
        }
        this.currentOwner = string;
        this.currentDimensionName = string2;
        this.selections = list;
        if (this.currentDimensionName != null) {
            Connection connection = this.mainPartitionPanel.getConnection();
            cubePartitionQuery = new CubePartitionQuery(connection, this.resources, this.mainPartitionPanel.getDimensionAWObjects());
        }
        if (this.currentDimensionName != null) {
            this.populatePartitionTableWithAllPartitions(cubePartitionQuery);
            if (!cubePartitionQuery.getIsInterrupted()) {
                if (list.size() > 0) {
                    if (this.lastRow > 0) {
                        if (list.size() < this.lastRow + 1) {
                            this.lastRow = 0;
                            this.setRowSelectionInterval(0, 0);
                            this.refreshGraphFromRow(0);
                        } else {
                            this.setRowSelectionInterval(this.lastRow, this.lastRow);
                            this.refreshGraphFromRow(this.lastRow);
                        }
                    } else {
                        this.setRowSelectionInterval(0, 0);
                        this.refreshGraphFromRow(0);
                    }
                } else {
                    this.lastRow = 0;
                    this.setRowSelectionInterval(0, 0);
                }
            }
        } else {
            this.lastRow = 0;
            this.setRowSelectionInterval(0, 0);
        }
    }

    private void setRowSelectionInterval(int n, int n2) {
        final int n3 = n;
        final int n4 = n2;
        if (SwingUtilities.isEventDispatchThread()) {
            this.partitionTable.setRowSelectionInterval(n3, n4);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        CubePartitionMemberAnalysisPanel.this.partitionTable.setRowSelectionInterval(n3, n4);
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void refreshGraphFromRow(int n) {
        String string = (String)this.partitionTable.getValueAt(n, 0);
        if (string == null) {
            return;
        }
        int n2 = string.indexOf(".");
        if (n2 == -1) {
            return;
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        Connection connection = this.mainPartitionPanel.getConnection();
        CubePartitionQuery cubePartitionQuery = new CubePartitionQuery(connection, this.resources, this.mainPartitionPanel.getDimensionAWObjects());
        CursorUtil.setBusyCursor(this);
        this.updateGraphForPartition(cubePartitionQuery, string2, string3);
        CursorUtil.setDefaultCursor(this);
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.fill = 2;
        this.graph = new Graph();
        this.graph.setGraphType(18);
        Locale locale = Locale.getDefault();
        this.graph.setLocale(locale);
        this.pds = new PartitionDataSource();
        this.graph.setDataSource((DataSource)this.pds);
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setOrientation(0);
        jSplitPane.setTopComponent(this.getPartitionTablePanel());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GraphToolBar graphToolBar = new GraphToolBar();
        graphToolBar.setLocale(Locale.getDefault());
        graphToolBar.setDataView((UIView)this.graph);
        jPanel.add((Component)graphToolBar, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.graph, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jSplitPane.setBottomComponent(jPanel);
        jSplitPane.setDividerLocation(200);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)jSplitPane, gridBagConstraints);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.skipValueChanged) {
            return;
        }
        int n = this.partitionTable.getSelectedRow();
        int n2 = this.partitionTable.getSelectedColumn();
        boolean bl = listSelectionEvent.getValueIsAdjusting();
        String string = (String)this.partitionTable.getValueAt(n, 0);
        if (string == null || string.length() == 0) {
            return;
        }
        if (n == this.lastRow) {
            return;
        }
        this.lastRow = n;
        this.lastColumn = n2;
        int n3 = string.indexOf(".");
        String string2 = string.substring(0, n3);
        String string3 = string.substring(n3 + 1);
        Connection connection = this.mainPartitionPanel.getConnection();
        CubePartitionQuery cubePartitionQuery = new CubePartitionQuery(connection, this.resources, this.mainPartitionPanel.getDimensionAWObjects());
        CursorUtil.setBusyCursor(this);
        cubePartitionQuery.setBusy(true);
        this.updateGraphForPartition(cubePartitionQuery, string2, string3);
        cubePartitionQuery.setBusy(false);
        CursorUtil.setDefaultCursor(this);
    }

    private synchronized void updateGraphForPartition(CubePartitionQuery cubePartitionQuery, String string, String string2) {
        Object object;
        String string3;
        List<PartitionMemberAndCount> list;
        int n;
        boolean bl = false;
        String string4 = null;
        String string5 = null;
        Object[] objectArray = this.getPartitionResults(cubePartitionQuery, string, string2, true);
        string4 = this.partitionHierarchyLevelHelper.getHierarchyViewName(this.currentDimensionName, string);
        Connection connection = this.mainPartitionPanel.getConnection();
        string5 = this.getAttributeDescriptionColumnName(connection, string);
        if (string5 != null) {
            bl = true;
        }
        if ((n = (list = cubePartitionQuery.getPartitionCountsFromQuery(string3 = this.mainPartitionPanel.getOwner(), bl, string4, string5)).size()) == 0) {
            n = 1;
        }
        int n2 = this.getHierLevelDepthFromStartingLevel(string, string2);
        double[][] dArray = new double[n2][n];
        String[] stringArray = new String[n];
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            String[] stringArray2 = ((PartitionMemberAndCount)object).getPartitionBreakout() == null || ((PartitionMemberAndCount)object).getPartitionBreakout().length() == 0 ? new String[]{"0"} : ((PartitionMemberAndCount)object).getPartitionBreakout().split(",");
            int n3 = 0;
            for (int j = n2 - 1; j >= 0; --j) {
                if (stringArray2.length >= n3 + 1) {
                    int n4 = Integer.parseInt(stringArray2[n3]);
                    dArray[j][i] = n4;
                } else {
                    dArray[j][i] = 0.0;
                }
                ++n3;
            }
            stringArray[i] = ((PartitionMemberAndCount)object).getPartitionMember();
        }
        String[] stringArray3 = this.getLevelNamesFromStartingLevel(string, string2);
        this.pds = new PartitionDataSource(n, n2, stringArray, dArray, stringArray3);
        object = string;
        String string6 = string2;
        final double[][] dArray2 = dArray;
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ String val$hierarchyName2;
            final /* synthetic */ String val$levelName2;
            {
                this.val$hierarchyName2 = string;
                this.val$levelName2 = string2;
            }

            @Override
            public void run() {
                if (!CubePartitionMemberAnalysisPanel.this.isDataAtAnyPartitionLevelEmpty(dArray2)) {
                    CubePartitionMemberAnalysisPanel.this.graph.setGraphType(18);
                } else {
                    CubePartitionMemberAnalysisPanel.this.graph.setGraphType(17);
                }
                CubePartitionMemberAnalysisPanel.this.graph.set3DEffect(true);
                CubePartitionMemberAnalysisPanel.this.graph.setDataSource((DataSource)CubePartitionMemberAnalysisPanel.this.pds);
                CubePartitionMemberAnalysisPanel.this.graph.getTitle().setText(CubePartitionMemberAnalysisPanel.this.resources.getString("CUBE.PARTITION.ANALYSIS.REPORT.TITLE", this.val$hierarchyName2 + "." + this.val$levelName2));
                CubePartitionMemberAnalysisPanel.this.graph.getY1Title().setText(CubePartitionMemberAnalysisPanel.this.resources.getString("CUBE.PARTITION.ANALYSIS.REPORT.MEMBER_COUNT.LABEL"));
                CubePartitionMemberAnalysisPanel.this.graph.getO1Title().setText(CubePartitionMemberAnalysisPanel.this.resources.getString("CUBE.PARTITION.ANALYSIS.REPORT.PARTITION_MEMBERS.LABEL"));
                CubePartitionMemberAnalysisPanel.this.graph.revalidate();
                CubePartitionMemberAnalysisPanel.this.graph.repaint();
            }
        });
    }

    private String getAttributeDescriptionColumnName(Connection connection, String string) {
        String string2 = null;
        try {
            string2 = this.partitionHierarchyLevelHelper.getAttributeDescriptionColumnName(connection, this.currentOwner, this.currentDimensionName, string);
        }
        catch (SQLException sQLException) {
            this.errorDisplay.show(sQLException, this.resources.getString("CUBE.PARTITION.QUERY.DESC.COLUMN.ERROR.TITLE"), this.resources.getString("CUBE.PARTITION.QUERY.DESC.COLUMN.ERROR.MSG") + sQLException, this);
        }
        catch (IOException iOException) {
            this.errorDisplay.show(iOException, this.resources.getString("CUBE.PARTITION.QUERY.DESC.COLUMN.ERROR.TITLE"), this.resources.getString("CUBE.PARTITION.QUERY.DESC.COLUMN.ERROR.MSG") + iOException, this);
        }
        return string2;
    }

    private boolean isDataAtAnyPartitionLevelEmpty(double[][] dArray) {
        boolean bl = false;
        for (double[] dArray2 : dArray) {
            boolean bl2 = false;
            for (double d : dArray2) {
                if (!(d > 0.0)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void populatePartitionTableWithAllPartitions(CubePartitionQuery cubePartitionQuery) {
        cubePartitionQuery.setBusy(true);
        cubePartitionQuery.createOrReplaceDMLReportPartitions();
        cubePartitionQuery.createOrReplacePartitionInformationView();
        this.clearPartitionTable();
        this.skipValueChanged = true;
        this.setRowSelectionInterval(0, 0);
        this.skipValueChanged = false;
        this.row = 0;
        for (GroupCheckBoxSelection groupCheckBoxSelection : this.selections) {
            String string = groupCheckBoxSelection.getColumnName();
            String string2 = groupCheckBoxSelection.getCheckBoxName();
            Object[] objectArray = this.getPartitionResults(cubePartitionQuery, string, string2, false);
            if (cubePartitionQuery.getIsInterrupted() || objectArray == null) continue;
            Integer n = (Integer)objectArray[0];
            Integer n2 = (Integer)objectArray[1];
            Integer n3 = (Integer)objectArray[2];
            Integer n4 = (Integer)objectArray[3];
            Double d = (Double)objectArray[4];
            Double d2 = (Double)objectArray[5];
            d = this.roundDoubleValue(d);
            d2 = this.roundDoubleValue(d2);
            final String string3 = string;
            final String string4 = string2;
            final Integer n5 = n;
            final Integer n6 = n2;
            final Integer n7 = n3;
            final Integer n8 = n4;
            final Double d3 = d;
            final Double d4 = d2;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (CubePartitionMemberAnalysisPanel.this.partitionTable.getRowCount() <= CubePartitionMemberAnalysisPanel.this.row + 1) {
                            CubePartitionMemberAnalysisPanel.this.partitionTableModel.addRow(new Object[0]);
                        }
                        CubePartitionMemberAnalysisPanel.this.partitionTable.setValueAt(string3 + "." + string4, CubePartitionMemberAnalysisPanel.this.row, 0);
                        CubePartitionMemberAnalysisPanel.this.partitionTable.setValueAt(n5.toString(), CubePartitionMemberAnalysisPanel.this.row, 1);
                        CubePartitionMemberAnalysisPanel.this.partitionTable.setValueAt(n6.toString(), CubePartitionMemberAnalysisPanel.this.row, 2);
                        CubePartitionMemberAnalysisPanel.this.partitionTable.setValueAt(n7.toString(), CubePartitionMemberAnalysisPanel.this.row, 3);
                        CubePartitionMemberAnalysisPanel.this.partitionTable.setValueAt(n8.toString(), CubePartitionMemberAnalysisPanel.this.row, 4);
                        CubePartitionMemberAnalysisPanel.this.partitionTable.setValueAt(d3.toString(), CubePartitionMemberAnalysisPanel.this.row, 5);
                        CubePartitionMemberAnalysisPanel.this.partitionTable.setValueAt(d4.toString(), CubePartitionMemberAnalysisPanel.this.row, 6);
                        if (CubePartitionMemberAnalysisPanel.this.partitionTable.getRowCount() <= CubePartitionMemberAnalysisPanel.this.row + 1) {
                            CubePartitionMemberAnalysisPanel.this.partitionTableModel.addRow(new Object[0]);
                        }
                        ++CubePartitionMemberAnalysisPanel.this.row;
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        cubePartitionQuery.setBusy(false);
        if (!cubePartitionQuery.getIsInterrupted()) {
            PartitionQueryCancelExecuteContext partitionQueryCancelExecuteContext = PartitionQueryCancelExecuteContext.getInstance();
            partitionQueryCancelExecuteContext.resetCancel();
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    int n = CubePartitionMemberAnalysisPanel.this.partitionTable.getRowCount();
                    int n2 = CubePartitionMemberAnalysisPanel.this.row - 1;
                    for (int i = n - 1; i > n2; --i) {
                        CubePartitionMemberAnalysisPanel.this.partitionTableModel.removeRow(i);
                    }
                    CubePartitionMemberAnalysisPanel.this.partitionTable.invalidate();
                    CubePartitionMemberAnalysisPanel.this.partitionTable.repaint();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void clearPartitionTable() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.clearPartitionTableImpl();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        CubePartitionMemberAnalysisPanel.this.clearPartitionTableImpl();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void clearPartitionTableImpl() {
        for (int i = 0; i < this.partitionTable.getRowCount(); ++i) {
            for (int j = 0; j < this.partitionTable.getColumnCount(); ++j) {
                this.partitionTable.setValueAt("", i, j);
            }
        }
    }

    private Object[] getPartitionResults(CubePartitionQuery cubePartitionQuery, String string, String string2, boolean bl) {
        if (cubePartitionQuery.getIsInterrupted()) {
            Object[] objectArray = null;
            return objectArray;
        }
        boolean bl2 = true;
        for (GroupCheckBoxSelection groupCheckBoxSelection : this.selections) {
            String string3 = groupCheckBoxSelection.getColumnName();
            String string4 = groupCheckBoxSelection.getCheckBoxName();
            String string5 = this.getLevelNamesAsListFromStartingLevel(string3, string4);
            if (cubePartitionQuery.getIsInterrupted()) continue;
            cubePartitionQuery.executeReportPartitionsProgram(this.currentDimensionName, string3, string4, string5, bl2, bl);
            if (string3.equalsIgnoreCase(string) && string4.equalsIgnoreCase(string2)) break;
            bl2 = false;
        }
        Object[] objectArray = null;
        if (!cubePartitionQuery.getIsInterrupted()) {
            objectArray = cubePartitionQuery.getPartitionSummaryResultsFromQuery();
        }
        return objectArray;
    }

    private JPanel getPartitionTablePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        gridBagConstraints.fill = 1;
        Vector<String> vector = new Vector<String>();
        vector.add(this.resources.getString("CUBE.PARTITION.ANALYSIS.REPORT.COLUMN.PARTITION_NAME.LABEL"));
        vector.add(this.resources.getString("CUBE.PARTITION.ANALYSIS.REPORT.COLUMN.NUMBER_PARTITIONS.LABEL"));
        vector.add(this.resources.getString("CUBE.PARTITION.ANALYSIS.REPORT.COLUMN.TOTAL_MEMBERS.LABEL"));
        vector.add(this.resources.getString("CUBE.PARTITION.ANALYSIS.REPORT.COLUMN.MINIMUM_MEMBERS.LABEL"));
        vector.add(this.resources.getString("CUBE.PARTITION.ANALYSIS.REPORT.COLUMN.MAXIMUM_MEMBERS.LABEL"));
        vector.add(this.resources.getString("CUBE.PARTITION.ANALYSIS.REPORT.COLUMN.AVERAGE_MEMBERS.LABEL"));
        vector.add(this.resources.getString("CUBE.PARTITION.ANALYSIS.REPORT.COLUMN.STANDARD_DEVIATION.LABEL"));
        this.partitionTableModel = new DefaultTableModel(vector, 1){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.partitionTable = new JTable(this.partitionTableModel);
        this.partitionTable.getSelectionModel().addListSelectionListener(this);
        this.customizeColumnWidths();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.partitionTable);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        return jPanel;
    }

    private void customizeColumnWidths() {
        this.partitionTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.partitionTable.getColumnModel().getColumn(1).setPreferredWidth(75);
        this.partitionTable.getColumnModel().getColumn(2).setPreferredWidth(75);
        this.partitionTable.getColumnModel().getColumn(3).setPreferredWidth(75);
        this.partitionTable.getColumnModel().getColumn(4).setPreferredWidth(75);
        this.partitionTable.getColumnModel().getColumn(5).setPreferredWidth(75);
        this.partitionTable.getColumnModel().getColumn(6).setPreferredWidth(75);
    }

    private int getHierLevelDepthFromStartingLevel(String string, String string2) {
        return this.partitionHierarchyLevelHelper.getHierLevelDepthFromStartingLevel(this.currentDimensionName, string, string2);
    }

    private String[] getLevelNamesFromStartingLevel(String string, String string2) {
        return this.partitionHierarchyLevelHelper.getLevelNamesFromStartingLevel(this.currentDimensionName, string, string2);
    }

    private String getLevelNamesAsListFromStartingLevel(String string, String string2) {
        return this.partitionHierarchyLevelHelper.getLevelNamesAsListFromStartingLevel(this.currentDimensionName, string, string2);
    }

    private double roundDoubleValue(double d) {
        double d2 = d * 1000.0;
        d2 = Math.rint(d2);
        double d3 = d2 / 1000.0;
        return d3;
    }
}

