/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels.aggregation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import oracle.olap.OLAPArb;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeMeasure;
import oracle.olap.syntax.AggregationOperatorMap;
import oracle.olap.syntax.CubeAggregationDimension;
import oracle.olap.util.OLAPListTableModel;

public class AggregationOperatorTableModel
extends OLAPListTableModel<CubeAggregationDimension>
implements TableModelListener {
    private AggregationOperatorMap aggOperatorMap;
    private List<PropertyChangeListener> propertyChangeListeners = new ArrayList<PropertyChangeListener>();
    private boolean isPropertyChangeListenersOn = true;
    public static final int ORDER = 0;
    public static final int DIMENSION = 1;
    public static final int OPERATOR = 2;
    public static final int BASEDON = 3;
    public static final int AGGLEVEL = 4;
    private static final String[] COL_NAMES = new String[]{OLAPArb.get("DIMENSION.AGGOP.ORDER"), OLAPArb.get("DIMENSION.AGGOP.DIMENSION"), OLAPArb.get("DIMENSION.AGGOP.OPERATOR"), OLAPArb.get("DIMENSION.AGGOP.BASED_ON"), OLAPArb.get("DIMENSION.AGGOP.FROM.LEVEL")};
    private static final String[] COL_TIPS = new String[]{OLAPArb.get("DIMENSION.AGGOP.ORDER"), OLAPArb.get("DIMENSION.AGGOP.DIMENSION"), OLAPArb.get("DIMENSION.AGGOP.OPERATOR"), OLAPArb.get("DIMENSION.AGGOP.BASED_ON"), OLAPArb.get("DIMENSION.AGGOP.FROM.LEVEL")};

    public AggregationOperatorTableModel(AggregationOperatorMap aggregationOperatorMap) {
        super(COL_NAMES, COL_TIPS);
        this.aggOperatorMap = aggregationOperatorMap;
        this.addTableModelListener(this);
    }

    public void setTable(JTable jTable) {
        super.setTable(jTable);
        jTable.setSurrendersFocusOnKeystroke(true);
    }

    @Override
    protected Object getValueAt(CubeAggregationDimension cubeAggregationDimension, int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = cubeAggregationDimension.getAggregationOrder();
                break;
            }
            case 1: {
                String string2;
                string = string2 = cubeAggregationDimension.getName();
                break;
            }
            case 2: {
                String string3;
                String string4 = cubeAggregationDimension.getAggregationOperator();
                string = string3 = (String)this.aggOperatorMap.get(string4);
                break;
            }
            case 3: {
                String string5;
                string = string5 = cubeAggregationDimension.getAggregationBasedOnMeasure();
                break;
            }
            case 4: {
                String string6 = cubeAggregationDimension.getAggregationFromLevel();
                if (string6 == null) {
                    string6 = OLAPArb.get("AGGREGATE.FROM.LEVEL.DEFAULT");
                }
                string = string6;
            }
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    protected void setValueAt(Object object, CubeAggregationDimension cubeAggregationDimension, int n) {
        PropertyChangeEvent propertyChangeEvent = null;
        switch (n) {
            case 0: {
                cubeAggregationDimension.setAggregationOrder((Integer)object);
                break;
            }
            case 1: {
                cubeAggregationDimension.setName((String)object);
                break;
            }
            case 2: {
                String string = (String)object;
                String string2 = this.aggOperatorMap.reverseGet(string);
                String string3 = cubeAggregationDimension.getAggregationOperator();
                cubeAggregationDimension.setAggregationOperator(string2);
                if (!this.aggOperatorMap.isWeightedAggOperator(string2)) {
                    cubeAggregationDimension.setAggregationBasedOnMeasure("");
                } else {
                    Cube cube;
                    CubeMeasure[] cubeMeasureArray;
                    String string4 = cubeAggregationDimension.getAggregationBasedOnMeasure();
                    if ((string4 == null || string4 != null && string4.length() == 0) && (cubeMeasureArray = (cube = cubeAggregationDimension.getCube()).getMeasures()) != null && cubeMeasureArray.length > 0) {
                        string4 = String.format("%s.%s", cube.getName(), cubeMeasureArray[0].getName());
                        cubeAggregationDimension.setAggregationBasedOnMeasure(string4);
                    }
                }
                if (string2.equalsIgnoreCase("NOAGG")) {
                    cubeAggregationDimension.setAggregationFromLevel(null);
                    propertyChangeEvent = new PropertyChangeEvent(this, "NODE_UNSELECTED", null, cubeAggregationDimension);
                    this.firePropertyChangeEvent(propertyChangeEvent);
                    break;
                }
                if (!string3.equalsIgnoreCase("NOAGG")) break;
                cubeAggregationDimension.setAggregationFromLevel(null);
                propertyChangeEvent = new PropertyChangeEvent(this, "NODE_SELECTED", null, cubeAggregationDimension);
                this.firePropertyChangeEvent(propertyChangeEvent);
                break;
            }
            case 3: {
                cubeAggregationDimension.setAggregationBasedOnMeasure((String)object);
                break;
            }
            case 4: {
                String string = ((String)object).trim();
                if (string.equalsIgnoreCase(OLAPArb.get("AGGREGATE.FROM.LEVEL.DEFAULT"))) {
                    string = null;
                }
                cubeAggregationDimension.setAggregationFromLevel(string);
                break;
            }
        }
    }

    @Override
    protected boolean isCellEditable(CubeAggregationDimension cubeAggregationDimension, int n) {
        String string = null;
        String string2 = null;
        string = (String)this.getValueAt(cubeAggregationDimension, 2);
        string2 = this.aggOperatorMap.reverseGet(string);
        switch (n) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
            case 3: {
                return this.aggOperatorMap.isWeightedAggOperator(string2);
            }
            case 4: {
                return !string2.equalsIgnoreCase("NOAGG");
            }
        }
        return false;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        List list = this.getRowList();
        int n = 0;
        for (Object e : list) {
            if (!(e instanceof CubeAggregationDimension)) continue;
            CubeAggregationDimension cubeAggregationDimension = (CubeAggregationDimension)e;
            this.setValueAt((Object)(++n), cubeAggregationDimension, 0);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (!this.propertyChangeListeners.contains(propertyChangeListener)) {
            this.propertyChangeListeners.add(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeListeners.contains(propertyChangeListener)) {
            this.propertyChangeListeners.remove(propertyChangeListener);
        }
    }

    public void removeAllPropertyChangeListeners() {
        this.propertyChangeListeners.clear();
    }

    public void enablePropertyChangeListeners(boolean bl) {
        this.isPropertyChangeListenersOn = bl;
    }

    private void firePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        if (this.isPropertyChangeListenersOn) {
            for (PropertyChangeListener propertyChangeListener : this.propertyChangeListeners) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
    }
}

