/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels.aggregation;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Database;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.olap.OLAPArb;
import oracle.olap.cube.CubeBuilder;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeDimensionality;
import oracle.olap.cube.model.CubeMeasure;
import oracle.olap.cube.panels.aggregation.AggregationOperatorTableModel;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.cubedimension.model.CubeDimensionHierarchyLevel;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.db.model.AbstractChildObjectWithDesc;
import oracle.olap.db.view.DimensionNode;
import oracle.olap.db.view.HierarchyNode;
import oracle.olap.syntax.AggregationOperatorMap;
import oracle.olap.syntax.CubeAggregationDimension;
import oracle.olap.util.OLAPListTableModel;
import oracle.olap.util.OLAPListTablePanel;

public class AggregationOperatorPanel
extends JPanel
implements PropertyChangeListener {
    private OLAPListTablePanel<CubeAggregationDimension> aggOperatorTablePanel;
    private AggregationOperatorTableModel aggregationTableModel;
    private DefaultComboBoxModel measuresComboBoxModel;
    private AggregationOperatorMap aggOperatorMap;
    private Cube cube;
    private Object allDimensionListObject;
    private OracleDatabaseImpl oraDb;
    private CubeBuilder cubeBuilder;
    private final Logger LOG = Logger.getLogger(AggregationOperatorPanel.class.getName());

    public AggregationOperatorPanel() {
        this.aggOperatorMap = new AggregationOperatorMap();
        this.aggregationTableModel = new AggregationOperatorTableModel(this.aggOperatorMap);
        this.measuresComboBoxModel = new DefaultComboBoxModel();
        this.layoutComponents();
    }

    public void initialisePanel(OracleDatabaseImpl oracleDatabaseImpl, Cube cube, Object object, List<CubeAggregationDimension> list) {
        this.cube = cube;
        this.allDimensionListObject = object;
        this.setDatabase(oracleDatabaseImpl);
        CubeAggregationDimension[] cubeAggregationDimensionArray = new CubeAggregationDimension[list.size()];
        List<Object> list2 = new ArrayList();
        for (CubeAggregationDimension cubeAggregationDimension : list) {
            String string = cubeAggregationDimension.getAggregationOrder();
            int n = Integer.valueOf(string);
            cubeAggregationDimensionArray[n - 1] = cubeAggregationDimension;
        }
        list2 = Arrays.asList(cubeAggregationDimensionArray);
        this.aggregationTableModel.setRowList(list2);
        this.measuresComboBoxModel.removeAllElements();
        if (this.isEnabled()) {
            CubeAggregationDimension cubeAggregationDimension;
            LoadLikeDimensionedMeasures loadLikeDimensionedMeasures = new LoadLikeDimensionedMeasures();
            cubeAggregationDimension = new QueryWrapper((Database)oracleDatabaseImpl, "select cube_name from all_cubes where aw_name = ? and owner = ?", new Object[]{cube.getAnalyticWorkspace(), cube.getSchema().getName()});
            try {
                cubeAggregationDimension.executeQuery(loadLikeDimensionedMeasures);
            }
            catch (DBException dBException) {
                this.LOG.log(Level.SEVERE, dBException.getStackTrace()[0].toString(), dBException);
            }
        }
    }

    public AggregationOperatorMap getAggregationOperatorMap() {
        return this.aggOperatorMap;
    }

    public void setEnablePanel(boolean bl) {
        this.aggregationTableModel.setEditable(bl);
        this.aggOperatorTablePanel.setEditable(bl);
        this.aggOperatorTablePanel.setEnabled(bl);
    }

    public void setDatabase(OracleDatabaseImpl oracleDatabaseImpl) {
        this.oraDb = oracleDatabaseImpl;
        this.cubeBuilder = new CubeBuilder(oracleDatabaseImpl);
    }

    private void layoutComponents() {
        this.aggOperatorTablePanel = new OLAPListTablePanel<CubeAggregationDimension>(this.aggregationTableModel);
        this.aggOperatorTablePanel.setName("aggOperatorTablePanel");
        this.aggOperatorTablePanel.setEditable(true);
        JTable jTable = this.aggOperatorTablePanel.getTable();
        jTable.setName("aggregationOperatorTable");
        jTable.setAutoResizeMode(4);
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(2);
        tableColumn.setCellEditor(new AggOperatorCellEditor());
        TableColumn tableColumn2 = tableColumnModel.getColumn(3);
        tableColumn2.setCellEditor(new AggBasedOnCellEditor());
        TableColumn tableColumn3 = tableColumnModel.getColumn(4);
        tableColumn3.setCellEditor(new AggLevelCellEditor());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 5;
        this.add((Component)((Object)this.aggOperatorTablePanel), gridBagConstraints);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        Object object2;
        Object object3;
        String string;
        Object object4 = propertyChangeEvent.getNewValue();
        if (object4 instanceof TreePath) {
            string = propertyChangeEvent.getPropertyName();
            object3 = (TreePath)object4;
            object2 = ((TreePath)object3).getLastPathComponent();
            if (string.equalsIgnoreCase("NODE_SELECTED")) {
                if (object2 instanceof HierarchyNode) {
                    object = (HierarchyNode)object2;
                    var7_7 = (CubeDimensionHierarchy)((DefaultMutableTreeNode)object).getUserObject();
                    this._selectHierarchy((CubeDimensionHierarchy)var7_7);
                } else if (object2 instanceof DimensionNode) {
                    object = (DimensionNode)object2;
                    var7_7 = (CubeDimension)((DefaultMutableTreeNode)object).getUserObject();
                    this._selectDimension((CubeDimension)var7_7);
                }
            } else if (string.equalsIgnoreCase("NODE_UNSELECTED")) {
                if (object2 instanceof HierarchyNode) {
                    object = (HierarchyNode)object2;
                    var7_7 = (CubeDimensionHierarchy)((DefaultMutableTreeNode)object).getUserObject();
                    this._unselectHierarchy((CubeDimensionHierarchy)var7_7);
                } else if (object2 instanceof DimensionNode) {
                    object = (DimensionNode)object2;
                    var7_7 = (CubeDimension)((DefaultMutableTreeNode)object).getUserObject();
                    this._unselectDimension((CubeDimension)var7_7);
                }
            }
        }
        if (object4 instanceof CubeAggregationDimension) {
            string = propertyChangeEvent.getPropertyName();
            object3 = (CubeAggregationDimension)object4;
            object2 = ((CubeAggregationDimension)object3).getName();
            object = ((CubeAggregationDimension)object3).getAggregationHierarchies();
            if (object == null) {
                object = new ArrayList();
            }
            if (string.equalsIgnoreCase("NODE_SELECTED")) {
                if (object.size() == 0) {
                    for (CubeDimension cubeDimension : this.cube.getDimensions(this.allDimensionListObject)) {
                        String string2 = cubeDimension.getName();
                        if (!string2.equalsIgnoreCase((String)object2)) continue;
                        CubeDimensionHierarchy[] cubeDimensionHierarchyArray = cubeDimension.getHierarchies();
                        for (int i = 0; i < cubeDimensionHierarchyArray.length; ++i) {
                            object.add(cubeDimensionHierarchyArray[i]);
                        }
                        break;
                    }
                }
            } else if (string.equalsIgnoreCase("NODE_UNSELECTED") && object.size() > 0) {
                object.clear();
            }
            ((CubeAggregationDimension)object3).setAggregationHierarchies((List<CubeDimensionHierarchy>)object);
        }
    }

    private void _unselectDimension(CubeDimension cubeDimension) {
        List list = this.aggregationTableModel.getRowList();
        for (CubeAggregationDimension cubeAggregationDimension : list) {
            String string = cubeAggregationDimension.getName();
            if (!string.equalsIgnoreCase(cubeDimension.getName())) continue;
            cubeAggregationDimension.setAggregationOperator("NOAGG");
            cubeAggregationDimension.setAggregationBasedOnMeasure("");
            cubeAggregationDimension.setAggregationFromLevel(null);
            cubeAggregationDimension.setAggregationHierarchies(new ArrayList<CubeDimensionHierarchy>());
            break;
        }
        this.aggregationTableModel.enablePropertyChangeListeners(false);
        this.aggregationTableModel.setRowList(list);
        this.aggOperatorTablePanel.repaint();
        this.aggregationTableModel.enablePropertyChangeListeners(true);
    }

    private void _selectDimension(CubeDimension cubeDimension) {
        List list = this.aggregationTableModel.getRowList();
        ArrayList<CubeDimensionHierarchy> arrayList = new ArrayList<CubeDimensionHierarchy>();
        CubeDimensionHierarchy[] cubeDimensionHierarchyArray = cubeDimension.getHierarchies();
        for (int i = 0; i < cubeDimensionHierarchyArray.length; ++i) {
            arrayList.add(cubeDimensionHierarchyArray[i]);
        }
        for (CubeAggregationDimension cubeAggregationDimension : list) {
            String string = cubeAggregationDimension.getName();
            if (!string.equalsIgnoreCase(cubeDimension.getName())) continue;
            String string2 = cubeAggregationDimension.getAggregationOperator();
            if (!string2.equalsIgnoreCase("NOAGG")) continue;
            cubeAggregationDimension.setAggregationOperator("SUM");
            cubeAggregationDimension.setAggregationFromLevel(null);
            cubeAggregationDimension.setAggregationHierarchies(arrayList);
            break;
        }
        this.aggregationTableModel.enablePropertyChangeListeners(false);
        this.aggregationTableModel.setRowList(list);
        this.aggOperatorTablePanel.repaint();
        this.aggregationTableModel.enablePropertyChangeListeners(true);
    }

    private void _unselectHierarchy(CubeDimensionHierarchy cubeDimensionHierarchy) {
        CubeDimension cubeDimension = cubeDimensionHierarchy.getCubeDimension();
        List list = this.aggregationTableModel.getRowList();
        block0: for (CubeAggregationDimension cubeAggregationDimension : list) {
            String string = cubeAggregationDimension.getName();
            if (!string.equalsIgnoreCase(cubeDimension.getName())) continue;
            List<CubeDimensionHierarchy> list2 = cubeAggregationDimension.getAggregationHierarchies();
            if (list2.contains(cubeDimensionHierarchy)) {
                list2.remove(cubeDimensionHierarchy);
            }
            if (list2.size() == 0) {
                this._unselectDimension(cubeDimension);
                break;
            }
            CubeDimensionHierarchyLevel[] cubeDimensionHierarchyLevelArray = cubeDimensionHierarchy.getHierarchyLevels();
            for (int i = 0; i < cubeDimensionHierarchyLevelArray.length; ++i) {
                CubeDimensionLevel cubeDimensionLevel = cubeDimensionHierarchyLevelArray[i].getLevel();
                String string2 = cubeDimensionLevel.getName();
                if (!cubeAggregationDimension.getAggregationFromLevel().equalsIgnoreCase(string2)) continue;
                cubeAggregationDimension.setAggregationFromLevel(null);
                break block0;
            }
        }
        this.aggregationTableModel.enablePropertyChangeListeners(false);
        this.aggregationTableModel.setRowList(list);
        this.aggOperatorTablePanel.repaint();
        this.aggregationTableModel.enablePropertyChangeListeners(true);
    }

    private void _selectHierarchy(CubeDimensionHierarchy cubeDimensionHierarchy) {
        CubeDimension cubeDimension = cubeDimensionHierarchy.getCubeDimension();
        List list = this.aggregationTableModel.getRowList();
        for (CubeAggregationDimension cubeAggregationDimension : list) {
            String string = cubeAggregationDimension.getName();
            if (!string.equalsIgnoreCase(cubeDimension.getName())) continue;
            List<CubeDimensionHierarchy> list2 = cubeAggregationDimension.getAggregationHierarchies();
            if (list2.contains(cubeDimensionHierarchy)) break;
            list2.add(cubeDimensionHierarchy);
            if (list2.size() != 1) break;
            String string2 = cubeAggregationDimension.getAggregationOperator();
            if (!string2.equalsIgnoreCase("NOAGG")) break;
            cubeAggregationDimension.setAggregationOperator("SUM");
            cubeAggregationDimension.setAggregationFromLevel(null);
            break;
        }
        this.aggregationTableModel.enablePropertyChangeListeners(false);
        this.aggregationTableModel.setRowList(list);
        this.aggOperatorTablePanel.repaint();
        this.aggregationTableModel.enablePropertyChangeListeners(true);
    }

    public List<CubeAggregationDimension> getAggregationDimensions() {
        ArrayList<CubeAggregationDimension> arrayList = new ArrayList();
        arrayList = this.aggregationTableModel.getRowList();
        return arrayList;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        if (this.aggregationTableModel != null) {
            this.aggregationTableModel.addPropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.addPropertyChangeListener(propertyChangeListener);
        if (this.aggregationTableModel != null) {
            this.aggregationTableModel.removePropertyChangeListener(propertyChangeListener);
        }
    }

    private Cube getLikeDimensionedCube(String string) {
        Cube cube = null;
        if (string.equals(this.cube.getName())) {
            cube = this.cube;
        } else {
            NameBasedID nameBasedID = new NameBasedID("CUBE", this.cube.getSchema().getName(), string, (AbstractDBObjectProvider)this.oraDb);
            cube = this.cubeBuilder.createObject(string, this.cube.getSchema(), (DBObjectID)nameBasedID);
            try {
                CubeDimensionality[] cubeDimensionalityArray;
                this.cubeBuilder.buildFromCache(cube);
                for (CubeDimensionality cubeDimensionality : cubeDimensionalityArray = cube.getDimensions()) {
                    boolean bl = false;
                    String string2 = cubeDimensionality.getName();
                    for (CubeDimensionality cubeDimensionality2 : this.cube.getDimensions()) {
                        String string3 = cubeDimensionality2.getName();
                        if (!string3.equalsIgnoreCase(string2)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    cube = null;
                    break;
                }
            }
            catch (Exception exception) {
                cube = null;
                this.LOG.log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            }
        }
        return cube;
    }

    private class LoadLikeDimensionedMeasures
    implements QueryWrapper.QueryRunnable {
        private LoadLikeDimensionedMeasures() {
        }

        public void processResultSet(ResultSet resultSet) {
            try {
                while (resultSet.next()) {
                    Object object;
                    int n;
                    Cube cube = AggregationOperatorPanel.this.getLikeDimensionedCube(resultSet.getString(1));
                    if (cube == null) continue;
                    CubeMeasure[] cubeMeasureArray = cube.getMeasures();
                    AbstractChildObjectWithDesc[] abstractChildObjectWithDescArray = cubeMeasureArray;
                    int n2 = abstractChildObjectWithDescArray.length;
                    for (n = 0; n < n2; ++n) {
                        CubeMeasure cubeMeasure = abstractChildObjectWithDescArray[n];
                        object = cube.getName() + "." + cubeMeasure.getName();
                        AggregationOperatorPanel.this.measuresComboBoxModel.addElement(object);
                    }
                    AbstractChildObjectWithDesc[] abstractChildObjectWithDescArray2 = abstractChildObjectWithDescArray = cube.getCalculatedMeasures();
                    n = abstractChildObjectWithDescArray2.length;
                    for (int i = 0; i < n; ++i) {
                        object = abstractChildObjectWithDescArray2[i];
                        String string = cube.getName() + "." + object.getName();
                        AggregationOperatorPanel.this.measuresComboBoxModel.addElement(string);
                    }
                }
            }
            catch (SQLException sQLException) {
                AggregationOperatorPanel.this.LOG.log(Level.SEVERE, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }
    }

    class AggOperatorCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox cboOperators = new JComboBox();

        public AggOperatorCellEditor() {
            this.cboOperators.setName("cboOperators");
            Set set = AggregationOperatorPanel.this.aggOperatorMap.keySet();
            Object[] objectArray = set.toArray();
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)AggregationOperatorPanel.this.aggOperatorMap.get(objectArray[i]);
                this.cboOperators.addItem(string);
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = (String)((OLAPListTableModel)AggregationOperatorPanel.this.aggregationTableModel).getValueAt(n, n2);
            this.cboOperators.setSelectedItem(string);
            return this.cboOperators;
        }

        @Override
        public Object getCellEditorValue() {
            String string = "SUM";
            string = (String)this.cboOperators.getSelectedItem();
            return string;
        }
    }

    class AggBasedOnCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox cboMeasures = new JComboBox();

        public AggBasedOnCellEditor() {
            this.cboMeasures.setName("cboMeasures");
            this.cboMeasures.setModel(AggregationOperatorPanel.this.measuresComboBoxModel);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = (String)((OLAPListTableModel)AggregationOperatorPanel.this.aggregationTableModel).getValueAt(n, n2);
            this.cboMeasures.setSelectedItem(string);
            return this.cboMeasures;
        }

        @Override
        public Object getCellEditorValue() {
            String string = null;
            Object object = this.cboMeasures.getSelectedItem();
            if (object != null) {
                string = this.cboMeasures.getSelectedItem().toString();
            }
            return string;
        }
    }

    class AggLevelCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox cboLevels = new JComboBox();

        public AggLevelCellEditor() {
            this.cboLevels.setName("cboLevels");
            this.cboLevels.addItem(OLAPArb.get("AGGREGATE.FROM.LEVEL.DEFAULT"));
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            List list = AggregationOperatorPanel.this.aggregationTableModel.getRowList();
            CubeAggregationDimension cubeAggregationDimension = (CubeAggregationDimension)list.get(n);
            this.cboLevels.removeAllItems();
            List<CubeDimensionHierarchy> list2 = cubeAggregationDimension.getAggregationHierarchies();
            ArrayList<CubeDimensionLevel> arrayList = new ArrayList<CubeDimensionLevel>();
            for (CubeDimensionHierarchy cubeSubDimension : list2) {
                CubeDimensionHierarchyLevel[] cubeDimensionHierarchyLevelArray = cubeSubDimension.getHierarchyLevels();
                for (int i = 0; i < cubeDimensionHierarchyLevelArray.length; ++i) {
                    CubeDimensionLevel cubeDimensionLevel = cubeDimensionHierarchyLevelArray[i].getLevel();
                    if (arrayList.contains(cubeDimensionLevel)) continue;
                    arrayList.add(cubeDimensionLevel);
                }
            }
            for (CubeDimensionLevel cubeDimensionLevel : arrayList) {
                this.cboLevels.addItem(cubeDimensionLevel.getName());
            }
            this.cboLevels.addItem(OLAPArb.get("AGGREGATE.FROM.LEVEL.DEFAULT"));
            String string = (String)((OLAPListTableModel)AggregationOperatorPanel.this.aggregationTableModel).getValueAt(n, n2);
            this.cboLevels.setSelectedItem(string);
            return this.cboLevels;
        }

        @Override
        public Object getCellEditorValue() {
            String string = OLAPArb.get("AGGREGATE.FROM.LEVEL.DEFAULT");
            string = this.cboLevels.getSelectedItem().toString();
            return string;
        }
    }
}

