/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.cube.panels;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.olap.OLAPArb;
import oracle.olap.app.db.OracleSQLDataType;
import oracle.olap.app.ui.DataTypeUI;
import oracle.olap.cube.model.Cube;
import oracle.olap.cube.model.CubeDimensionality;
import oracle.olap.cube.panels.CubeSparsityTableModel;
import oracle.olap.util.OLAPListTablePanel;

public class CubeStoragePanel
extends BaseEditorPanel<Cube> {
    private JCheckBox compressCheckBox;
    private DataTypeUI dataTypeUI;
    private JCheckBox globalCompositesCheckBox;
    private CubeSparsityTableModel sparseTableModel = new CubeSparsityTableModel();
    private JPanel dimSparsityPanel;

    public CubeStoragePanel() {
        this.layoutComponents();
    }

    protected void initialisePanel() {
        Cube cube = (Cube)this.getUpdatedObject();
        CubeDimensionality[] cubeDimensionalityArray = cube.getDimensions();
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, cubeDimensionalityArray);
        this.sparseTableModel.setRowList(arrayList);
        this.compressCheckBox.setSelected(cube.isCompress());
        String string = cube.getSqlCubeStorageType();
        OracleSQLDataType oracleSQLDataType = new OracleSQLDataType(string);
        this.dataTypeUI.setDataType(oracleSQLDataType.getDataType());
        this.dataTypeUI.setDataTypeScale(oracleSQLDataType.getDataTypeScale());
        this.dataTypeUI.setDataTypeSize(oracleSQLDataType.getDataTypeSize());
        this.dataTypeUI.setEnabled(this.compressCheckBox.isSelected());
        String string2 = cube.getSparseType();
        if (this.compressCheckBox.isSelected()) {
            this.globalCompositesCheckBox.setSelected(false);
            this.globalCompositesCheckBox.setEnabled(false);
        } else if (string2.equalsIgnoreCase("SPARSE_GLOBAL")) {
            this.globalCompositesCheckBox.setSelected(true);
            this.globalCompositesCheckBox.setEnabled(true);
        }
    }

    protected void commitPanel() throws TraversalException {
        int n;
        Cube cube = (Cube)this.getUpdatedObject();
        boolean bl = cube.isMVOn();
        boolean bl2 = cube.isPartitioned();
        List list = this.sparseTableModel.getRowList();
        CubeDimensionality[] cubeDimensionalityArray = list.toArray(new CubeDimensionality[list.size()]);
        boolean bl3 = true;
        CubeDimensionality[] cubeDimensionalityArray2 = ((Cube)this.getUpdatedObject()).getDimensions();
        if (cubeDimensionalityArray.length == cubeDimensionalityArray2.length) {
            for (n = 0; n < cubeDimensionalityArray.length; ++n) {
                if (!cubeDimensionalityArray2[n].getName().equals(cubeDimensionalityArray[n].getName())) {
                    bl3 = false;
                    break;
                }
                if (cubeDimensionalityArray2[n].isSparse() == cubeDimensionalityArray[n].isSparse()) continue;
                bl3 = false;
                break;
            }
        }
        if (!bl3) {
            cube.setDimensions(cubeDimensionalityArray);
        }
        n = 1;
        for (CubeDimensionality object2 : cubeDimensionalityArray) {
            if (object2.isSparse()) {
                n = 0;
            }
            if (object2.isSparse() || n != 0) continue;
            throw new TraversalException(OLAPArb.get("CUBE_STORAGE_DENSE_DIM_CANNOT_FOLLOW_SPARSE_ERROR_MSG"));
        }
        if (this.compressCheckBox.isSelected()) {
            if (n != 0) {
                throw new TraversalException(OLAPArb.get("CUBE_STORAGE_COMPRESSION_ONE_DIM_MUST_BE_SPARSE_ERROR_MSG"));
            }
            cube.setSparseType("COMPRESSED");
            cube.setMeasureStorage("SHARED");
            cube.setPrecomputeCondition(null);
            var9_9 = cube.getMeasures();
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.dataTypeUI.getSQLDataType();
            for (AbstractChildDBObject abstractChildDBObject : var9_9) {
                String string2 = abstractChildDBObject.getConsistentSolveSpec();
                if (string2 != null) {
                    stringBuffer.append("\n");
                    stringBuffer.append(abstractChildDBObject.getName());
                    continue;
                }
                String string3 = abstractChildDBObject.getDataType();
                boolean bl4 = abstractChildDBObject.isMeasureAllowAutoDataTypeChange();
                if (bl4 || string == null || string.equalsIgnoreCase(string3)) continue;
                int n2 = string.indexOf("(");
                if (n2 != -1) {
                    string = string.substring(0, n2);
                }
                if (string.equalsIgnoreCase("NUMBER") || string.equalsIgnoreCase("DECIMAL") || string.equalsIgnoreCase("INTEGER")) {
                    n2 = string3.indexOf("(");
                    if (n2 != -1) {
                        string3 = string3.substring(0, n2);
                    }
                    if (string3.equalsIgnoreCase("NUMBER") || string3.equalsIgnoreCase("DECIMAL") || string3.equalsIgnoreCase("INTEGER")) continue;
                    stringBuffer.append("\n");
                    stringBuffer.append(abstractChildDBObject.getName());
                    continue;
                }
                stringBuffer.append("\n");
                stringBuffer.append(abstractChildDBObject.getName());
            }
            if (stringBuffer.length() > 0) {
                throw new TraversalException(OLAPArb.format("CUBE_STORAGE_COMPRESSION_MEAS_AGG_ERROR_MSG", stringBuffer));
            }
            Integer n3 = cube.getPrecomputePercent();
            if (n3 == null && !cube.isPartitioned()) {
                cube.setPrecomputePercent(40);
            }
        } else {
            if (bl) {
                throw new TraversalException(OLAPArb.get("CUBE_STORAGE_COMPRESSION_MV_ERROR_MSG"));
            }
            if (bl2) {
                AbstractChildDBObject abstractChildDBObject;
                int n3;
                var9_9 = cube.getPartitions();
                if (var9_9.length > 1) {
                    throw new TraversalException(OLAPArb.get("CUBE_STORAGE_COMPRESSION_PARTITION_ERROR_MSG"));
                }
                if (var9_9.length == 1 && (n3 = (abstractChildDBObject = var9_9[0]).getPrecomputePercent()) != 0) {
                    abstractChildDBObject.setPrecomputePercent(0);
                }
            }
            cube.setSparseType("SPARSE");
            cube.setMeasureStorage("INDEPENDENT");
            cube.setPrecomputePercent(0);
        }
        if (this.globalCompositesCheckBox.isSelected()) {
            boolean bl5 = cube.isPartitioned();
            boolean bl6 = cubeDimensionalityArray.length >= 2;
            boolean bl7 = true;
            String string = cube.getPartitionDimensionName();
            for (CubeDimensionality cubeDimensionality : cubeDimensionalityArray) {
                if (cubeDimensionality.isSparse() || string == null || !string.equalsIgnoreCase(cubeDimensionality.getName())) continue;
                bl7 = false;
                break;
            }
            if (!bl5 || bl7) {
                throw new TraversalException(OLAPArb.get("CUBE_STORAGE_COMPOSITEINDEX_NOT_PARTITIONED_ERROR_MSG"));
            }
            if (!bl6) {
                throw new TraversalException(OLAPArb.get("CUBE_STORAGE_COMPOSITEINDEX_HAS2DIMS_ERROR_MSG"));
            }
            if (n != 0) {
                throw new TraversalException(OLAPArb.get("CUBE_STORAGE_ONE_DIM_MUST_BE_COMPOSITEINDEX_ERROR_MSG"));
            }
            cube.setSparseType("SPARSE_GLOBAL");
        }
        if (n != 0) {
            cube.setSparseType("DENSE");
        }
        String string = this.dataTypeUI.getSQLDataType();
        cube.setSqlCubeStorageType(string);
    }

    private void layoutComponents() {
        this.setName(((Object)((Object)this)).getClass().getName());
        ComponentFactory componentFactory = this.getComponentFactory();
        String string = OLAPArb.get("CUBE.STORAGE.DESC");
        JTextArea jTextArea = new JTextArea(string, 3, 45);
        jTextArea.setName("descLabel");
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setBackground(new JLabel().getBackground());
        jTextArea.setFocusable(false);
        this.compressCheckBox = new JCheckBox(OLAPArb.get("CUBE.STORAGE.USE.COMPRESSION.CHECKBOX.LABEL"));
        this.compressCheckBox.setName("compressCheckBox");
        componentFactory = null;
        this.dataTypeUI = new DataTypeUI(componentFactory);
        this.globalCompositesCheckBox = new JCheckBox(OLAPArb.get("CUBE.STORAGE.USE.GLOBAL.COMPOSITES.CHECKBOX.LABEL"));
        this.globalCompositesCheckBox.setName("globalCompositesCheckBox");
        this.dimSparsityPanel = this.getDimSparsityPanel();
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.add(jTextArea, new GridBagConstraints(0, n, 2, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.compressCheckBox, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.dataTypeUI.getDataTypeLabel(), new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.dataTypeUI.getDataTypeComboBox(), new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.dataTypeUI.getDataTypeSizeLabel(), new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.dataTypeUI.getDataTypeSizeTextField(), new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.dataTypeUI.getDataTypeScaleLabel(), new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.dataTypeUI.getDataTypeScaleTextField(), new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.globalCompositesCheckBox, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.dimSparsityPanel, new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 12), 0, 0));
        this.compressCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = CubeStoragePanel.this.compressCheckBox.isSelected();
                CubeStoragePanel.this.dataTypeUI.setEnabled(bl);
                if (bl) {
                    CubeStoragePanel.this.globalCompositesCheckBox.setSelected(false);
                    CubeStoragePanel.this.globalCompositesCheckBox.setEnabled(false);
                } else {
                    CubeStoragePanel.this.globalCompositesCheckBox.setEnabled(true);
                }
            }
        });
    }

    private JPanel getDimSparsityPanel() {
        OLAPListTablePanel<CubeDimensionality> oLAPListTablePanel = new OLAPListTablePanel<CubeDimensionality>(this.sparseTableModel);
        oLAPListTablePanel.setEditable(true);
        oLAPListTablePanel.setMinimumSize(new Dimension(60, 125));
        JTable jTable = oLAPListTablePanel.getTable();
        jTable.setAutoResizeMode(4);
        jTable.setSelectionMode(0);
        return oLAPListTablePanel;
    }
}

