/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.build.wizard;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.olap.OLAPArb;
import oracle.olap.build.BuildObject;
import oracle.olap.build.wizard.BuildObjectsTableModel;

public class BuildObjectsTable
extends JTable {
    private BuildObjectsTableModel model;

    public BuildObjectsTable(BuildObjectsTableModel buildObjectsTableModel) {
        super(buildObjectsTableModel);
        this.model = buildObjectsTableModel;
        this.setAutoResizeMode(4);
        TableColumnModel tableColumnModel = this.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(2);
        tableColumn.setCellEditor(new myLoadOptionsCellEditor());
        TableColumn tableColumn2 = tableColumnModel.getColumn(4);
        tableColumn2.setCellEditor(new myRefreshMethodsCellEditor());
        TableColumn tableColumn3 = tableColumnModel.getColumn(5);
        tableColumn3.setCellEditor(new myCubeScriptsCellEditor());
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        Point point = mouseEvent.getPoint();
        int n = this.rowAtPoint(point);
        int n2 = this.columnAtPoint(point);
        if (n2 == 0 || n2 == 1 || n2 == 4) {
            string = (String)this.getValueAt(n, n2);
            if (string != null && string.length() == 0) {
                string = null;
            }
        } else if (n2 == 5) {
            List<BuildObject> list = this.model.getRowList();
            BuildObject buildObject = list.get(n);
            string = buildObject.getBuildSpecification();
            if (string != null && string.length() == 0) {
                string = null;
            }
        } else {
            String string2;
            string = n2 == 2 ? ((string2 = (String)this.getValueAt(n, n2)).equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_SYNCH_LABEL")) ? OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADSYNCH_TOOLTIP") : (string2.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADNOSYNCH_LABEL")) ? OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADNOSYNCH_TOOLTIP") : (string2.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADRETAIN_LABEL")) ? OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADRETAIN_TOOLTIP") : string2))) : super.getToolTipText(mouseEvent);
        }
        return string;
    }

    class myLoadOptionsCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox cboOptions = new JComboBox();
        private String strCurrentOption = OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADNOSYNCH_LABEL");

        public myLoadOptionsCellEditor() {
            this.cboOptions.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_SYNCH_LABEL"));
            this.cboOptions.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADNOSYNCH_LABEL"));
            this.cboOptions.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADRETAIN_LABEL"));
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = (String)jTable.getModel().getValueAt(n, 1);
            if (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_DIMMV_LABEL"))) {
                this.cboOptions = new JComboBox();
                this.cboOptions.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_SYNCH_LABEL"));
            } else if (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_DIM_LABEL"))) {
                this.cboOptions = new JComboBox();
                this.cboOptions.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_SYNCH_LABEL"));
                this.cboOptions.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADNOSYNCH_LABEL"));
                this.cboOptions.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_LOADRETAIN_LABEL"));
            }
            if (this.cboOptions != null && object != null) {
                this.cboOptions.setSelectedItem(object);
            }
            return this.cboOptions;
        }

        @Override
        public Object getCellEditorValue() {
            this.strCurrentOption = (String)this.cboOptions.getSelectedItem();
            return this.strCurrentOption;
        }
    }

    class myRefreshMethodsCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox cboMethods = new JComboBox();
        private String strCurrentMethod = OLAPArb.get("BUILD_WIZARD_REF_METHODS_COMPLETE_LABEL");

        public myRefreshMethodsCellEditor() {
            this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_COMPLETE_LABEL"));
            this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_FAST_LABEL"));
            this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_FORCE_LABEL"));
            this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_PCT_LABEL"));
            this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_SOLVE_LABEL"));
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = (String)jTable.getModel().getValueAt(n, 1);
            List<BuildObject> list = ((BuildObjectsTableModel)jTable.getModel()).getRowList();
            BuildObject buildObject = list.get(n);
            if (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_DIM_LABEL")) || string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_DIMMV_LABEL"))) {
                this.cboMethods = new JComboBox();
                this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_COMPLETE_LABEL"));
            } else if (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_CUBE_LABEL"))) {
                this.cboMethods = new JComboBox();
                this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_COMPLETE_LABEL"));
                this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_SOLVE_LABEL"));
            } else if (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_CUBEMV_LABEL"))) {
                this.cboMethods = new JComboBox();
                if (buildObject.isFastRefreshable()) {
                    this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_COMPLETE_LABEL"));
                    this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_FAST_LABEL"));
                    this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_FORCE_LABEL"));
                    this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_PCT_LABEL"));
                    this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_SOLVE_LABEL"));
                } else {
                    this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_COMPLETE_LABEL"));
                    this.cboMethods.addItem(OLAPArb.get("BUILD_WIZARD_REF_METHODS_FORCE_LABEL"));
                }
            }
            if (this.cboMethods != null && object != null) {
                this.cboMethods.setSelectedItem(object);
            }
            return this.cboMethods;
        }

        @Override
        public Object getCellEditorValue() {
            this.strCurrentMethod = (String)this.cboMethods.getSelectedItem();
            return this.strCurrentMethod;
        }
    }

    class myCubeScriptsCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox cboScripts = new JComboBox();
        private String strCurrentScript;

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = (String)jTable.getModel().getValueAt(n, 1);
            List<BuildObject> list = ((BuildObjectsTableModel)jTable.getModel()).getRowList();
            BuildObject buildObject = list.get(n);
            List<Object> list2 = new ArrayList();
            try {
                list2 = buildObject.getCubeScriptNames();
            }
            catch (Exception exception) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)exception.getMessage(), (String)OLAPArb.get("BUILD_WIZARD_ERROR_DLG_TITLE"), null);
            }
            this.cboScripts = new JComboBox();
            if (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_CUBE_LABEL"))) {
                for (String string2 : list2) {
                    this.cboScripts.addItem(string2);
                }
            } else if (string.equalsIgnoreCase(OLAPArb.get("BUILD_WIZARD_REF_METHODS_CUBEMV_LABEL"))) {
                if (buildObject.isFastRefreshable() || buildObject.isMVRewriteEnabled()) {
                    this.cboScripts.addItem(buildObject.getDefaultBuildSpecificationName());
                } else {
                    for (String string3 : list2) {
                        this.cboScripts.addItem(string3);
                    }
                }
            }
            if (this.cboScripts != null && object != null) {
                this.cboScripts.setSelectedItem(object);
            }
            return this.cboScripts;
        }

        @Override
        public Object getCellEditorValue() {
            this.strCurrentScript = (String)this.cboScripts.getSelectedItem();
            return this.strCurrentScript;
        }
    }
}

